/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.ints.IntCollection;
import edu.emory.mathcs.util.collections.ints.IntIterator;

public abstract class AbstractIntCollection
implements IntCollection {
    public int size() {
        int size64 = this.size64();
        if (size64 > 0 && size64 <= Integer.MAX_VALUE) {
            return size64;
        }
        if (size64 == 0 && !this.contains(0)) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public int size64() {
        int size = 0;
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(int e) {
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() != e) continue;
            return true;
        }
        return false;
    }

    public abstract IntIterator iterator();

    public int[] toArray() {
        int[] a = new int[this.size()];
        int i = 0;
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    public int[] toArray(int[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new int[size];
        }
        int i = 0;
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    public boolean add(int e) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(int e) {
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() != e) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(IntCollection c) {
        IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(IntCollection c) {
        boolean modified = false;
        IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    public boolean retainAll(IntCollection c) {
        boolean modified = false;
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(IntCollection c) {
        boolean modified = false;
        if (c == this) {
            modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public void clear() {
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    public String toString() {
        IntIterator itr = this.iterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }
}

