/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.ints.AbstractIntCollection;
import edu.emory.mathcs.util.collections.ints.IntCollection;
import edu.emory.mathcs.util.collections.ints.IntInterval;
import edu.emory.mathcs.util.collections.ints.IntIterator;
import edu.emory.mathcs.util.collections.ints.IntSet;
import edu.emory.mathcs.util.collections.ints.IntSortedSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIntSet
extends AbstractIntCollection
implements IntSet {
    protected AbstractIntSet() {
    }

    public int min() {
        return Integer.MIN_VALUE;
    }

    public int max() {
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet that = (IntSet)obj;
        if (this.size64() != that.size64()) {
            return false;
        }
        try {
            return this.containsAll(that);
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public int hashCode() {
        int h = 0;
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            h += AbstractIntSet.hash(itr.next());
        }
        return h;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean addAll(IntCollection c) {
        if (c instanceof IntInterval) {
            IntInterval r = (IntInterval)c;
            return this.addInterval(r.first(), r.last());
        }
        if (c instanceof IntSortedSet) {
            boolean modified = false;
            Iterator itr = ((IntSortedSet)c).intervalIterator();
            while (itr.hasNext()) {
                IntInterval r = (IntInterval)itr.next();
                modified |= this.addInterval(r.first(), r.last());
            }
            return modified;
        }
        return super.addAll(c);
    }

    public boolean removeAll(IntCollection c) {
        if (c instanceof IntInterval) {
            IntInterval r = (IntInterval)c;
            return this.removeInterval(r.first(), r.last());
        }
        if (c instanceof IntSortedSet) {
            boolean modified = false;
            Iterator itr = ((IntSortedSet)c).intervalIterator();
            while (itr.hasNext()) {
                IntInterval r = (IntInterval)itr.next();
                modified |= this.removeInterval(r.first(), r.last());
            }
            return modified;
        }
        if (this.size() <= c.size()) {
            return super.removeAll(c);
        }
        boolean modified = false;
        IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            modified |= this.remove(itr.next());
        }
        return modified;
    }

    public boolean retainAll(IntCollection c) {
        if (c instanceof IntInterval) {
            IntInterval r = (IntInterval)c;
            return this.retainInterval(r.first(), r.last());
        }
        return super.retainAll(c);
    }

    public boolean containsInterval(int first, int last) {
        if (first > last) {
            return true;
        }
        if (first == last) {
            return this.contains(first);
        }
        int min = this.min();
        int max = this.max();
        if (first < min || last > max) {
            return false;
        }
        int len = last - first + 1;
        if (len > this.size()) {
            return false;
        }
        for (int e = first; e <= last; ++e) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean addInterval(int first, int last) {
        int min = this.min();
        int max = this.max();
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        boolean modified = false;
        for (int e = first; e <= last; ++e) {
            modified |= this.add(e);
        }
        return modified;
    }

    public boolean removeInterval(int first, int last) {
        int min = this.min();
        int max = this.max();
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        boolean modified = false;
        for (int e = first; e <= last; ++e) {
            modified |= this.remove(e);
        }
        return modified;
    }

    public boolean retainInterval(int first, int last) {
        boolean modified = false;
        IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            int e = itr.next();
            if (e < first || e > last) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public IntSet complementSet() {
        return new ComplementView(this);
    }

    private static final int hash(int e) {
        return e;
    }

    private static class ComplementIterator
    implements IntIterator {
        final IntSet base;
        final int min;
        final int max;
        int next;
        int curr;

        ComplementIterator(IntSet base, int min, int max) {
            this.base = base;
            this.min = min;
            this.max = max;
            this.next = min;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next <= this.max;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.fetchNext();
            return this.curr;
        }

        void fetchNext() {
            while (this.next <= this.max && this.base.contains(this.next)) {
                ++this.next;
            }
        }

        public void remove() {
            this.base.add(this.curr);
        }
    }

    private static class ComplementView
    extends AbstractIntSet {
        final IntSet base;

        ComplementView(IntSet base) {
            this.base = base;
        }

        public int min() {
            return this.base.min();
        }

        public int max() {
            return this.base.max();
        }

        public int size64() {
            return this.max() - this.min() + 1 - this.base.size64();
        }

        public boolean contains(int e) {
            return !this.base.contains(e);
        }

        public boolean add(int e) {
            return this.base.remove(e);
        }

        public boolean remove(int e) {
            return this.base.add(e);
        }

        public boolean addAll(IntCollection c) {
            return this.base.removeAll(c);
        }

        public boolean removeAll(IntCollection c) {
            return this.base.addAll(c);
        }

        public boolean addInterval(int first, int last) {
            return this.base.removeInterval(first, last);
        }

        public boolean removeInterval(int first, int last) {
            return this.base.addInterval(first, last);
        }

        public void clear() {
            this.base.addInterval(this.min(), this.max());
        }

        public IntSet complementSet() {
            return this.base;
        }

        public IntIterator iterator() {
            return new ComplementIterator(this.base, this.min(), this.max());
        }
    }
}

