/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.ints.AbstractIntCollection;
import edu.emory.mathcs.util.collections.ints.IntCollection;
import edu.emory.mathcs.util.collections.ints.IntIterator;
import edu.emory.mathcs.util.collections.ints.IntList;
import edu.emory.mathcs.util.collections.ints.IntListIterator;
import java.util.NoSuchElementException;

public class IntArrayList
extends AbstractIntCollection
implements IntList {
    int[] buffer;
    int size;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new int[initialCapacity];
    }

    public IntArrayList(IntCollection c) {
        int cap = c.size();
        cap += cap / 10;
        if (cap < 0) {
            cap = Integer.MAX_VALUE;
        }
        this.buffer = new int[cap];
        this.addAll(c);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            return true;
        }
        return false;
    }

    public IntIterator iterator() {
        return new Itr(0);
    }

    public int[] toArray() {
        int[] a = new int[this.size];
        System.arraycopy(this.buffer, 0, a, 0, this.size);
        return a;
    }

    public int[] toArray(int[] a) {
        if (a.length < this.size) {
            a = new int[this.size];
        }
        System.arraycopy(this.buffer, 0, a, 0, this.size);
        return a;
    }

    private void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (capacity > this.buffer.length) {
            int newlen = 2 * this.buffer.length;
            if (newlen < this.buffer.length) {
                newlen = Integer.MAX_VALUE;
            }
            if (newlen < capacity) {
                newlen = capacity;
            }
            int[] newbuf = new int[newlen];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.size);
            this.buffer = newbuf;
        }
    }

    public boolean add(int e) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size++] = e;
        return true;
    }

    public boolean remove(int e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            System.arraycopy(this.buffer, i + 1, this.buffer, i, this.size - i - 1);
            --this.size;
            return true;
        }
        return false;
    }

    public boolean addAll(IntCollection c) {
        this.ensureCapacity(this.size + c.size());
        IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            this.buffer[this.size++] = itr.next();
        }
        return true;
    }

    public boolean addAll(int index, IntCollection c) {
        int csize = c.size();
        this.ensureCapacity(this.size + csize);
        System.arraycopy(this.buffer, index, this.buffer, index + csize, this.size - index);
        IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            this.buffer[index++] = itr.next();
        }
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntList)) {
            return false;
        }
        IntList that = (IntList)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] == that.getAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + this.buffer[i];
        }
        return hashCode;
    }

    public int getAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.buffer[index];
    }

    public int setAt(int index, int e) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        int old = this.buffer[index];
        this.buffer[index] = e;
        return old;
    }

    public void addAt(int index, int e) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.size - index);
        this.buffer[index] = e;
        ++this.size;
    }

    public int removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        int e = this.buffer[index];
        System.arraycopy(this.buffer, index + 1, this.buffer, index, this.size - index - 1);
        --this.size;
        return e;
    }

    public int indexOf(int e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int e) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.buffer[i] != e) continue;
            return i;
        }
        return -1;
    }

    public IntListIterator listIterator() {
        return new Itr(0);
    }

    public IntListIterator listIterator(int index) {
        return new Itr(index);
    }

    public IntList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public int size64() {
        return this.size;
    }

    class Itr
    implements IntListIterator {
        int cursor = 0;
        int last = -1;

        Itr(int idx) {
            this.cursor = idx;
        }

        public int nextIndex() {
            return this.cursor;
        }

        public boolean hasNext() {
            return this.cursor < IntArrayList.this.size();
        }

        public int next() {
            try {
                int e = IntArrayList.this.getAt(this.cursor);
                this.last = ++this.cursor;
                return e;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public int previous() {
            try {
                int e = IntArrayList.this.getAt(this.cursor - 1);
                this.last = --this.cursor;
                return e;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void set(int e) {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            IntArrayList.this.setAt(this.last, e);
        }

        public void add(int e) {
            IntArrayList.this.addAt(this.cursor++, e);
            this.last = -1;
        }

        public void remove() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            IntArrayList.this.removeAt(this.last);
            if (this.last < this.cursor) {
                --this.cursor;
            }
            this.last = -1;
        }
    }
}

