/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.longs.AbstractLongCollection;
import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongInterval;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongSet;
import edu.emory.mathcs.util.collections.longs.LongSortedSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractLongSet
extends AbstractLongCollection
implements LongSet {
    protected AbstractLongSet() {
    }

    public long min() {
        return Long.MIN_VALUE;
    }

    public long max() {
        return Long.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongSet)) {
            return false;
        }
        LongSet that = (LongSet)obj;
        if (this.size64() != that.size64()) {
            return false;
        }
        try {
            return this.containsAll(that);
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public int hashCode() {
        int h = 0;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            h += AbstractLongSet.hash(itr.next());
        }
        return h;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean addAll(LongCollection c) {
        if (c instanceof LongInterval) {
            LongInterval r = (LongInterval)c;
            return this.addInterval(r.first(), r.last());
        }
        if (c instanceof LongSortedSet) {
            boolean modified = false;
            Iterator itr = ((LongSortedSet)c).intervalIterator();
            while (itr.hasNext()) {
                LongInterval r = (LongInterval)itr.next();
                modified |= this.addInterval(r.first(), r.last());
            }
            return modified;
        }
        return super.addAll(c);
    }

    public boolean removeAll(LongCollection c) {
        if (c instanceof LongInterval) {
            LongInterval r = (LongInterval)c;
            return this.removeInterval(r.first(), r.last());
        }
        if (c instanceof LongSortedSet) {
            boolean modified = false;
            Iterator itr = ((LongSortedSet)c).intervalIterator();
            while (itr.hasNext()) {
                LongInterval r = (LongInterval)itr.next();
                modified |= this.removeInterval(r.first(), r.last());
            }
            return modified;
        }
        if (this.size() <= c.size()) {
            return super.removeAll(c);
        }
        boolean modified = false;
        LongIterator itr = c.iterator();
        while (itr.hasNext()) {
            modified |= this.remove(itr.next());
        }
        return modified;
    }

    public boolean retainAll(LongCollection c) {
        if (c instanceof LongInterval) {
            LongInterval r = (LongInterval)c;
            return this.retainInterval(r.first(), r.last());
        }
        return super.retainAll(c);
    }

    public boolean containsInterval(long first, long last) {
        if (first > last) {
            return true;
        }
        if (first == last) {
            return this.contains(first);
        }
        long min = this.min();
        long max = this.max();
        if (first < min || last > max) {
            return false;
        }
        long len = last - first + 1L;
        if (len > (long)this.size()) {
            return false;
        }
        for (long e = first; e <= last; ++e) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean addInterval(long first, long last) {
        long min = this.min();
        long max = this.max();
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        boolean modified = false;
        for (long e = first; e <= last; ++e) {
            modified |= this.add(e);
        }
        return modified;
    }

    public boolean removeInterval(long first, long last) {
        long min = this.min();
        long max = this.max();
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        boolean modified = false;
        for (long e = first; e <= last; ++e) {
            modified |= this.remove(e);
        }
        return modified;
    }

    public boolean retainInterval(long first, long last) {
        boolean modified = false;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            long e = itr.next();
            if (e < first || e > last) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public LongSet complementSet() {
        return new ComplementView(this);
    }

    private static final int hash(long e) {
        return (int)(e & 0xFFFFFFFFFFFFFFFFL ^ e >>> 32);
    }

    private static class ComplementIterator
    implements LongIterator {
        final LongSet base;
        final long min;
        final long max;
        long next;
        long curr;

        ComplementIterator(LongSet base, long min, long max) {
            this.base = base;
            this.min = min;
            this.max = max;
            this.next = min;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next <= this.max;
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.fetchNext();
            return this.curr;
        }

        void fetchNext() {
            while (this.next <= this.max && this.base.contains(this.next)) {
                ++this.next;
            }
        }

        public void remove() {
            this.base.add(this.curr);
        }
    }

    private static class ComplementView
    extends AbstractLongSet {
        final LongSet base;

        ComplementView(LongSet base) {
            this.base = base;
        }

        public long min() {
            return this.base.min();
        }

        public long max() {
            return this.base.max();
        }

        public long size64() {
            return this.max() - this.min() + 1L - this.base.size64();
        }

        public boolean contains(long e) {
            return !this.base.contains(e);
        }

        public boolean add(long e) {
            return this.base.remove(e);
        }

        public boolean remove(long e) {
            return this.base.add(e);
        }

        public boolean addAll(LongCollection c) {
            return this.base.removeAll(c);
        }

        public boolean removeAll(LongCollection c) {
            return this.base.addAll(c);
        }

        public boolean addInterval(long first, long last) {
            return this.base.removeInterval(first, last);
        }

        public boolean removeInterval(long first, long last) {
            return this.base.addInterval(first, last);
        }

        public void clear() {
            this.base.addInterval(this.min(), this.max());
        }

        public LongSet complementSet() {
            return this.base;
        }

        public LongIterator iterator() {
            return new ComplementIterator(this.base, this.min(), this.max());
        }
    }
}

