/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.RadkeHashMap;
import edu.emory.mathcs.util.collections.longs.AbstractLongSet;
import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class LongRadkeHashSet
extends AbstractLongSet
implements Cloneable,
Serializable {
    transient long[] elements;
    transient byte[] states;
    transient int size;
    transient int fill;
    int treshold;
    final long min;
    final long max;
    final float loadFactor;
    final float resizeTreshold;
    private static final byte EMPTY = 0;
    private static final byte FULL = 1;
    private static final byte REMOVED = -1;

    public LongRadkeHashSet() {
        this(19);
    }

    public LongRadkeHashSet(int minInitialCapacity) {
        this(minInitialCapacity, 0.75f, 0.3f);
    }

    public LongRadkeHashSet(int minInitialCapacity, long min, long max) {
        this(minInitialCapacity, min, max, 0.75f, 0.3f);
    }

    public LongRadkeHashSet(int minInitialCapacity, float loadFactor, float resizeTreshold) {
        this(minInitialCapacity, Long.MIN_VALUE, Long.MAX_VALUE, loadFactor, resizeTreshold);
    }

    public LongRadkeHashSet(int minInitialCapacity, long min, long max, float loadFactor, float resizeTreshold) {
        int initialCapacity = RadkeHashMap.radkeAtLeast(minInitialCapacity);
        if (min > max) {
            throw new IllegalArgumentException();
        }
        this.min = min;
        this.max = max;
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be betweeen 0 and 1");
        }
        if (resizeTreshold <= 0.0f || resizeTreshold > 1.0f) {
            throw new IllegalArgumentException("Fill treshold must be betweeen 0 and 1");
        }
        this.elements = new long[initialCapacity];
        this.states = new byte[initialCapacity];
        this.size = 0;
        this.fill = 0;
        this.loadFactor = loadFactor;
        this.resizeTreshold = resizeTreshold;
        this.treshold = (int)(loadFactor * (float)initialCapacity);
    }

    public LongRadkeHashSet(LongSet m) {
        this(Math.max((int)((double)m.size() / 0.75) + 1, 19), m.min(), m.max());
        this.addAll(m);
    }

    public LongRadkeHashSet(LongCollection c) {
        this(Math.max((int)((double)c.size() / 0.75) + 1, 19), c instanceof LongSet ? ((LongSet)c).min() : Long.MIN_VALUE, c instanceof LongSet ? ((LongSet)c).max() : Long.MAX_VALUE);
        this.addAll(c);
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public boolean add(long elem) {
        if (elem < this.min || elem > this.max) {
            return false;
        }
        int hsize = this.elements.length;
        int p = LongRadkeHashSet.phash(elem) % hsize;
        int j = -hsize;
        int refill = -1;
        while (true) {
            byte state;
            if ((state = this.states[p]) == 0) {
                if (refill >= 0) {
                    this.elements[refill] = elem;
                    this.states[refill] = 1;
                    ++this.size;
                    return true;
                }
                this.elements[p] = elem;
                this.states[p] = 1;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    if ((float)this.size >= (float)this.fill * this.resizeTreshold) {
                        this.rehash(RadkeHashMap.radkeAtLeast(this.elements.length + 1));
                    } else {
                        this.rehash(this.elements.length);
                    }
                }
                return true;
            }
            if (state == -1) {
                refill = p;
            } else if (this.elements[p] == elem) {
                return false;
            }
            if ((p += (j += 2) > 0 ? j : -j) < hsize) continue;
            p -= hsize;
        }
    }

    public boolean contains(long elem) {
        return this.find(elem) >= 0;
    }

    public boolean remove(long elem) {
        int p = this.find(elem);
        if (p < 0) {
            return false;
        }
        this.states[p] = -1;
        --this.size;
        return true;
    }

    private int find(long elem) {
        if (elem < this.min || elem > this.max) {
            return -1;
        }
        int hsize = this.elements.length;
        int p = LongRadkeHashSet.phash(elem) % hsize;
        int j = -hsize;
        byte state;
        while ((state = this.states[p]) != 0) {
            if (this.elements[p] == elem) {
                return p;
            }
            if ((p += (j += 2) > 0 ? j : -j) < hsize) continue;
            p -= hsize;
        }
        return -1;
    }

    private void rehash(int newcapacity) {
        long[] oldelements = this.elements;
        byte[] oldstates = this.states;
        this.elements = new long[newcapacity];
        this.states = new byte[newcapacity];
        this.size = 0;
        this.fill = 0;
        this.treshold = (int)(this.loadFactor * (float)newcapacity);
        for (int i = 0; i < oldelements.length; ++i) {
            if (oldstates[i] != 1) continue;
            this.add(oldelements[i]);
        }
    }

    public void clear() {
        Arrays.fill(this.states, (byte)0);
        this.size = 0;
        this.fill = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long size64() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public LongIterator iterator() {
        return new HashIterator();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LongSet)) {
            return false;
        }
        LongSet that = (LongSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.states[i] != 1 || that.contains(this.elements[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.states[i] != 1) continue;
            hash += LongRadkeHashSet.hash(this.elements[i]);
        }
        return hash;
    }

    public Object clone() {
        LongRadkeHashSet result;
        try {
            result = (LongRadkeHashSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result.elements = new long[this.elements.length];
        result.states = new byte[this.states.length];
        result.fill = 0;
        result.size = 0;
        result.addAll(this);
        return result;
    }

    public boolean removeAll(LongCollection c) {
        boolean modified = false;
        if (this.elements.length * 2 < c.size()) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.states[i] != 1 || !c.contains(this.elements[i])) continue;
                this.states[i] = -1;
                --this.size;
                modified = true;
            }
        } else {
            LongIterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.remove(itr.next());
            }
        }
        return modified;
    }

    public boolean retainAll(LongCollection c) {
        boolean modified = false;
        if (this.elements.length * 4 < c.size()) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.states[i] != 1 || c.contains(this.elements[i])) continue;
                this.states[i] = -1;
                --this.size;
                modified = true;
            }
        } else {
            LongRadkeHashSet tmp = new LongRadkeHashSet(this.elements.length, this.loadFactor, this.resizeTreshold);
            LongIterator itr = c.iterator();
            while (itr.hasNext()) {
                long elem = itr.next();
                int p = this.find(elem);
                if (p < 0) continue;
                tmp.add(elem);
                modified = true;
            }
            if (modified) {
                this.elements = tmp.elements;
                this.states = tmp.states;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    public long[] toArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        }
        int i = 0;
        for (int j = 0; j < this.elements.length; ++j) {
            if (this.states[j] != 1) continue;
            a[i++] = this.elements[j];
        }
        return a;
    }

    public long[] toArray() {
        long[] a = new long[this.size()];
        int i = 0;
        for (int j = 0; j < this.elements.length; ++j) {
            if (this.states[j] != 1) continue;
            a[i++] = this.elements[j];
        }
        return a;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.elements.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.states[i] != 1) continue;
            out.writeLong(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.elements = new long[capacity];
        this.states = new byte[capacity];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            long elem = in.readLong();
            this.add(elem);
        }
    }

    private static final int hash(long e) {
        return (int)(e & 0xFFFFFFFFFFFFFFFFL ^ e >>> 32);
    }

    private static final int phash(long e) {
        return (int)(e & Integer.MAX_VALUE ^ e >>> 33);
    }

    private class HashIterator
    implements LongIterator {
        int curr = 0;
        int next = 0;

        HashIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next < LongRadkeHashSet.this.elements.length;
        }

        public long next() {
            if (this.next >= LongRadkeHashSet.this.elements.length) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.findNext();
            return LongRadkeHashSet.this.elements[this.curr];
        }

        private void findNext() {
            while (this.next < LongRadkeHashSet.this.elements.length && LongRadkeHashSet.this.states[this.next] != 1) {
                ++this.next;
            }
        }

        public void remove() {
            if (LongRadkeHashSet.this.states[this.curr] != -1) {
                LongRadkeHashSet.this.states[this.curr] = -1;
                --LongRadkeHashSet.this.size;
            }
        }
    }
}

