/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.shorts;

import edu.emory.mathcs.util.collections.shorts.ShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortIterator;

public abstract class AbstractShortCollection
implements ShortCollection {
    public int size() {
        int size = 0;
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            size = (short)(size + 1);
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(short e) {
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() != e) continue;
            return true;
        }
        return false;
    }

    public abstract ShortIterator iterator();

    public short[] toArray() {
        short[] a = new short[this.size()];
        int i = 0;
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    public short[] toArray(short[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new short[size];
        }
        int i = 0;
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    public boolean add(short e) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(short e) {
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() != e) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(ShortCollection c) {
        ShortIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(ShortCollection c) {
        boolean modified = false;
        ShortIterator itr = c.iterator();
        while (itr.hasNext()) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    public boolean retainAll(ShortCollection c) {
        boolean modified = false;
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(ShortCollection c) {
        boolean modified = false;
        if (c == this) {
            modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public void clear() {
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    public String toString() {
        ShortIterator itr = this.iterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }
}

