/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.shorts;

import edu.emory.mathcs.util.collections.shorts.AbstractShortSortedSet;
import edu.emory.mathcs.util.collections.shorts.ShortCollections;
import edu.emory.mathcs.util.collections.shorts.ShortInterval;
import edu.emory.mathcs.util.collections.shorts.ShortIterator;
import edu.emory.mathcs.util.collections.shorts.ShortSet;
import edu.emory.mathcs.util.collections.shorts.ShortSortedSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractShortInterval
extends AbstractShortSortedSet
implements ShortInterval {
    protected abstract short getFirst();

    protected abstract short getLast();

    public short min() {
        return this.getFirst();
    }

    public short max() {
        return this.getLast();
    }

    public short first() {
        short last;
        short first = this.getFirst();
        if (first > (last = this.getLast())) {
            throw new NoSuchElementException();
        }
        return first;
    }

    public short last() {
        short last;
        short first = this.getFirst();
        if (first > (last = this.getLast())) {
            throw new NoSuchElementException();
        }
        return last;
    }

    public int intervalCount() {
        return this.isEmpty() ? 0 : 1;
    }

    public ShortInterval firstInterval() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public ShortInterval lastInterval() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public ShortInterval lowerInterval(short n) {
        return n > this.getLast() ? this : null;
    }

    public ShortInterval floorInterval(short n) {
        return n >= this.getFirst() ? this : null;
    }

    public ShortInterval higherInterval(short n) {
        return n < this.getFirst() ? this : null;
    }

    public ShortInterval ceilingInterval(short n) {
        return n <= this.getLast() ? this : null;
    }

    public int size() {
        short last;
        short first = this.getFirst();
        if (first > (last = this.getLast())) {
            return 0;
        }
        return last - first + 1;
    }

    public boolean isEmpty() {
        return this.getFirst() > this.getLast();
    }

    public boolean contains(short e) {
        return e >= this.getFirst() && e <= this.getLast();
    }

    public short higher(short e) {
        short first = this.getFirst();
        short last = this.getLast();
        if (e >= last || first > last) {
            throw new NoSuchElementException();
        }
        if (e < first) {
            return first;
        }
        return (short)(e + 1);
    }

    public short ceiling(short e) {
        short first = this.getFirst();
        short last = this.getLast();
        if (e > last || first > last) {
            throw new NoSuchElementException();
        }
        if (e < first) {
            return first;
        }
        return e;
    }

    public short lower(short e) {
        short first = this.getFirst();
        short last = this.getLast();
        if (e <= first || first > last) {
            throw new NoSuchElementException();
        }
        if (e > last) {
            return last;
        }
        return (short)(e - 1);
    }

    public short floor(short e) {
        short first = this.getFirst();
        short last = this.getLast();
        if (e < first || first > last) {
            throw new NoSuchElementException();
        }
        if (e > last) {
            return last;
        }
        return e;
    }

    public boolean containsInterval(short first, short last) {
        return first >= this.getFirst() && last <= this.getLast();
    }

    public ShortInterval enclosingInterval(short e) {
        if (!this.contains(e)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public ShortIterator iterator() {
        return new SimpleIntervalItemIterator(this.getFirst(), this.getLast());
    }

    public ShortIterator descendingIterator() {
        return new SimpleReverseIntervalItemIterator(this.getFirst(), this.getLast());
    }

    public Iterator intervalIterator() {
        return new IntervalIterator();
    }

    public Iterator descendingIntervalIterator() {
        return new IntervalIterator();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addInterval(short first, short last) {
        throw new UnsupportedOperationException();
    }

    public boolean removeInterval(short first, short last) {
        throw new UnsupportedOperationException();
    }

    public boolean retainInterval(short first, short last) {
        throw new UnsupportedOperationException();
    }

    public short pollFirst() {
        throw new UnsupportedOperationException();
    }

    public short pollLast() {
        throw new UnsupportedOperationException();
    }

    public ShortInterval pollFirstInterval() {
        throw new UnsupportedOperationException();
    }

    public ShortInterval pollLastInterval() {
        throw new UnsupportedOperationException();
    }

    public ShortSortedSet subSet(short first, short last) {
        return new ConstrainedView(this, first, last);
    }

    public ShortSet complementSet() {
        return new ComplementView(this, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public String toString() {
        short last;
        short first = this.getFirst();
        if (first > (last = this.getLast())) {
            return "_";
        }
        if (first == last) {
            return String.valueOf(first);
        }
        return "" + first + ".." + last;
    }

    private static class ComplementIterator
    implements Iterator {
        final ShortInterval[] intervals = new ShortInterval[2];
        final boolean forward;
        int idx;

        ComplementIterator(ComplementView c, boolean forward) {
            this.forward = forward;
            short first = c.base.getFirst();
            short last = c.base.getLast();
            short min = c.min();
            short max = c.max();
            if (min < first) {
                this.intervals[0] = ShortCollections.interval(min, (short)(first - 1));
            }
            if (max > last) {
                this.intervals[1] = ShortCollections.interval((short)(last + 1), max);
            }
            this.idx = forward ? 0 : 1;
        }

        public boolean hasNext() {
            for (int nextIdx = this.idx; nextIdx >= 0 || nextIdx <= 2; nextIdx += this.forward ? 1 : -1) {
                if (this.intervals[nextIdx] == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.idx >= 0 && this.idx <= 1) {
                ShortInterval r = this.intervals[this.idx];
                this.idx += this.forward ? 1 : -1;
                if (r == null) continue;
                return r;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ComplementView
    extends AbstractShortSortedSet {
        final AbstractShortInterval base;
        final short beg;
        final short end;

        ComplementView(AbstractShortInterval base, short beg, short end) {
            if (beg > end) {
                throw new IllegalArgumentException();
            }
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public short min() {
            short min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public short max() {
            short max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public short first() {
            short min = this.min();
            if (min < this.base.getFirst()) {
                return min;
            }
            short max = this.max();
            short last = this.base.getLast();
            if (last < max) {
                return (short)(last + 1);
            }
            throw new NoSuchElementException();
        }

        public short last() {
            short max = this.max();
            if (max > this.base.getLast()) {
                return max;
            }
            short min = this.min();
            short first = this.base.getFirst();
            if (first > min) {
                return (short)(first - 1);
            }
            throw new NoSuchElementException();
        }

        public boolean contains(short e) {
            return e >= this.min() && e <= this.max() && !this.base.contains(e);
        }

        public boolean containsInterval(short first, short last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.min() || last > this.max()) {
                return false;
            }
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            return last < bfirst || blast < first;
        }

        public ShortInterval enclosingInterval(short e) {
            if (!this.contains(e)) {
                return null;
            }
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            if (e < bfirst) {
                return ShortCollections.interval(this.min(), (short)(bfirst - 1));
            }
            if (e > blast) {
                return ShortCollections.interval((short)(blast + 1), this.max());
            }
            return null;
        }

        public ShortInterval higherInterval(short n) {
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            short min = this.min();
            short max = this.max();
            if (bfirst > Short.MIN_VALUE && n < min && min < (short)(bfirst - 1)) {
                return ShortCollections.interval(min, (short)(bfirst - 1));
            }
            if (blast < Short.MAX_VALUE && n <= blast && (short)(blast + 1) < max) {
                return ShortCollections.interval((short)(blast + 1), max);
            }
            return null;
        }

        public ShortInterval ceilingInterval(short n) {
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            short min = this.min();
            short max = this.max();
            if (bfirst > Short.MIN_VALUE && n < bfirst && (short)(bfirst - 1) > min) {
                return ShortCollections.interval(min, (short)(bfirst - 1));
            }
            if (blast < Short.MAX_VALUE && n <= max && this.end > (short)(blast + 1)) {
                return ShortCollections.interval((short)(blast + 1), max);
            }
            return null;
        }

        public ShortInterval lowerInterval(short n) {
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            short min = this.min();
            short max = this.max();
            if (blast < Short.MAX_VALUE && n > max && max > (short)(blast + 1)) {
                return ShortCollections.interval((short)(blast + 1), max);
            }
            if (bfirst > Short.MIN_VALUE && n >= bfirst && (short)(bfirst - 1) > min) {
                return ShortCollections.interval(min, (short)(bfirst - 1));
            }
            return null;
        }

        public ShortInterval floorInterval(short n) {
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            short min = this.min();
            short max = this.max();
            if (blast < Short.MAX_VALUE && n > blast && (short)(blast + 1) < max) {
                return ShortCollections.interval((short)(blast + 1), max);
            }
            if (bfirst > Short.MIN_VALUE && n >= min && min < (short)(bfirst - 1)) {
                return ShortCollections.interval(min, (short)(bfirst - 1));
            }
            return null;
        }

        public ShortInterval firstInterval() {
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            short min = this.min();
            short max = this.max();
            if (bfirst > Short.MIN_VALUE && min < (short)(bfirst - 1)) {
                return ShortCollections.interval(min, (short)(bfirst - 1));
            }
            if (blast < Short.MAX_VALUE && (short)(blast + 1) < max) {
                return ShortCollections.interval((short)(blast + 1), max);
            }
            return null;
        }

        public ShortInterval lastInterval() {
            short bfirst = this.base.getFirst();
            short blast = this.base.getLast();
            short min = this.min();
            short max = this.max();
            if (blast < Short.MAX_VALUE && (short)(blast + 1) < max) {
                return ShortCollections.interval((short)(blast + 1), max);
            }
            if (bfirst > Short.MIN_VALUE && min < (short)(bfirst - 1)) {
                return ShortCollections.interval(min, (short)(bfirst - 1));
            }
            return null;
        }

        public ShortInterval pollFirstInterval() {
            throw new UnsupportedOperationException();
        }

        public ShortInterval pollLastInterval() {
            throw new UnsupportedOperationException();
        }

        public int intervalCount() {
            int count = 0;
            if (this.min() < this.base.getFirst()) {
                ++count;
            }
            if (this.max() > this.base.getLast()) {
                ++count;
            }
            return count;
        }

        public ShortSortedSet subSet(short first, short last) {
            if (first <= this.beg && last >= this.end) {
                return this;
            }
            short beg = first > this.beg ? first : this.beg;
            short end = last < this.end ? last : this.end;
            return new ComplementView(this.base, beg, end);
        }

        public ShortSet complementSet() {
            if (this.beg == Short.MIN_VALUE && this.end == Short.MAX_VALUE) {
                return this.base;
            }
            return new ConstrainedView(this.base, this.beg, this.end);
        }

        public Iterator intervalIterator() {
            return new ComplementIterator(this, true);
        }

        public Iterator descendingIntervalIterator() {
            return new ComplementIterator(this, false);
        }
    }

    protected static class ConstrainedView
    extends AbstractShortInterval {
        final AbstractShortInterval base;
        final short beg;
        final short end;

        ConstrainedView(AbstractShortInterval base, short beg, short end) {
            if (beg > end) {
                throw new IllegalArgumentException();
            }
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        protected short getFirst() {
            short first = this.base.getFirst();
            return first > this.beg ? first : this.beg;
        }

        protected short getLast() {
            short last = this.base.getLast();
            return last < this.end ? last : this.end;
        }

        public short min() {
            short min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public short max() {
            short max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public ShortSortedSet subSet(short first, short last) {
            if (first <= this.beg && last >= this.end) {
                return this;
            }
            short beg = first > this.beg ? first : this.beg;
            short end = last < this.end ? last : this.end;
            return new ConstrainedView(this.base, beg, end);
        }

        public ShortSet complementSet() {
            return new ComplementView(this.base, this.beg, this.end);
        }
    }

    public static class SimpleReverseIntervalItemIterator
    implements ShortIterator {
        final short first;
        final short last;
        short curr;
        boolean eof;

        SimpleReverseIntervalItemIterator(short first, short last) {
            this.first = first;
            this.last = last;
            this.curr = last;
            if (first > last) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            this.eof = false;
            return false;
        }

        public short next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            if (this.curr == this.first) {
                this.eof = true;
                return this.curr;
            }
            short s = this.curr;
            this.curr = (short)(s - 1);
            return s;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SimpleIntervalItemIterator
    implements ShortIterator {
        final short first;
        final short last;
        short curr;
        boolean eof;

        SimpleIntervalItemIterator(short first, short last) {
            this.first = first;
            this.last = last;
            this.curr = first;
            if (first > last) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            this.eof = false;
            return false;
        }

        public short next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            if (this.curr == this.last) {
                this.eof = true;
                return this.curr;
            }
            short s = this.curr;
            this.curr = (short)(s + 1);
            return s;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class IntervalIterator
    implements Iterator {
        boolean eof;

        IntervalIterator() {
            if (AbstractShortInterval.this.getFirst() > AbstractShortInterval.this.getLast()) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            return !this.eof;
        }

        public Object next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            this.eof = true;
            return AbstractShortInterval.this;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

