/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ByteOrder;
import de.vdheide.mp3.ID3v2;
import java.io.IOException;
import java.io.InputStream;

public class ID3v2ExtendedHeader {
    private int padding_size = 0;
    private boolean crc_present = false;
    private int crc = 0;
    private static final byte FLAG_CRC_PRESENT = -128;

    public ID3v2ExtendedHeader() {
        this(false, 0, 0);
    }

    public ID3v2ExtendedHeader(boolean use_crc, int crc, int padding_size) {
        this.crc_present = use_crc;
        this.crc = this.crc_present ? crc : 0;
        this.padding_size = padding_size;
    }

    public ID3v2ExtendedHeader(InputStream in) throws IOException {
        byte[] head = new byte[10];
        ID3v2.fillBuffer(head, in);
        byte[] sizeBytes = new byte[4];
        System.arraycopy(head, 0, sizeBytes, 0, 4);
        long s = ByteOrder.ubytes2long(ByteOrder.beb2int(sizeBytes, 0));
        int size = (int)s;
        if ((head[4] & 0xFF & 0xFFFFFF80) > 0) {
            this.crc_present = true;
        }
        byte[] padSizeBytes = new byte[4];
        System.arraycopy(head, 6, padSizeBytes, 0, 4);
        long ps = ByteOrder.ubytes2long(ByteOrder.beb2int(padSizeBytes, 0));
        this.padding_size = (int)ps;
        if (this.crc_present) {
            byte[] crc_array = new byte[4];
            byte FF = -1;
            byte OO = 0;
            int crcByteCount = 0;
            boolean prevFF = false;
            while (crcByteCount < 4) {
                byte b = (byte)in.read();
                if (prevFF && b == OO) {
                    prevFF = false;
                    continue;
                }
                prevFF = b == FF;
                crc_array[crcByteCount++] = b;
            }
            this.crc = ByteOrder.beb2int(crc_array, 0);
        }
    }

    public int getSize() {
        return this.crc_present ? 10 : 6;
    }

    public int getPaddingSize() {
        return this.padding_size;
    }

    public void setPaddingSize(int size) {
        this.padding_size = size;
    }

    public boolean hasCRC() {
        return this.crc_present;
    }

    public void setHasCRC(boolean act) {
        act = false;
        if (false) {
            this.crc = 0;
        }
        this.crc_present = act;
    }

    public long getCRC() {
        return this.crc;
    }

    public void setCRC(int crc) {
        this.crc = crc;
        this.crc_present = true;
    }

    public byte[] getBytes() {
        byte[] ret;
        if (this.crc_present) {
            ret = new byte[14];
            ret[0] = 0;
            ret[1] = 0;
            ret[2] = 0;
            ret[3] = 10;
            ret[4] = -128;
            ret[5] = 0;
        } else {
            ret = new byte[10];
            ret[0] = 0;
            ret[1] = 0;
            ret[2] = 0;
            ret[3] = 10;
            ret[4] = 0;
            ret[5] = 0;
        }
        byte[] pad_byte = new byte[4];
        ByteOrder.int2beb(this.padding_size, pad_byte, 0);
        System.arraycopy(pad_byte, 0, ret, 6, 4);
        if (this.crc_present) {
            byte[] crc_byte = new byte[4];
            ByteOrder.int2beb(this.crc, crc_byte, 0);
            System.arraycopy(crc_byte, 0, ret, 10, 4);
        }
        return ret;
    }
}

