/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net.compressed;

import edu.emory.mathcs.util.io.CompressedInputStream;
import edu.emory.mathcs.util.io.CompressedOutputStream;
import edu.emory.mathcs.util.net.DecoratingSocket;
import edu.emory.mathcs.util.net.SocketWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class CompressedSocketWrapper
extends SocketWrapper
implements DecoratingSocket {
    protected final int bufSize;

    public CompressedSocketWrapper(Socket delegate) throws SocketException {
        this(delegate, -1);
    }

    public CompressedSocketWrapper(Socket delegate, int bufSize) throws SocketException {
        super(delegate);
        this.bufSize = bufSize;
    }

    public Socket getBaseSocket() {
        return this.delegate;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = super.getInputStream();
        if (this.bufSize > 0) {
            return new CompressedInputStream(is, this.bufSize);
        }
        return new CompressedInputStream(is);
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream out = super.getOutputStream();
        if (this.bufSize > 0) {
            return new CompressedOutputStream(out, this.bufSize);
        }
        return new CompressedOutputStream(out);
    }
}

