/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net.inproc;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.DynamicArrayBlockingQueue;
import edu.emory.mathcs.util.io.BufferedPipe;
import edu.emory.mathcs.util.io.TimedInput;
import edu.emory.mathcs.util.net.inproc.InProcSocket;
import edu.emory.mathcs.util.net.inproc.InProcSocketAddress;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public abstract class InProcServerSocket
extends ServerSocket {
    static final Map bindings = new HashMap();
    static final Random random = new Random();
    boolean bound;
    volatile boolean closed;
    int localPort;
    int soTimeout = 0;
    BlockingQueue connectionQueue;
    private static final ConnReq TERMINATOR = new ConnReq();

    public InProcServerSocket() throws IOException {
    }

    public InProcServerSocket(int port) throws IOException {
        this(port, 50);
    }

    public InProcServerSocket(int port, int backlog) throws IOException {
        this.bind(new InProcSocketAddress(port), backlog);
    }

    public InProcServerSocket(InProcSocketAddress addr) throws IOException {
        this(addr, 50);
    }

    public InProcServerSocket(InProcSocketAddress addr, int backlog) throws IOException {
        this.bind(addr, backlog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.ensureNotClosed();
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (endpoint == null) {
            endpoint = new InProcSocketAddress(0);
        }
        if (backlog <= 0) {
            throw new IllegalArgumentException("Backlog must be positive");
        }
        if (!(endpoint instanceof InProcSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        int port = ((InProcSocketAddress)endpoint).port;
        try {
            Map map = bindings;
            synchronized (map) {
                if (port != 0) {
                    if (bindings.containsKey(new Integer(port))) {
                        throw new BindException("InProc port " + port + " already in use");
                    }
                } else {
                    boolean ok = false;
                    for (int i = 0; i < 100; ++i) {
                        port = random.nextInt() & Integer.MAX_VALUE;
                        if (i < 4) {
                            port &= 0x3FFF;
                        } else if (i < 8) {
                            port &= 0xFFFF;
                        }
                        if (port <= 1024 || bindings.containsKey(new Integer(port))) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        throw new BindException("InProc: Could not find available port to listen on");
                    }
                }
                bindings.put(new Integer(port), this);
            }
            this.localPort = port;
            this.bound = true;
            this.connectionQueue = new DynamicArrayBlockingQueue(4, backlog);
        }
        catch (SecurityException e) {
            this.bound = false;
            throw e;
        }
        catch (IOException e) {
            this.bound = false;
            throw e;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isBound() {
        return this.bound;
    }

    public InetAddress getInetAddress() {
        return InProcSocket.inprocInetAddr;
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.localPort;
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InProcSocketAddress(this.getLocalPort());
    }

    public Socket accept() throws IOException {
        ConnReq req;
        InProcSocket.Channel ch;
        this.ensureNotClosed();
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        int soTimeout = this.soTimeout;
        do {
            try {
                req = soTimeout > 0 ? (ConnReq)this.connectionQueue.poll((long)soTimeout, TimeUnit.MILLISECONDS) : (ConnReq)this.connectionQueue.take();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.toString());
            }
            if (req == null) {
                throw new SocketTimeoutException("Timeout on InProcServerSocket.accept");
            }
            if (req != TERMINATOR) continue;
            throw new SocketException("Socket closed");
        } while ((ch = req.accept()) == null);
        return new InProcSocket(ch, this.localPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        ConnReq connReq;
        this.closed = true;
        while ((connReq = (ConnReq)this.connectionQueue.poll()) != null) {
            connReq.refuse();
        }
        try {
            this.connectionQueue.put((Object)TERMINATOR);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("FATAL: Blocked when putting into empty queue");
        }
        if (this.isBound()) {
            Map map = bindings;
            synchronized (map) {
                bindings.remove(new Integer(this.localPort));
            }
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be non-negative");
        }
        this.ensureNotClosed();
        this.soTimeout = timeout;
    }

    public int getSoTimeout() throws IOException {
        this.ensureNotClosed();
        return this.soTimeout;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.ensureNotClosed();
    }

    public boolean getReuseAddress() throws SocketException {
        this.ensureNotClosed();
        return true;
    }

    public String toString() {
        if (!this.isBound()) {
            return "InProcServerSocket[unbound]";
        }
        return "InProcServerSocket[port=" + this.localPort + "]";
    }

    private void ensureNotClosed() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InProcSocket.Channel connect(int port, int timeout) throws IOException {
        boolean success;
        InProcServerSocket srvsock;
        Map map = bindings;
        synchronized (map) {
            srvsock = (InProcServerSocket)bindings.get(new Integer(port));
        }
        if (srvsock == null) {
            throw new IOException("Connection refused (server not listening)");
        }
        ConnReq connreq = new ConnReq();
        InProcServerSocket inProcServerSocket = srvsock;
        synchronized (inProcServerSocket) {
            if (srvsock.isClosed()) {
                throw new IOException("Connection refused (server closed)");
            }
            success = srvsock.connectionQueue.offer((Object)connreq);
        }
        if (!success) {
            throw new IOException("Connection refused (queue full, try again later)");
        }
        return connreq.awaitOrCancel(timeout);
    }

    private static class ConnReq {
        boolean accepted = false;
        boolean cancelled = false;
        boolean refused = false;
        InProcSocket.Channel srvChannel;
        InProcSocket.Channel cliChannel;

        ConnReq() {
        }

        public synchronized boolean cancel() {
            if (this.accepted || this.refused) {
                return false;
            }
            this.cancelled = true;
            this.notifyAll();
            return true;
        }

        public synchronized InProcSocket.Channel accept() {
            if (this.cancelled) {
                return null;
            }
            if (this.accepted || this.refused) {
                throw new IllegalStateException("Already responded");
            }
            this.accepted = true;
            BufferedPipe upstream = new BufferedPipe();
            BufferedPipe downstream = new BufferedPipe();
            this.srvChannel = new InProcSocket.Channel((TimedInput)((Object)upstream.sink()), downstream.source());
            this.cliChannel = new InProcSocket.Channel((TimedInput)((Object)downstream.sink()), upstream.source());
            this.notifyAll();
            return this.srvChannel;
        }

        public synchronized void refuse() {
            if (this.cancelled) {
                return;
            }
            if (this.accepted || this.refused) {
                throw new IllegalStateException("Already responded");
            }
            this.refused = true;
            this.notifyAll();
        }

        public synchronized InProcSocket.Channel awaitOrCancel(int timeout) throws IOException {
            try {
                if (timeout == 0) {
                    while (!(this.accepted || this.cancelled || this.refused)) {
                        this.wait();
                    }
                } else {
                    long endtime = (long)timeout + System.currentTimeMillis();
                    while (!(this.accepted || this.cancelled || this.refused)) {
                        long todo = endtime - System.currentTimeMillis();
                        if (todo > 0L) {
                            this.wait(todo);
                            continue;
                        }
                        this.cancel();
                        break;
                    }
                }
                if (this.cancelled) {
                    throw new SocketTimeoutException("Connection timed out");
                }
                if (this.refused) {
                    throw new IOException("Connection refused (server closing)");
                }
                return this.cliChannel;
            }
            catch (InterruptedException e) {
                if (this.accepted) {
                    return this.cliChannel;
                }
                this.cancel();
                throw new InterruptedIOException("Connect interrupted");
            }
        }
    }
}

