/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote.io.server.impl;

import edu.emory.mathcs.util.remote.io.server.RemoteInputStreamSrv;
import java.io.IOException;
import java.io.InputStream;

public class RemoteInputStreamSrvImpl
implements RemoteInputStreamSrv {
    final InputStream in;
    final int maxblock;

    public RemoteInputStreamSrvImpl(InputStream in) {
        this(in, 262144);
    }

    public RemoteInputStreamSrvImpl(InputStream in, int maxblock) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (maxblock <= 0) {
            throw new IllegalArgumentException("maxblock <= 0");
        }
        this.in = in;
        this.maxblock = maxblock;
    }

    public byte[] read(int maxbytes) throws IOException {
        int toRead;
        int avail = this.in.available();
        if (avail == 0) {
            toRead = maxbytes > 0 ? maxbytes : 1024;
        } else {
            int n = toRead = maxbytes > 0 ? Math.min(avail, maxbytes) : avail;
            if (toRead > this.maxblock) {
                toRead = this.maxblock;
            }
        }
        byte[] buf = new byte[toRead];
        int read = this.in.read(buf);
        if (read == toRead) {
            return buf;
        }
        if (read < 0) {
            return null;
        }
        byte[] newbuf = new byte[read];
        System.arraycopy(buf, 0, newbuf, 0, read);
        return newbuf;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

