/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import edu.emory.mathcs.util.collections.WeakValueHashMap;
import edu.emory.mathcs.util.remote.locks.RemoteCondition;
import edu.emory.mathcs.util.remote.locks.RemoteLock;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;

public class ReentrantDistributedLock
implements RemoteLock {
    private final RemoteLock remoteLock;
    private final ReentrantLock localLock;
    private static WeakValueHashMap lockResolver = new WeakValueHashMap();
    private static Set lockedLocks = new HashSet();

    public ReentrantDistributedLock(RemoteLock remoteLock) {
        this.remoteLock = remoteLock;
        this.localLock = ReentrantDistributedLock.getLocalLockFor(remoteLock);
    }

    public void lock() throws RemoteException {
        this.localLock.lock();
        if (this.localLock.getHoldCount() > 1) {
            return;
        }
        ReentrantDistributedLock.pin(this.localLock);
        try {
            this.remoteLock.lock();
        }
        catch (Throwable e) {
            ReentrantDistributedLock.unpin(this.localLock);
            this.localLock.unlock();
            ReentrantDistributedLock.rethrow(e);
        }
    }

    public boolean tryLock() throws RemoteException {
        if (!this.localLock.tryLock()) {
            return false;
        }
        if (this.localLock.getHoldCount() > 1) {
            return true;
        }
        ReentrantDistributedLock.pin(this.localLock);
        try {
            boolean success = this.remoteLock.tryLock();
            if (success) {
                return true;
            }
        }
        catch (Throwable e) {
            ReentrantDistributedLock.unpin(this.localLock);
            this.localLock.unlock();
            ReentrantDistributedLock.rethrow(e);
        }
        ReentrantDistributedLock.unpin(this.localLock);
        this.localLock.unlock();
        return false;
    }

    public void lockInterruptibly() throws InterruptedException, RemoteException {
        this.localLock.lockInterruptibly();
        if (this.localLock.getHoldCount() > 1) {
            return;
        }
        ReentrantDistributedLock.pin(this.localLock);
        try {
            this.remoteLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            ReentrantDistributedLock.unpin(this.localLock);
            this.localLock.unlock();
            throw e;
        }
        catch (Throwable e) {
            ReentrantDistributedLock.unpin(this.localLock);
            this.localLock.unlock();
            ReentrantDistributedLock.rethrow(e);
        }
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException, RemoteException {
        long nanos = unit.toNanos(timeout);
        if (!this.localLock.tryLock()) {
            long deadline = Utils.nanoTime() + nanos;
            if (!this.localLock.tryLock(timeout, unit)) {
                return false;
            }
            nanos = deadline - Utils.nanoTime();
        }
        if (this.localLock.getHoldCount() > 1) {
            return true;
        }
        ReentrantDistributedLock.pin(this.localLock);
        try {
            boolean success = this.remoteLock.tryLock(nanos, TimeUnit.NANOSECONDS);
            if (success) {
                return true;
            }
        }
        catch (Throwable e) {
            ReentrantDistributedLock.unpin(this.localLock);
            this.localLock.unlock();
            ReentrantDistributedLock.rethrow(e);
        }
        ReentrantDistributedLock.unpin(this.localLock);
        this.localLock.unlock();
        return false;
    }

    public void unlock() throws RemoteException {
        if (!this.localLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Not owner");
        }
        if (this.localLock.getHoldCount() > 1) {
            this.localLock.unlock();
            return;
        }
        try {
            this.remoteLock.unlock();
        }
        catch (IllegalMonitorStateException e) {
            ReentrantDistributedLock.unpin(this.localLock);
            this.localLock.unlock();
            throw new RemoteException("Remote inconsistency - the lock has been already taken away", e);
        }
        catch (Throwable e) {
            ReentrantDistributedLock.rethrow(e);
        }
        ReentrantDistributedLock.unpin(this.localLock);
        this.localLock.unlock();
    }

    public RemoteCondition newCondition() throws RemoteException {
        return this.remoteLock.newCondition();
    }

    static synchronized ReentrantLock getLocalLockFor(RemoteLock remote) {
        ReentrantLock local = (ReentrantLock)lockResolver.get((Object)remote);
        if (local == null) {
            local = new ReentrantLock();
            lockResolver.put((Object)remote, (Object)local);
        }
        return local;
    }

    static synchronized void pin(ReentrantLock lock) {
        lockedLocks.add(lock);
    }

    static synchronized void unpin(ReentrantLock lock) {
        lockedLocks.remove(lock);
    }

    private static void rethrow(Throwable e) throws RemoteException {
        if (e instanceof RemoteException) {
            throw (RemoteException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    public int hashCode() {
        return this.remoteLock.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReentrantDistributedLock)) {
            return false;
        }
        ReentrantDistributedLock that = (ReentrantDistributedLock)other;
        return this.remoteLock.equals(that.remoteLock);
    }
}

