/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AccumulatingErrorHandler
implements ErrorHandler {
    final ErrorHandler delegate;
    static final int FATAL_ERROR = 1;
    static final int ERROR = 2;
    static final int WARNING = 4;
    List problems;
    List problemTypes;
    int warningCount;
    int errorCount;
    int fatalCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AccumulatingErrorHandler() {
        this(null);
    }

    public AccumulatingErrorHandler(ErrorHandler delegate) {
        this.delegate = delegate;
    }

    public void warning(SAXParseException ex) throws SAXException {
        if (this.delegate != null) {
            this.delegate.warning(ex);
        }
        this.addProblem(4, ex);
    }

    public void error(SAXParseException ex) throws SAXException {
        if (this.delegate != null) {
            this.delegate.error(ex);
        }
        this.addProblem(2, ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        if (this.delegate != null) {
            this.delegate.fatalError(ex);
        }
        this.addProblem(1, ex);
    }

    private synchronized void addProblem(int type, SAXParseException ex) {
        if (this.problems == null) {
            this.problems = new ArrayList();
            this.problemTypes = new ArrayList();
        }
        switch (type) {
            case 1: {
                ++this.fatalCount;
                break;
            }
            case 2: {
                ++this.errorCount;
                break;
            }
            case 4: {
                ++this.warningCount;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        this.problems.add(ex);
        this.problemTypes.add(new Integer(type));
    }

    public boolean hadWarnings() {
        return this.warningCount > 0;
    }

    public boolean hadAnyErrors() {
        return this.errorCount + this.fatalCount > 0;
    }

    public boolean hadNonfatalErrors() {
        return this.errorCount > 0;
    }

    public boolean hadFatalErrors() {
        return this.fatalCount > 0;
    }

    public boolean hadAnyProblems() {
        return this.warningCount + this.errorCount + this.fatalCount > 0;
    }

    public synchronized SAXParseException[] getWarnings() {
        return this.getProblems(4);
    }

    public SAXParseException[] getAllErrors() {
        return this.getProblems(3);
    }

    public SAXParseException[] getNonfatalErrors() {
        return this.getProblems(2);
    }

    public SAXParseException[] getFatalErrors() {
        return this.getProblems(1);
    }

    public SAXParseException[] getAllProblems() {
        return this.getProblems(7);
    }

    private synchronized SAXParseException[] getProblems(int mask) {
        if (this.problems == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        int len = this.problems.size();
        for (int i = 0; i < len; ++i) {
            if (((Integer)this.problemTypes.get(i) & mask) == 0) continue;
            list.add(this.problems.get(i));
        }
        return list.toArray(new SAXParseException[list.size()]);
    }

    public String getDetails() {
        StringBuffer buf = new StringBuffer();
        AccumulatingErrorHandler.addDetails(buf, "fatal error", this.getFatalErrors());
        AccumulatingErrorHandler.addDetails(buf, "error", this.getNonfatalErrors());
        AccumulatingErrorHandler.addDetails(buf, "warning", this.getWarnings());
        return buf.toString();
    }

    private static void addDetails(StringBuffer buf, String type, SAXParseException[] problems) {
        if (problems == null) {
            return;
        }
        for (int i = 0; i < problems.length; ++i) {
            SAXParseException e = problems[i];
            buf.append("Line ").append(e.getLineNumber()).append(": ").append(type).append(": ").append(e.toString()).append("\n");
        }
    }

    static {
        $assertionsDisabled = !AccumulatingErrorHandler.class.desiredAssertionStatus();
    }
}

