/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.xml;

import java.io.PrintStream;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ConsoleErrorHandler
implements ErrorHandler {
    final String source;
    final PrintStream err;

    public ConsoleErrorHandler(String source) {
        this(source, System.err);
    }

    public ConsoleErrorHandler(String source, PrintStream err) {
        this.source = source;
        this.err = err;
    }

    public void warning(SAXParseException ex) {
        this.err.print("XML Parser warning: " + ConsoleErrorHandler.createMsgString(this.source, ex));
    }

    public void error(SAXParseException ex) {
        this.err.print("XML Parser error: " + ConsoleErrorHandler.createMsgString(this.source, ex));
    }

    public void fatalError(SAXParseException ex) {
        this.err.print("XML Parser fatal error: " + ConsoleErrorHandler.createMsgString(this.source, ex));
    }

    private static String createMsgString(String source, SAXParseException ex) {
        StringBuffer buf = new StringBuffer();
        int line = ex.getLineNumber();
        int column = ex.getColumnNumber();
        buf.append(ex.toString()).append('\n');
        buf.append("In ").append(source).append(':').append(line);
        if (column > 0) {
            buf.append(',').append(column);
        }
        buf.append('\n');
        return buf.toString();
    }
}

