/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.xml;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver {
    final Map pubid2url = new HashMap();

    public DTDResolver() {
    }

    public DTDResolver(String pubID, URL dtdUrl) {
        this.addMapping(pubID, dtdUrl);
    }

    public void addMapping(String pubID, URL dtdUrl) {
        if (dtdUrl == null) {
            throw new NullPointerException();
        }
        this.pubid2url.put(pubID, dtdUrl);
    }

    public InputSource resolveEntity(String pubID, String sysID) throws SAXException {
        URL dtdUrl = (URL)this.pubid2url.get(pubID);
        if (dtdUrl == null) {
            throw new SAXException("The document public ID is: \"" + pubID + "\" while it should be (one of): { " + this.enumerateMappedIDs() + " }");
        }
        try {
            return new InputSource(dtdUrl.openConnection().getInputStream());
        }
        catch (IOException e) {
            throw new SAXException("Unable to read DTD definition from " + dtdUrl, e);
        }
    }

    private String enumerateMappedIDs() {
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        Iterator i = this.pubid2url.keySet().iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append('\"').append(i.next()).append('\"');
        }
        return buf.toString();
    }
}

