/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.allocator;

public interface Allocator {
    public Buffer allocate(int var1, boolean var2, long var3) throws InterruptedException;

    public static abstract class Buffer {
        protected final byte[] data;
        protected final int size;
        private int refcount;

        protected Buffer(byte[] data, int size) {
            this.data = data;
            this.size = size;
            this.refcount = 1;
        }

        public byte[] getData() {
            return this.refcount > 0 ? this.data : null;
        }

        public int getSize() {
            return this.refcount > 0 ? this.size : 0;
        }

        public synchronized void addRef() {
            if (this.refcount <= 0) {
                throw new IllegalStateException("refcount = " + this.refcount);
            }
            ++this.refcount;
        }

        public synchronized void releaseRef() {
            --this.refcount;
            if (this.refcount == 0) {
                this.reclaim();
                return;
            }
            if (this.refcount < 0) {
                throw new IllegalStateException("refcount = " + this.refcount);
            }
        }

        protected abstract void reclaim();
    }
}

