/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.allocator;

import edu.emory.mathcs.backport.java.util.Queue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;

class BufferPool {
    private final Queue[] pool = new Queue[27];

    public BufferPool() {
        for (int i = 0; i < this.pool.length; ++i) {
            this.pool[i] = new LinkedBlockingQueue();
        }
    }

    public byte[] get(int desiredsize, boolean clear) {
        int idx = BufferPool.getSlot(desiredsize);
        byte[] data = this.getFromQueue(this.pool[idx]);
        if (data != null) {
            if (clear) {
                Arrays.fill(data, 0, desiredsize, (byte)0);
            }
            return data;
        }
        if (idx < 26 && (data = this.getFromQueue(this.pool[idx + 1])) != null) {
            if (clear) {
                Arrays.fill(data, 0, desiredsize, (byte)0);
            }
            return data;
        }
        return new byte[16 << idx];
    }

    private byte[] getFromQueue(Queue q) {
        Reference ref;
        byte[] data;
        do {
            if ((ref = (Reference)q.poll()) != null) continue;
            return null;
        } while ((data = (byte[])ref.get()) == null);
        return data;
    }

    public void reclaim(byte[] data) {
        int idx = BufferPool.getSlot(data.length);
        this.pool[idx].offer(new WeakReference<byte[]>(data));
    }

    private static int getSlot(int num) {
        if (num < 0) {
            throw new IllegalArgumentException();
        }
        if (num <= 16) {
            return 0;
        }
        return BufferPool.log(num - 1) + 1 - 4;
    }

    public static int log(int n) {
        int result = 0;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0) {
            ++result;
            n >>= 1;
        }
        return result;
    }

    public static int nextPowerOfTwo(int n) {
        return 1 << BufferPool.log(n - 1) + 1;
    }
}

