/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.allocator;

import edu.emory.mathcs.util.allocator.Allocator;
import edu.emory.mathcs.util.allocator.BufferPool;

public class PoolingAllocator
implements Allocator {
    final BufferPool bufpool;
    private final Runtime runtime;
    private final long reserved;
    private final long max;
    private final long minLeft;
    private long memOccupied = 0L;
    private long lastFreeMem = 0L;
    private long occupiedOnLastFreeMem = 0L;

    public PoolingAllocator() {
        this(0x100000L, -1L);
    }

    public PoolingAllocator(long reserved, long max) {
        this(reserved, max, 0x200000);
    }

    public PoolingAllocator(long reserved, long max, int minLeft) {
        this(reserved, max, minLeft, new BufferPool());
    }

    public PoolingAllocator(long reserved, long max, int minLeft, BufferPool bufpool) {
        this.bufpool = bufpool;
        this.reserved = reserved;
        this.max = max;
        this.minLeft = minLeft;
        this.runtime = Runtime.getRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocator.Buffer allocate(int size, boolean clear, long timeout) throws InterruptedException {
        long endTime = -1L;
        PoolingAllocator poolingAllocator = this;
        synchronized (poolingAllocator) {
            while (!this.canAlloc(size)) {
                long remaining;
                if (timeout < 0L) {
                    this.wait();
                    continue;
                }
                if (timeout == 0L) {
                    return null;
                }
                if (endTime < 0L) {
                    endTime = System.currentTimeMillis() + timeout;
                    remaining = timeout;
                } else {
                    remaining = endTime - System.currentTimeMillis();
                }
                if (remaining <= 0L) {
                    return null;
                }
                this.wait(remaining);
            }
            this.memOccupied += (long)size;
        }
        byte[] data = this.bufpool.get(size, clear);
        Buffer buf = new Buffer(data, size);
        if (data.length > size) {
            PoolingAllocator poolingAllocator2 = this;
            synchronized (poolingAllocator2) {
                this.memOccupied += (long)(data.length - size);
            }
        }
        return buf;
    }

    private boolean canAlloc(int size) {
        if (this.max >= 0L && this.memOccupied + (long)size > this.max) {
            return false;
        }
        if (this.memOccupied + (long)size <= this.reserved) {
            return true;
        }
        if (this.minLeft < 0L) {
            return true;
        }
        long morenew = this.memOccupied - this.occupiedOnLastFreeMem;
        if (morenew > 0x100000L || morenew > this.lastFreeMem / 16L) {
            this.lastFreeMem = this.runtime.freeMemory();
            this.occupiedOnLastFreeMem = this.memOccupied;
        }
        if (this.lastFreeMem >= (long)size + this.minLeft) {
            return true;
        }
        this.lastFreeMem = this.runtime.freeMemory();
        this.occupiedOnLastFreeMem = this.memOccupied;
        return this.lastFreeMem >= (long)size + this.minLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaim(byte[] data) {
        PoolingAllocator poolingAllocator = this;
        synchronized (poolingAllocator) {
            this.memOccupied -= (long)data.length;
            this.notifyAll();
        }
        this.bufpool.reclaim(data);
    }

    private class Buffer
    extends Allocator.Buffer {
        Buffer(byte[] data, int size) {
            super(data, size);
        }

        protected void reclaim() {
            PoolingAllocator.this.reclaim(this.data);
        }
    }
}

