/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import edu.emory.mathcs.util.io.XDR;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class BufferedDataInputStream
extends InputStream
implements DataInput {
    private final InputStream in;
    private final int BUFFER_SIZE;
    private int pos;
    private int end;
    private final byte[] buffer;
    protected final byte[] arr = new byte[8];
    private static final int CHAR_BUFFER_SIZE = 1024;
    private final char[] cbuffer = new char[1024];

    public BufferedDataInputStream(InputStream in) throws IOException {
        this(in, 1024);
    }

    public BufferedDataInputStream(InputStream in, int buffer_size) throws IOException {
        this.in = in;
        this.BUFFER_SIZE = buffer_size;
        this.buffer = new byte[this.BUFFER_SIZE];
    }

    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    public int read(byte[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return 0;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int read = this.end - this.pos;
        if (this.pos == this.end) {
            read = this.refill();
        }
        if (read < 0) {
            return read;
        }
        int toCopy = Math.min(this.end - this.pos, lng);
        System.arraycopy(this.buffer, this.pos, array, off, toCopy);
        this.pos += toCopy;
        read = (lng -= toCopy) > 0 ? this.in.read(array, off += toCopy, lng) : 0;
        return toCopy + read;
    }

    public int read() throws IOException {
        int read = 0;
        if (this.pos == this.end) {
            read = this.refill();
        }
        if (read < 0) {
            return read;
        }
        return this.buffer[this.pos++];
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() + Math.max(this.end - this.pos, 0);
    }

    public long skip(long skip) throws IOException {
        if (skip <= 0L) {
            return 0L;
        }
        if (skip < (long)(this.end - this.pos)) {
            this.pos += (int)skip;
            return skip;
        }
        long ret = this.in.skip(skip -= (long)Math.max(this.end - this.pos, 0)) + (long)Math.max(this.end - this.pos, 0);
        this.pos = this.end;
        return ret;
    }

    public int skipBytes(int skip) throws IOException {
        return (int)this.skip(skip);
    }

    public void close() throws IOException {
        this.in.close();
    }

    private int refill() throws IOException {
        this.end = this.in.read(this.buffer, 0, this.BUFFER_SIZE);
        switch (this.end) {
            case 0: {
                throw new IOException("Non-zero length but zero bytes read");
            }
            case -1: {
                this.pos = -1;
                break;
            }
            default: {
                this.pos = 0;
            }
        }
        return this.end;
    }

    public boolean readBoolean() throws IOException {
        int b = this.readInt();
        if (b == -1) {
            throw new EOFException();
        }
        return b != 0;
    }

    public byte readByte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b & 0xFF;
    }

    public char readChar() throws IOException {
        if (this.pos > this.end - 2) {
            System.arraycopy(this.buffer, this.pos, this.arr, 0, this.end - this.pos);
            int arroff = this.end - this.pos;
            int read = this.refill();
            if (read == -1) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pos, this.arr, arroff, 2 - arroff);
            this.pos += 2 - arroff;
            return XDR.getChar(this.arr, 0);
        }
        char chr = XDR.getChar(this.buffer, this.pos);
        this.pos += 2;
        return chr;
    }

    public short readShort() throws IOException {
        if (this.pos > this.end - 2) {
            System.arraycopy(this.buffer, this.pos, this.arr, 0, this.end - this.pos);
            int arroff = this.end - this.pos;
            int read = this.refill();
            if (read == -1) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pos, this.arr, arroff, 2 - arroff);
            this.pos += 2 - arroff;
            return XDR.getShort(this.arr, 0);
        }
        short shrt = XDR.getShort(this.buffer, this.pos);
        this.pos += 2;
        return shrt;
    }

    public int readUnsignedShort() throws IOException {
        if (this.pos > this.end - 2) {
            System.arraycopy(this.buffer, this.pos, this.arr, 0, this.end - this.pos);
            int arroff = this.end - this.pos;
            int read = this.refill();
            if (read == -1) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pos, this.arr, arroff, 2 - arroff);
            this.pos += 2 - arroff;
            return XDR.getShort(this.arr, 0) & 0xFFFF;
        }
        short shrt = XDR.getShort(this.buffer, this.pos);
        this.pos += 2;
        return shrt & 0xFFFF;
    }

    public int readInt() throws IOException {
        if (this.pos > this.end - 4) {
            System.arraycopy(this.buffer, this.pos, this.arr, 0, this.end - this.pos);
            int arroff = this.end - this.pos;
            int read = this.refill();
            if (read == -1) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pos, this.arr, arroff, 4 - arroff);
            this.pos += 4 - arroff;
            return XDR.getInt(this.arr, 0);
        }
        int i = XDR.getInt(this.buffer, this.pos);
        this.pos += 4;
        return i;
    }

    public long readLong() throws IOException {
        if (this.pos > this.end - 8) {
            System.arraycopy(this.buffer, this.pos, this.arr, 0, this.end - this.pos);
            int arroff = this.end - this.pos;
            int read = this.refill();
            if (read == -1) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pos, this.arr, arroff, 8 - arroff);
            this.pos += 8 - arroff;
            return XDR.getLong(this.arr, 0);
        }
        long l = XDR.getLong(this.buffer, this.pos);
        this.pos += 8;
        return l;
    }

    public float readFloat() throws IOException {
        if (this.pos > this.end - 4) {
            System.arraycopy(this.buffer, this.pos, this.arr, 0, this.end - this.pos);
            int arroff = this.end - this.pos;
            int read = this.refill();
            if (read == -1) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pos, this.arr, arroff, 4 - arroff);
            this.pos += 4 - arroff;
            return XDR.getFloat(this.arr, 0);
        }
        float flt = XDR.getFloat(this.buffer, this.pos);
        this.pos += 4;
        return flt;
    }

    public double readDouble() throws IOException {
        if (this.pos > this.end - 8) {
            System.arraycopy(this.buffer, this.pos, this.arr, 0, this.end - this.pos);
            int arroff = this.end - this.pos;
            int read = this.refill();
            if (read == -1) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pos, this.arr, arroff, 8 - arroff);
            this.pos += 8 - arroff;
            return XDR.getDouble(this.arr, 0);
        }
        double dbl = XDR.getDouble(this.buffer, this.pos);
        this.pos += 8;
        return dbl;
    }

    public byte[] readBytes(byte[] array, int off, int lng) throws IOException {
        int toCopy;
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        for (int left = lng; left > 0; left -= toCopy) {
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            toCopy = Math.min(this.end - pos, left);
            System.arraycopy(this.buffer, pos, array, off, toCopy);
            pos += toCopy;
            off += toCopy;
        }
        this.pos = pos;
        return array;
    }

    public boolean[] readBooleans(boolean[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        int left = lng;
        while (left > 0) {
            int toCopy;
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            if ((toCopy = Math.min(this.end - pos >> 2, left)) == 0 && left > 0 && this.end > pos) {
                byte[] b = this.rescueRead(4, pos, this.end);
                array[off++] = XDR.getBoolean(b, 0);
                pos = this.pos;
                --left;
                continue;
            }
            while (toCopy > 0) {
                array[off++] = XDR.getBoolean(this.buffer, pos);
                pos += 4;
                --left;
                --toCopy;
            }
        }
        this.pos = pos;
        return array;
    }

    public char[] readChars(char[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        int left = lng;
        while (left > 0) {
            int toCopy;
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            if ((toCopy = Math.min(this.end - pos >> 1, left)) == 0 && left > 0 && this.end > pos) {
                byte[] b = this.rescueRead(2, pos, this.end);
                array[off++] = XDR.getChar(b, 0);
                pos = this.pos;
                --left;
                continue;
            }
            while (toCopy > 0) {
                array[off++] = XDR.getChar(this.buffer, pos);
                pos += 2;
                --left;
                --toCopy;
            }
        }
        this.pos = pos;
        return array;
    }

    public short[] readShorts(short[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        int left = lng;
        while (left > 0) {
            int toCopy;
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            if ((toCopy = Math.min(this.end - pos >> 1, left)) == 0 && left > 0 && this.end > pos) {
                byte[] b = this.rescueRead(2, pos, this.end);
                array[off++] = XDR.getShort(b, 0);
                pos = this.pos;
                --left;
                continue;
            }
            while (toCopy > 0) {
                array[off++] = XDR.getShort(this.buffer, pos);
                pos += 2;
                --left;
                --toCopy;
            }
        }
        this.pos = pos;
        return array;
    }

    public int[] readInts(int[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        int left = lng;
        while (left > 0) {
            int toCopy;
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            if ((toCopy = Math.min(this.end - pos >> 2, left)) == 0 && left > 0 && this.end > pos) {
                byte[] b = this.rescueRead(4, pos, this.end);
                array[off++] = XDR.getInt(b, 0);
                pos = this.pos;
                --left;
                continue;
            }
            while (toCopy > 0) {
                array[off++] = XDR.getInt(this.buffer, pos);
                pos += 4;
                --left;
                --toCopy;
            }
        }
        this.pos = pos;
        return array;
    }

    public float[] readFloats(float[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        int left = lng;
        while (left > 0) {
            int toCopy;
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            if ((toCopy = Math.min(this.end - pos >> 2, left)) == 0 && left > 0 && this.end > pos) {
                byte[] b = this.rescueRead(4, pos, this.end);
                array[off++] = XDR.getFloat(b, 0);
                pos = this.pos;
                --left;
                continue;
            }
            while (toCopy > 0) {
                array[off++] = XDR.getFloat(this.buffer, pos);
                pos += 4;
                --left;
                --toCopy;
            }
        }
        this.pos = pos;
        return array;
    }

    public long[] readLongs(long[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        int left = lng;
        while (left > 0) {
            int toCopy;
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            if ((toCopy = Math.min(this.end - pos >> 3, left)) == 0 && left > 0 && this.end > pos) {
                byte[] b = this.rescueRead(8, pos, this.end);
                array[off++] = XDR.getLong(b, 0);
                pos = this.pos;
                --left;
                continue;
            }
            while (toCopy > 0) {
                array[off++] = XDR.getLong(this.buffer, pos);
                pos += 8;
                --left;
                --toCopy;
            }
        }
        this.pos = pos;
        return array;
    }

    public double[] readDoubles(double[] array, int off, int lng) throws IOException {
        if (lng == 0 || array.length == 0) {
            return array;
        }
        if (off < 0 || lng < 0 || off + lng > array.length) {
            throw new IndexOutOfBoundsException("Array size " + array.length + " trying to write at " + (off + lng));
        }
        int pos = this.pos;
        int left = lng;
        while (left > 0) {
            int toCopy;
            if (pos == this.end) {
                int read = this.refill();
                if (read == -1 && left > 0) {
                    throw new EOFException();
                }
                pos = this.pos;
            }
            if ((toCopy = Math.min(this.end - pos >> 3, left)) == 0 && left > 0 && this.end > pos) {
                byte[] b = this.rescueRead(8, pos, this.end);
                array[off++] = XDR.getDouble(b, 0);
                pos = this.pos;
                --left;
                continue;
            }
            while (toCopy > 0) {
                array[off++] = XDR.getDouble(this.buffer, pos);
                pos += 8;
                --left;
                --toCopy;
            }
        }
        this.pos = pos;
        return array;
    }

    public String readUTF() throws IOException {
        int lng = this.readUnsignedShort();
        return this.readStringUTFBytes(lng);
    }

    protected String readStringUTFBytes(int lng) throws IOException {
        byte[] bytes = new byte[lng];
        this.readBytes(bytes, 0, lng);
        int cbufpos = 0;
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < lng) {
            int b2;
            int b1;
            if (((b1 = bytes[i++] & 0xFF) & 0x80) == 0) {
                this.cbuffer[cbufpos++] = (char)(b1 & 0xFF);
            } else if ((b1 & 0xE0) == 192) {
                if (((b2 = bytes[i++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException("Malformed byte format");
                }
                this.cbuffer[cbufpos++] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
            } else if ((b1 & 0xF0) == 224) {
                b2 = bytes[i++] & 0xFF;
                int b3 = bytes[i++] & 0xFF;
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    throw new UTFDataFormatException("Malformed byte format");
                }
                this.cbuffer[cbufpos++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
            } else {
                throw new UTFDataFormatException("Malformed byte format");
            }
            if (cbufpos != 1024) continue;
            sbuf.append(this.cbuffer);
            cbufpos = 0;
        }
        sbuf.append(this.cbuffer, 0, cbufpos);
        return sbuf.toString();
    }

    public String readLine() throws IOException {
        int read;
        int read2;
        if (this.pos == this.end && (read2 = this.refill()) == -1) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        do {
            int i;
            int lineEnd;
            if ((lineEnd = this.searchEOL(this.buffer, this.pos, this.end)) != -1) {
                for (i = 0; i < lineEnd - this.pos; ++i) {
                    this.cbuffer[i] = (char)(this.buffer[this.pos + i] & 0xFF);
                }
                sbuf.append(this.cbuffer, 0, lineEnd - this.pos);
                if (this.buffer[lineEnd] == 13) {
                    if (lineEnd == this.end - 1) {
                        read = this.refill();
                        if (read != -1 && this.buffer[0] == 10) {
                            this.pos = 1;
                        }
                    } else if (this.buffer[lineEnd + 1] == 10) {
                        if (lineEnd + 2 > this.end) {
                            this.refill();
                        } else {
                            this.pos = lineEnd + 2;
                        }
                    }
                }
                return sbuf.toString();
            }
            for (i = 0; i < this.end - this.pos; ++i) {
                this.cbuffer[i] = (char)(this.buffer[this.pos + i] & 0xFF);
            }
            sbuf.append(this.cbuffer, 0, this.end - this.pos);
        } while ((read = this.refill()) != -1);
        return sbuf.toString();
    }

    private int searchEOL(byte[] bytes, int beg, int end) {
        while (beg < end) {
            if (bytes[beg] == 13 || bytes[beg] == 10) {
                return beg;
            }
            ++beg;
        }
        return -1;
    }

    public void readFully(byte[] bytes) throws IOException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readFully(byte[] bytes, int off, int lng) throws IOException {
        this.readBytes(bytes, off, lng);
    }

    private byte[] rescueRead(int count, int pos, int end) throws IOException {
        int i = 0;
        byte[] b = new byte[count];
        while (true) {
            if (pos < end && i < count) {
                b[i++] = this.buffer[pos++];
                continue;
            }
            if (pos == end) {
                int read = this.refill();
                if (read == -1) {
                    throw new EOFException();
                }
                pos = this.pos;
                end = this.end;
            }
            if (i == count) break;
        }
        this.pos = pos;
        return b;
    }
}

