/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class CompressedOutputStream
extends FilterOutputStream {
    static final short DEFLATED = Short.MIN_VALUE;
    static final short STORED = 0;
    static final int STORE_TRESHOLD = 32;
    final byte[] buf;
    final byte[] destbuf;
    final DataOutputStream dos;
    int pos;
    final Deflater deflater;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CompressedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public CompressedOutputStream(OutputStream out, int bufSize) {
        super(out);
        if (bufSize <= 16 || bufSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid buffer size");
        }
        this.buf = new byte[bufSize];
        this.destbuf = new byte[bufSize];
        this.deflater = new Deflater(-1, true);
        this.pos = 0;
        this.dos = new DataOutputStream(out);
    }

    public synchronized void write(int b) throws IOException {
        this.buf[this.pos++] = (byte)b;
        if (this.pos == this.buf.length) {
            this.writePacket();
        }
    }

    public synchronized void write(byte[] data, int off, int len) throws IOException {
        while (len > 0) {
            int todo = Math.min(this.buf.length - this.pos, len);
            System.arraycopy(data, off, this.buf, this.pos, todo);
            this.pos += todo;
            off += todo;
            len -= todo;
            if (this.pos != this.buf.length) continue;
            this.writePacket();
        }
    }

    public synchronized void flush() throws IOException {
        if (this.pos != 0) {
            this.writePacket();
        }
        this.out.flush();
    }

    private synchronized void writePacket() throws IOException {
        if (this.pos < 32) {
            short header = (short)((short)this.pos | 0);
            this.dos.writeShort(header);
            this.out.write(this.buf, 0, this.pos);
        } else {
            int off;
            int wrote;
            this.deflater.reset();
            this.deflater.setInput(this.buf, 0, this.pos);
            this.deflater.finish();
            for (off = 0; !this.deflater.finished() && off < this.destbuf.length; off += wrote) {
                wrote = this.deflater.deflate(this.destbuf, off, this.destbuf.length - off);
                if (!$assertionsDisabled && wrote <= 0) {
                    throw new AssertionError();
                }
            }
            if (off < this.destbuf.length - 2) {
                short header = (short)((short)off | Short.MIN_VALUE);
                this.dos.writeShort(header);
                this.out.write(this.destbuf, 0, off);
            } else {
                short header = (short)((short)this.pos | 0);
                this.dos.writeShort(header);
                this.out.write(this.buf, 0, this.pos);
            }
        }
        this.pos = 0;
    }

    static {
        $assertionsDisabled = !CompressedOutputStream.class.desiredAssertionStatus();
    }
}

