/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends FilterInputStream {
    final OutputStream tee;
    final boolean autoFlush;
    final boolean autoClose;
    final boolean bestEffort;

    public TeeInputStream(InputStream in, OutputStream tee) {
        this(in, tee, true, false, false);
    }

    public TeeInputStream(InputStream in, OutputStream tee, boolean autoFlush, boolean autoClose) {
        this(in, tee, autoFlush, autoClose, false);
    }

    public TeeInputStream(InputStream in, OutputStream tee, boolean autoFlush, boolean autoClose, boolean bestEffort) {
        super(in);
        this.tee = tee;
        this.autoFlush = autoFlush;
        this.autoClose = autoClose;
        this.bestEffort = bestEffort;
    }

    public int read() throws IOException {
        int b = super.read();
        if (b < 0) {
            if (this.autoClose) {
                this.closeTee();
            }
        } else {
            block6: {
                try {
                    this.tee.write(b);
                }
                catch (IOException e) {
                    if (this.bestEffort) break block6;
                    throw e;
                }
            }
            if (this.autoFlush) {
                this.flushTee();
            }
        }
        return b;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int read = super.read(buf, off, len);
        if (read < 0) {
            if (this.autoClose) {
                this.closeTee();
            }
        } else {
            block6: {
                try {
                    this.tee.write(buf, off, read);
                }
                catch (IOException e) {
                    if (this.bestEffort) break block6;
                    throw e;
                }
            }
            if (this.autoFlush) {
                this.flushTee();
            }
        }
        return read;
    }

    public void close() throws IOException {
        super.close();
        if (this.autoClose) {
            this.closeTee();
        }
    }

    private void closeTee() throws IOException {
        try {
            this.tee.close();
        }
        catch (IOException e) {
            if (this.bestEffort) {
                return;
            }
            throw e;
        }
    }

    private void flushTee() throws IOException {
        try {
            this.tee.flush();
        }
        catch (IOException e) {
            if (this.bestEffort) {
                return;
            }
            throw e;
        }
    }
}

