/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;

public class CollectionWordLoops {
    static final String[] WORDS_FILES = new String[]{"kw.txt", "class.txt", "dir.txt", "ids.txt", "/usr/dict/words", "/usr/share/dict/words"};
    static final int MAX_WORDS = 500000;
    static final int pinsert = 80;
    static final int premove = 2;
    static final int NOPS = 100000;
    static final int numTests = 2;

    public static void main(String[] args) {
        int s;
        Class<?> collectionClass = null;
        try {
            collectionClass = Class.forName(args[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + args[0] + " not found.");
        }
        System.out.println("Testing " + collectionClass.getName());
        for (s = 0; s < WORDS_FILES.length; ++s) {
            CollectionWordLoops.tests(collectionClass, 2, s);
        }
        for (s = WORDS_FILES.length - 1; s >= 0; --s) {
            CollectionWordLoops.tests(collectionClass, 2, s);
        }
    }

    static void tests(Class collectionClass, int numTests, int sizeIndex) {
        try {
            String[] key = CollectionWordLoops.readWords(sizeIndex);
            int size = key.length;
            System.out.print("n = " + LoopHelpers.rightJustify(size) + " : ");
            long least = Long.MAX_VALUE;
            for (int i = 0; i < numTests; ++i) {
                Collection m = CollectionWordLoops.newCollection(collectionClass);
                long t = CollectionWordLoops.doTest(collectionClass.getName(), m, key);
                if (t < least) {
                    least = t;
                }
                m.clear();
                m = null;
            }
            long nano = Math.round(1000000.0 * (double)least / 100000.0);
            System.out.println(LoopHelpers.rightJustify(nano) + " ns per op");
        }
        catch (IOException ignore) {
            return;
        }
    }

    static Collection newCollection(Class cl) {
        try {
            Collection m = (Collection)cl.newInstance();
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate " + cl + ": " + e);
        }
    }

    static void pause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            return;
        }
    }

    static String[] readWords(int sizeIndex) throws IOException {
        String[] l = new String[500000];
        String[] array = null;
        try {
            String s;
            FileReader fr = new FileReader(WORDS_FILES[sizeIndex]);
            BufferedReader reader = new BufferedReader(fr);
            int k = 0;
            while ((s = reader.readLine()) != null) {
                l[k++] = s;
            }
            array = new String[k];
            for (int i = 0; i < k; ++i) {
                array[i] = l[i];
                l[i] = null;
            }
            l = null;
            reader.close();
        }
        catch (IOException ex) {
            System.out.println("Can't read words file:" + ex);
            throw ex;
        }
        return array;
    }

    static long doTest(String name, Collection m, String[] key) {
        int sz;
        Runner runner = new Runner(m, key);
        long startTime = System.currentTimeMillis();
        runner.run();
        long afterRun = System.currentTimeMillis();
        long runTime = afterRun - startTime;
        int np = runner.total;
        if (runner.total == runner.hashCode()) {
            System.out.println("Useless Number" + runner.total);
        }
        if ((sz = runner.maxsz) == runner.hashCode()) {
            System.out.println("Useless Number" + sz);
        }
        return runTime;
    }

    static class Runner
    implements Runnable {
        final Collection collection;
        final String[] key;
        LoopHelpers.SimpleRandom rng = new LoopHelpers.SimpleRandom();
        final int pctrem;
        final int pctins;
        int nputs = 0;
        int npgets = 0;
        int nagets = 0;
        int nremoves = 0;
        volatile int total;
        int maxsz;

        Runner(Collection m, String[] k) {
            this.collection = m;
            this.key = k;
            this.pctrem = 42949672;
            this.pctins = 0x66666664;
        }

        int oneStep(int j) {
            String k;
            int l;
            int n = this.key.length;
            int r = this.rng.next() & Integer.MAX_VALUE;
            int jinc = r & 7;
            if ((j += jinc - 3) >= n) {
                j -= n;
            }
            if (j < 0) {
                j += n;
            }
            if ((l = n / 4 + j) >= n) {
                l -= n;
            }
            if (!this.collection.contains(k = this.key[j])) {
                ++this.nagets;
                if (r < this.pctins) {
                    this.collection.add(k);
                    ++this.nputs;
                    int csz = this.nputs - this.nremoves;
                    if (csz > this.maxsz) {
                        this.maxsz = csz;
                    }
                }
            } else {
                ++this.npgets;
                if (r < this.pctrem) {
                    this.collection.remove(k);
                    ++this.nremoves;
                    if ((j += (r >>> 8 & 7) + n / 2) >= n) {
                        j -= n;
                    }
                }
            }
            return j;
        }

        public void run() {
            int j = this.key.length / 2;
            for (int i = 0; i < 100000; ++i) {
                j = this.oneStep(j);
            }
            this.total = this.nputs + this.npgets + this.nagets + this.nremoves;
        }
    }
}

