/*
 * Decompiled with CFR 0.152.
 */
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.collections.RadkeHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class IntMapCheck {
    static int absentSize;
    static int absentMask;
    static Integer[] absent;
    static final Integer MISSING;
    static TestTimer timer;
    static Random rng;

    static void reallyAssert(boolean b) {
        if (!b) {
            throw new Error("Failed Assertion");
        }
    }

    public static void main(String[] args) throws Exception {
        Class mapClass = RadkeHashMap.class;
        int numTests = 50;
        int size = 50000;
        if (args.length > 0) {
            try {
                mapClass = Class.forName(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class " + args[0] + " not found.");
            }
        }
        if (args.length > 1) {
            numTests = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            size = Integer.parseInt(args[2]);
        }
        boolean doSerializeTest = args.length > 3;
        System.out.println("Testing " + mapClass.getName() + " trials: " + numTests + " size: " + size);
        for (absentSize = 4; absentSize <= size; absentSize <<= 1) {
        }
        absentMask = absentSize - 1;
        absent = new Integer[absentSize];
        for (int i = 0; i < absentSize; ++i) {
            IntMapCheck.absent[i] = new Integer(2 * (i - 1) + 1);
        }
        Integer[] key = new Integer[size];
        for (int i = 0; i < size; ++i) {
            key[i] = new Integer(2 * i);
        }
        for (int rep = 0; rep < numTests; ++rep) {
            IntMapCheck.shuffle(absent);
            IntMapCheck.runTest(IntMapCheck.newMap(mapClass), key);
        }
        TestTimer.printStats();
        if (doSerializeTest) {
            IntMapCheck.stest(IntMapCheck.newMap(mapClass), size);
        }
    }

    static Map newMap(Class cl) {
        try {
            Map m = (Map)cl.newInstance();
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate " + cl + ": " + e);
        }
    }

    static void runTest(Map s, Integer[] key) {
        IntMapCheck.shuffle(key);
        int size = key.length;
        long startTime = Utils.nanoTime();
        IntMapCheck.test(s, key);
        long time = Utils.nanoTime() - startTime;
    }

    static void t1(String nm, int n, Map s, Integer[] key, int expect) {
        int sum = 0;
        int iters = 4;
        timer.start(nm, n * iters);
        for (int j = 0; j < iters; ++j) {
            for (int i = 0; i < n; ++i) {
                if (s.get(key[i]) == null) continue;
                ++sum;
            }
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == expect * iters);
    }

    static void t2(String nm, int n, Map s, Integer[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            if (s.remove(key[i]) == null) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == expect);
    }

    static void t3(String nm, int n, Map s, Integer[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            Integer k = key[i];
            Integer v = absent[i & absentMask];
            if (s.put(k, v) != null) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == expect);
    }

    static void t4(String nm, int n, Map s, Integer[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            if (!s.containsKey(key[i])) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == expect);
    }

    static void t5(String nm, int n, Map s, Integer[] key, int expect) {
        int sum = 0;
        timer.start(nm, n / 2);
        for (int i = n - 2; i >= 0; i -= 2) {
            if (s.remove(key[i]) == null) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == expect);
    }

    static void t6(String nm, int n, Map s, Integer[] k1, Integer[] k2) {
        int sum = 0;
        timer.start(nm, n * 2);
        for (int i = 0; i < n; ++i) {
            if (s.get(k1[i]) != null) {
                ++sum;
            }
            if (s.get(k2[i & absentMask]) == null) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == n);
    }

    static void t7(String nm, int n, Map s, Integer[] k1, Integer[] k2) {
        int sum = 0;
        timer.start(nm, n * 2);
        for (int i = 0; i < n; ++i) {
            if (s.containsKey(k1[i])) {
                ++sum;
            }
            if (!s.containsKey(k2[i & absentMask])) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == n);
    }

    static void t8(String nm, int n, Map s, Integer[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            if (s.get(key[i]) == null) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == expect);
    }

    static void t9(Map s) {
        int sum = 0;
        int iters = 20;
        timer.start("ContainsValue (/n)     ", iters * s.size());
        int step = absentSize / iters;
        for (int i = 0; i < absentSize; i += step) {
            if (!s.containsValue(absent[i])) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum != 0);
    }

    static void ktest(Map s, int size, Integer[] key) {
        timer.start("ContainsKey            ", size);
        Set ks = s.keySet();
        int sum = 0;
        for (int i = 0; i < size; ++i) {
            if (!ks.contains(key[i])) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void ittest1(Map s, int size) {
        int sum = 0;
        timer.start("Iter Key               ", size);
        Iterator it = s.keySet().iterator();
        while (it.hasNext()) {
            if (it.next() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void ittest2(Map s, int size) {
        int sum = 0;
        timer.start("Iter Value             ", size);
        Iterator it = s.values().iterator();
        while (it.hasNext()) {
            if (it.next() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void ittest3(Map s, int size) {
        int sum = 0;
        timer.start("Iter Entry             ", size);
        Iterator it = s.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void ittest4(Map s, int size, int pos) {
        IdentityHashMap<Integer, Integer> seen = new IdentityHashMap<Integer, Integer>(size);
        IntMapCheck.reallyAssert(s.size() == size);
        int sum = 0;
        timer.start("Iter XEntry            ", size);
        Iterator it = s.entrySet().iterator();
        Integer k = null;
        Integer v = null;
        for (int i = 0; i < size - pos; ++i) {
            Map.Entry x = it.next();
            k = (Integer)x.getKey();
            v = (Integer)x.getValue();
            seen.put(k, k);
            if (v == MISSING) continue;
            ++sum;
        }
        IntMapCheck.reallyAssert(s.containsKey(k));
        it.remove();
        IntMapCheck.reallyAssert(!s.containsKey(k));
        while (it.hasNext()) {
            Map.Entry x = it.next();
            Integer k2 = (Integer)x.getKey();
            seen.put(k2, k2);
            if (k2 == MISSING) continue;
            ++sum;
        }
        IntMapCheck.reallyAssert(s.size() == size - 1);
        s.put(k, v);
        IntMapCheck.reallyAssert(seen.size() == size);
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
        IntMapCheck.reallyAssert(s.size() == size);
    }

    static void ittest(Map s, int size) {
        IntMapCheck.ittest1(s, size);
        IntMapCheck.ittest2(s, size);
        IntMapCheck.ittest3(s, size);
    }

    static void entest1(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iter Enumeration Key   ", size);
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void entest2(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iter Enumeration Value ", size);
        Enumeration en = ht.elements();
        while (en.hasMoreElements()) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void entest3(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iterf Enumeration Key  ", size);
        Enumeration en = ht.keys();
        for (int i = 0; i < size; ++i) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void entest4(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iterf Enumeration Value", size);
        Enumeration en = ht.elements();
        for (int i = 0; i < size; ++i) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
    }

    static void entest(Map s, int size) {
        if (s instanceof Hashtable) {
            Hashtable ht = (Hashtable)s;
            IntMapCheck.entest1(ht, size);
            IntMapCheck.entest2(ht, size);
            IntMapCheck.entest1(ht, size);
            IntMapCheck.entest2(ht, size);
            IntMapCheck.entest1(ht, size);
            IntMapCheck.entest2(ht, size);
        }
    }

    static void rtest(Map s, int size) {
        timer.start("Remove (iterator)      ", size);
        Iterator it = s.keySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        timer.finish();
    }

    static void rvtest(Map s, int size) {
        timer.start("Remove (iterator)      ", size);
        Iterator it = s.values().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        timer.finish();
    }

    static void dtest(Map s, int size, Integer[] key) {
        timer.start("Put (putAll)           ", size * 2);
        Map s2 = null;
        try {
            s2 = (Map)s.getClass().newInstance();
            s2.putAll(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        timer.finish();
        timer.start("Iter Equals            ", size * 2);
        boolean eqt = ((Object)s2).equals(s) && ((Object)s).equals(s2);
        IntMapCheck.reallyAssert(eqt);
        timer.finish();
        timer.start("Iter HashCode          ", size * 2);
        int shc = ((Object)s).hashCode();
        int s2hc = ((Object)s2).hashCode();
        IntMapCheck.reallyAssert(shc == s2hc);
        timer.finish();
        timer.start("Put (present)          ", size);
        s2.putAll(s);
        timer.finish();
        timer.start("Iter EntrySet contains ", size * 2);
        Set es2 = s2.entrySet();
        int sum = 0;
        Iterator i1 = s.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry entry = i1.next();
            if (!es2.contains(entry)) continue;
            ++sum;
        }
        timer.finish();
        IntMapCheck.reallyAssert(sum == size);
        IntMapCheck.t6("Get                    ", size, s2, key, absent);
        Integer hold = (Integer)s2.get(key[size - 1]);
        s2.put(key[size - 1], absent[0]);
        timer.start("Iter Equals            ", size * 2);
        eqt = ((Object)s2).equals(s) && ((Object)s).equals(s2);
        IntMapCheck.reallyAssert(!eqt);
        timer.finish();
        timer.start("Iter HashCode          ", size * 2);
        int s1h = ((Object)s).hashCode();
        int s2h = ((Object)s2).hashCode();
        IntMapCheck.reallyAssert(s1h != s2h);
        timer.finish();
        s2.put(key[size - 1], hold);
        timer.start("Remove (iterator)      ", size * 2);
        Iterator s2i = s2.entrySet().iterator();
        Set es = s.entrySet();
        while (s2i.hasNext()) {
            IntMapCheck.reallyAssert(es.remove(s2i.next()));
        }
        timer.finish();
        if (!s.isEmpty()) {
            System.out.println(s);
        }
        IntMapCheck.reallyAssert(s.isEmpty());
        timer.start("Clear                  ", size);
        s2.clear();
        timer.finish();
        IntMapCheck.reallyAssert(s2.isEmpty() && s.isEmpty());
    }

    static void stest(Map s, int size) throws Exception {
        if (!(s instanceof Serializable)) {
            return;
        }
        System.out.print("Serialize              : ");
        for (int i = 0; i < size; ++i) {
            s.put(new Integer(i), new Integer(1));
        }
        long startTime = Utils.nanoTime();
        FileOutputStream fs = new FileOutputStream("IntMapCheck.dat");
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(fs));
        out.writeObject(s);
        out.close();
        FileInputStream is = new FileInputStream("IntMapCheck.dat");
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(is));
        Map m = (Map)in.readObject();
        long endTime = Utils.nanoTime();
        long time = endTime - startTime;
        System.out.print(time + "ms");
        if (s instanceof IdentityHashMap) {
            return;
        }
        IntMapCheck.reallyAssert(((Object)s).equals(m));
    }

    static void test(Map s, Integer[] key) {
        int size = key.length;
        IntMapCheck.t3("Put (absent)           ", size, s, key, size);
        IntMapCheck.t3("Put (present)          ", size, s, key, 0);
        IntMapCheck.t7("ContainsKey            ", size, s, key, absent);
        IntMapCheck.t4("ContainsKey            ", size, s, key, size);
        IntMapCheck.ktest(s, size, key);
        IntMapCheck.t4("ContainsKey            ", absentSize, s, absent, 0);
        IntMapCheck.t6("Get                    ", size, s, key, absent);
        IntMapCheck.t1("Get (present)          ", size, s, key, size);
        IntMapCheck.t1("Get (absent)           ", absentSize, s, absent, 0);
        IntMapCheck.t2("Remove (absent)        ", absentSize, s, absent, 0);
        IntMapCheck.t5("Remove (present)       ", size, s, key, size / 2);
        IntMapCheck.t3("Put (half present)     ", size, s, key, size / 2);
        IntMapCheck.ittest(s, size);
        IntMapCheck.entest(s, size);
        IntMapCheck.t9(s);
        IntMapCheck.rtest(s, size);
        IntMapCheck.t4("ContainsKey            ", size, s, key, 0);
        IntMapCheck.t2("Remove (absent)        ", size, s, key, 0);
        IntMapCheck.t3("Put (presized)         ", size, s, key, size);
        IntMapCheck.dtest(s, size, key);
    }

    static void shuffle(Integer[] keys) {
        int size;
        for (int i = size = keys.length; i > 1; --i) {
            int r = rng.nextInt(i);
            Integer t = keys[i - 1];
            keys[i - 1] = keys[r];
            keys[r] = t;
        }
    }

    static {
        MISSING = new Integer(Integer.MIN_VALUE);
        timer = new TestTimer();
        rng = new Random();
    }

    static class Stats {
        double sum = 0.0;
        double least;
        long number = 0L;

        Stats(double t) {
            this.least = t;
        }
    }

    static class TestTimer {
        private String name;
        private long numOps;
        private long startTime;
        private String cname;
        static final TreeMap accum = new TreeMap();

        TestTimer() {
        }

        static void printStats() {
            Iterator it = accum.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Stats stats = (Stats)e.getValue();
                long n = stats.number;
                double t = n > 0L ? stats.sum / (double)n : stats.least;
                long nano = Math.round(1000000.0 * t);
                System.out.println(e.getKey() + ": " + nano);
            }
        }

        void start(String name, long numOps) {
            this.name = name;
            this.cname = this.classify();
            this.numOps = numOps;
            this.startTime = Utils.nanoTime();
        }

        String classify() {
            if (this.name.startsWith("Get")) {
                return "Get                    ";
            }
            if (this.name.startsWith("Put")) {
                return "Put                    ";
            }
            if (this.name.startsWith("Remove")) {
                return "Remove                 ";
            }
            if (this.name.startsWith("Iter")) {
                return "Iter                   ";
            }
            return null;
        }

        void finish() {
            Stats stats;
            long endTime = Utils.nanoTime();
            long time = endTime - this.startTime;
            double timePerOp = (double)time / (double)this.numOps / 1000000.0;
            Object st = accum.get(this.name);
            if (st == null) {
                accum.put(this.name, new Stats(timePerOp));
            } else {
                stats = (Stats)st;
                stats.sum += timePerOp;
                ++stats.number;
                if (timePerOp < stats.least) {
                    stats.least = timePerOp;
                }
            }
            if (this.cname != null) {
                st = accum.get(this.cname);
                if (st == null) {
                    accum.put(this.cname, new Stats(timePerOp));
                } else {
                    stats = (Stats)st;
                    stats.sum += timePerOp;
                    ++stats.number;
                    if (timePerOp < stats.least) {
                        stats.least = timePerOp;
                    }
                }
            }
        }
    }
}

