/*
 * Decompiled with CFR 0.152.
 */
import edu.emory.mathcs.util.collections.longs.LongCollections;
import edu.emory.mathcs.util.collections.longs.LongIntervalSet;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongRadkeHashSet;
import edu.emory.mathcs.util.collections.longs.LongSortedSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LongIntervalSetTest
extends UtilTestCase {
    private static final long zero = 0L;
    private static final long one = 1L;
    private static final long two = 2L;
    private static final long three = 3L;
    private static final long four = 4L;
    private static final long five = 5L;
    private static final long six = 6L;
    static final int SIZE = 20;

    public static void main(String[] args) {
        TestRunner.run((Test)LongIntervalSetTest.suite());
    }

    public static Test suite() {
        return new TestSuite(LongIntervalSetTest.class);
    }

    private LongIntervalSet populatedSet(int n) {
        int i;
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSetTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            LongIntervalSetTest.assertTrue((boolean)q.add(i));
        }
        for (i = n & 1; i < n; i += 2) {
            LongIntervalSetTest.assertTrue((boolean)q.add(i));
        }
        LongIntervalSetTest.assertFalse((boolean)q.isEmpty());
        LongIntervalSetTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    private LongIntervalSet set5() {
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSetTest.assertTrue((boolean)q.isEmpty());
        q.add(1L);
        q.add(2L);
        q.add(3L);
        q.add(4L);
        q.add(5L);
        LongIntervalSetTest.assertEquals((int)5, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        LongIntervalSetTest.assertEquals((int)0, (int)new LongIntervalSet().size());
    }

    public void testConstructor3() {
        try {
            LongIntervalSet q = new LongIntervalSet(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor6() {
        long[] ints = new long[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = i;
        }
        LongIntervalSet q = new LongIntervalSet(LongCollections.asList(ints));
        for (int i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertEquals((long)ints[i], (long)q.pollFirst());
        }
    }

    public void testEmpty() {
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSetTest.assertTrue((boolean)q.isEmpty());
        q.add(1L);
        LongIntervalSetTest.assertFalse((boolean)q.isEmpty());
        q.add(2L);
        q.pollFirst();
        q.pollFirst();
        LongIntervalSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        LongIntervalSet q = this.populatedSet(20);
        for (i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertEquals((int)(20 - i), (int)q.size());
            q.pollFirst();
        }
        for (i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertEquals((int)i, (int)q.size());
            q.add(i);
        }
    }

    public void testAdd() {
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSetTest.assertTrue((boolean)q.add(0L));
        LongIntervalSetTest.assertTrue((boolean)q.add(1L));
    }

    public void testAddDup() {
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSetTest.assertTrue((boolean)q.add(0L));
        LongIntervalSetTest.assertFalse((boolean)q.add(0L));
    }

    public void testAddAll1() {
        try {
            LongIntervalSet q = new LongIntervalSet();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAll5() {
        long[] empty = new long[]{};
        long[] ints = new long[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = 19 - i;
        }
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSetTest.assertFalse((boolean)q.addAll(LongCollections.asList(empty)));
        LongIntervalSetTest.assertTrue((boolean)q.addAll(LongCollections.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertEquals((long)i, (long)q.pollFirst());
        }
    }

    public void testPollFirst() {
        LongIntervalSet q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertEquals((long)i, (long)q.pollFirst());
        }
        try {
            q.pollFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testPollLast() {
        LongIntervalSet q = this.populatedSet(20);
        for (int i = 19; i >= 0; --i) {
            LongIntervalSetTest.assertEquals((long)i, (long)q.pollLast());
        }
        try {
            q.pollLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        LongIntervalSet q = this.populatedSet(20);
        for (i = 1; i < 20; i += 2) {
            LongIntervalSetTest.assertTrue((boolean)q.remove(i));
        }
        for (i = 0; i < 20; i += 2) {
            LongIntervalSetTest.assertTrue((boolean)q.remove(i));
            LongIntervalSetTest.assertFalse((boolean)q.remove(i + 1));
        }
        LongIntervalSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        LongIntervalSet q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertTrue((boolean)q.contains(i));
            q.pollFirst();
            LongIntervalSetTest.assertFalse((boolean)q.contains(i));
        }
    }

    public void testClear() {
        LongIntervalSet q = this.populatedSet(20);
        q.clear();
        LongIntervalSetTest.assertTrue((boolean)q.isEmpty());
        LongIntervalSetTest.assertEquals((int)0, (int)q.size());
        q.add(1L);
        LongIntervalSetTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        LongIntervalSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        LongIntervalSet q = this.populatedSet(20);
        LongIntervalSet p = new LongIntervalSet();
        for (int i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertTrue((boolean)q.containsAll(p));
            LongIntervalSetTest.assertFalse((boolean)p.containsAll(q));
            p.add(i);
        }
        LongIntervalSetTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        LongIntervalSet q = this.populatedSet(20);
        LongIntervalSet p = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                LongIntervalSetTest.assertFalse((boolean)changed);
            } else {
                LongIntervalSetTest.assertTrue((boolean)changed);
            }
            LongIntervalSetTest.assertTrue((boolean)q.containsAll(p));
            LongIntervalSetTest.assertEquals((int)(20 - i), (int)q.size());
            p.pollFirst();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            LongIntervalSet q = this.populatedSet(20);
            LongIntervalSet p = this.populatedSet(i);
            LongIntervalSetTest.assertTrue((boolean)q.removeAll(p));
            LongIntervalSetTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                long I = p.pollFirst();
                LongIntervalSetTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testLower() {
        LongIntervalSet q = this.set5();
        long e1 = q.lower(3L);
        LongIntervalSetTest.assertEquals((long)2L, (long)e1);
        long e2 = q.lower(6L);
        LongIntervalSetTest.assertEquals((long)5L, (long)e2);
        try {
            long e3 = q.lower(1L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            long e4 = q.lower(0L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testHigher() {
        LongIntervalSet q = this.set5();
        long e1 = q.higher(3L);
        LongIntervalSetTest.assertEquals((long)4L, (long)e1);
        long e2 = q.higher(0L);
        LongIntervalSetTest.assertEquals((long)1L, (long)e2);
        try {
            long e3 = q.higher(5L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            long e4 = q.higher(6L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testFloor() {
        LongIntervalSet q = this.set5();
        long e1 = q.floor(3L);
        LongIntervalSetTest.assertEquals((long)3L, (long)e1);
        long e2 = q.floor(6L);
        LongIntervalSetTest.assertEquals((long)5L, (long)e2);
        long e3 = q.floor(1L);
        LongIntervalSetTest.assertEquals((long)1L, (long)e3);
        try {
            long e4 = q.floor(0L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testCeiling() {
        LongIntervalSet q = this.set5();
        long e1 = q.ceiling(3L);
        LongIntervalSetTest.assertEquals((long)3L, (long)e1);
        long e2 = q.ceiling(0L);
        LongIntervalSetTest.assertEquals((long)1L, (long)e2);
        long e3 = q.ceiling(5L);
        LongIntervalSetTest.assertEquals((long)5L, (long)e3);
        try {
            long e4 = q.ceiling(6L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testToArray() {
        LongIntervalSet q = this.populatedSet(20);
        long[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            LongIntervalSetTest.assertEquals((long)o[i], (long)q.pollFirst());
        }
    }

    public void testToArray2() {
        LongIntervalSet q = this.populatedSet(20);
        long[] ints = new long[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            LongIntervalSetTest.assertEquals((long)ints[i], (long)q.pollFirst());
        }
    }

    public void testIterator() {
        LongIntervalSet q = this.populatedSet(20);
        int i = 0;
        LongIterator it = q.iterator();
        while (it.hasNext()) {
            LongIntervalSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LongIntervalSetTest.assertEquals((int)i, (int)20);
    }

    public void testEmptyIterator() {
        LongIntervalSet q = new LongIntervalSet();
        int i = 0;
        LongIterator it = q.iterator();
        while (it.hasNext()) {
            LongIntervalSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LongIntervalSetTest.assertEquals((int)i, (int)0);
    }

    public void testIteratorRemove() {
        LongIntervalSet q = new LongIntervalSet();
        q.add(2L);
        q.add(1L);
        q.add(3L);
        LongIterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        LongIntervalSetTest.assertEquals((long)it.next(), (long)2L);
        LongIntervalSetTest.assertEquals((long)it.next(), (long)3L);
        LongIntervalSetTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        LongIntervalSet q = this.populatedSet(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            LongIntervalSetTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() {
        LongIntervalSet q = this.populatedSet(20);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
            out.writeObject(q);
            out.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
            LongIntervalSet r = (LongIntervalSet)in.readObject();
            LongIntervalSetTest.assertEquals((int)q.size(), (int)r.size());
            while (!q.isEmpty()) {
                LongIntervalSetTest.assertEquals((long)q.pollFirst(), (long)r.pollFirst());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.unexpectedException();
        }
    }

    public void testSubSetContents() {
        LongIntervalSet set = this.set5();
        LongSortedSet sm = set.subSet(2L, 3L);
        LongIntervalSetTest.assertEquals((long)2L, (long)sm.first());
        LongIntervalSetTest.assertEquals((long)3L, (long)sm.last());
        LongIntervalSetTest.assertEquals((int)2, (int)sm.size());
        LongIntervalSetTest.assertFalse((boolean)sm.contains(1L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(3L));
        LongIntervalSetTest.assertFalse((boolean)sm.contains(4L));
        LongIntervalSetTest.assertFalse((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSetTest.assertEquals((long)2L, (long)k);
        k = i.next();
        LongIntervalSetTest.assertEquals((long)3L, (long)k);
        LongIntervalSetTest.assertFalse((boolean)i.hasNext());
        LongIterator j = sm.iterator();
        j.next();
        j.remove();
        LongIntervalSetTest.assertFalse((boolean)set.contains(2L));
        LongIntervalSetTest.assertEquals((int)4, (int)set.size());
        LongIntervalSetTest.assertEquals((int)1, (int)sm.size());
        LongIntervalSetTest.assertEquals((long)3L, (long)sm.first());
        LongIntervalSetTest.assertEquals((long)3L, (long)sm.last());
        LongIntervalSetTest.assertTrue((boolean)sm.remove(3L));
        LongIntervalSetTest.assertTrue((boolean)sm.isEmpty());
        LongIntervalSetTest.assertEquals((int)3, (int)set.size());
    }

    public void testSubSetContents2() {
        LongIntervalSet set = this.set5();
        LongSortedSet sm = set.subSet(2L, 2L);
        LongIntervalSetTest.assertEquals((int)1, (int)sm.size());
        LongIntervalSetTest.assertEquals((long)2L, (long)sm.first());
        LongIntervalSetTest.assertEquals((long)2L, (long)sm.last());
        LongIntervalSetTest.assertFalse((boolean)sm.contains(1L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSetTest.assertFalse((boolean)sm.contains(3L));
        LongIntervalSetTest.assertFalse((boolean)sm.contains(4L));
        LongIntervalSetTest.assertFalse((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSetTest.assertEquals((long)2L, (long)k);
        LongIntervalSetTest.assertFalse((boolean)i.hasNext());
        LongIterator j = sm.iterator();
        j.next();
        j.remove();
        LongIntervalSetTest.assertFalse((boolean)set.contains(2L));
        LongIntervalSetTest.assertEquals((int)4, (int)set.size());
        LongIntervalSetTest.assertEquals((int)0, (int)sm.size());
        LongIntervalSetTest.assertTrue((boolean)sm.isEmpty());
        LongIntervalSetTest.assertFalse((boolean)sm.remove(3L));
        LongIntervalSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testHeadSetContents() {
        LongIntervalSet set = this.set5();
        LongSortedSet sm = set.headSet(3L);
        LongIntervalSetTest.assertTrue((boolean)sm.contains(1L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(3L));
        LongIntervalSetTest.assertFalse((boolean)sm.contains(4L));
        LongIntervalSetTest.assertFalse((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSetTest.assertEquals((long)1L, (long)k);
        k = i.next();
        LongIntervalSetTest.assertEquals((long)2L, (long)k);
        k = i.next();
        LongIntervalSetTest.assertEquals((long)3L, (long)k);
        LongIntervalSetTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        LongIntervalSetTest.assertTrue((boolean)sm.isEmpty());
        LongIntervalSetTest.assertEquals((int)2, (int)set.size());
        LongIntervalSetTest.assertEquals((long)4L, (long)set.first());
    }

    public void testTailSetContents() {
        LongIntervalSet set = this.set5();
        LongSortedSet sm = set.tailSet(2L);
        LongIntervalSetTest.assertFalse((boolean)sm.contains(1L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(3L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(4L));
        LongIntervalSetTest.assertTrue((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSetTest.assertEquals((long)2L, (long)k);
        k = i.next();
        LongIntervalSetTest.assertEquals((long)3L, (long)k);
        k = i.next();
        LongIntervalSetTest.assertEquals((long)4L, (long)k);
        k = i.next();
        LongIntervalSetTest.assertEquals((long)5L, (long)k);
        LongIntervalSetTest.assertFalse((boolean)i.hasNext());
        LongSortedSet ssm = sm.tailSet(4L);
        LongIntervalSetTest.assertEquals((long)4L, (long)ssm.first());
        LongIntervalSetTest.assertEquals((long)5L, (long)ssm.last());
        LongIntervalSetTest.assertTrue((boolean)ssm.remove(4L));
        LongIntervalSetTest.assertEquals((int)1, (int)ssm.size());
        LongIntervalSetTest.assertEquals((int)3, (int)sm.size());
        LongIntervalSetTest.assertEquals((int)4, (int)set.size());
    }

    private static void compoundTest1(int min, int max, int num) {
        LongIntervalSet set = new LongIntervalSet();
        Random r = new Random();
        set.contains(50L);
        for (long i = 0L; i < (long)num; ++i) {
            set.add(r.nextInt(max - min) + min);
        }
        long v1 = r.nextInt(max - min) + min;
        long v2 = (long)r.nextInt(max - min - (int)v1) + v1;
        set.removeInterval(v1, v2);
        LongIntervalSetTest.assertTrue((!set.containsInterval(v1, v2) ? 1 : 0) != 0);
        LongIntervalSetTest.assertTrue((boolean)set.complementSet().containsInterval(v1, v2));
    }

    private static void compoundTest2() {
        LongIntervalSet set = new LongIntervalSet(-50L, 50L);
        Random r = new Random();
        for (int i = 0; i < 400; ++i) {
            set.add(r.nextInt(200) - 100);
        }
        LongRadkeHashSet s1 = new LongRadkeHashSet(set);
        LongIntervalSetTest.assertEquals((Object)s1, (Object)set);
        LongIntervalSetTest.assertEquals((Object)set, (Object)s1);
        LongSortedSet cpl = (LongSortedSet)set.complementSet();
        for (int i = 0; i < 200; ++i) {
            cpl.add(r.nextInt(200) - 100);
        }
        LongIntervalSetTest.assertTrue((boolean)s1.containsAll(set));
        LongIntervalSetTest.assertTrue((boolean)set.containsAll(cpl.complementSet()));
        s1.removeAll(set);
        cpl.removeAll(new LongRadkeHashSet(s1));
        LongIntervalSet s2 = new LongIntervalSet(cpl);
        s2.addAll(((LongSortedSet)cpl.complementSet()).subSet(-50L, -1L));
        LongIntervalSetTest.assertTrue((boolean)s2.containsInterval(-50L, -1L));
    }

    public void testCompound() {
        LongIntervalSetTest.compoundTest1(-20, 20, 10);
        LongIntervalSetTest.compoundTest1(-20, 20, 60);
        LongIntervalSetTest.compoundTest1(-20, 20, 200);
        LongIntervalSetTest.compoundTest2();
    }

    static class MyReverseComparator
    implements Comparator {
        MyReverseComparator() {
        }

        public int compare(Object x, Object y) {
            int j;
            int i = (Integer)x;
            if (i < (j = ((Integer)y).intValue())) {
                return 1;
            }
            if (i > j) {
                return -1;
            }
            return 0;
        }
    }
}

