/*
 * Decompiled with CFR 0.152.
 */
import edu.emory.mathcs.util.collections.longs.LongCollections;
import edu.emory.mathcs.util.collections.longs.LongIntervalSet;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongSortedSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LongIntervalSubSetTest
extends UtilTestCase {
    private static final long zero = 0L;
    private static final long one = 1L;
    private static final long two = 2L;
    private static final long three = 3L;
    private static final long four = 4L;
    private static final long five = 5L;
    private static final long six = 6L;
    private static final long seven = 7L;
    private static final long m1 = -1L;
    private static final long m2 = -2L;
    private static final long m3 = -3L;
    private static final long m4 = -4L;
    private static final long m5 = -5L;
    private static final long m10 = -10L;

    public static void main(String[] args) {
        TestRunner.run((Test)LongIntervalSubSetTest.suite());
    }

    public static Test suite() {
        return new TestSuite(LongIntervalSubSetTest.class);
    }

    private LongSortedSet populatedSet(int n) {
        int i;
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSubSetTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            LongIntervalSubSetTest.assertTrue((boolean)q.add(i));
        }
        for (i = n & 1; i < n; i += 2) {
            LongIntervalSubSetTest.assertTrue((boolean)q.add(i));
        }
        LongIntervalSubSetTest.assertTrue((boolean)q.add(-n));
        LongIntervalSubSetTest.assertTrue((boolean)q.add(n));
        LongSortedSet s = q.subSet(0L, n - 1);
        LongIntervalSubSetTest.assertFalse((boolean)s.isEmpty());
        LongIntervalSubSetTest.assertEquals((int)n, (int)s.size());
        return s;
    }

    private LongSortedSet set5() {
        LongIntervalSet q = new LongIntervalSet();
        LongIntervalSubSetTest.assertTrue((boolean)q.isEmpty());
        q.add(1L);
        q.add(2L);
        q.add(3L);
        q.add(4L);
        q.add(5L);
        q.add(0L);
        q.add(7L);
        LongSortedSet s = q.subSet(1L, 6L);
        LongIntervalSubSetTest.assertEquals((int)5, (int)s.size());
        return s;
    }

    private static LongSortedSet set0() {
        LongIntervalSet set = new LongIntervalSet();
        LongIntervalSubSetTest.assertTrue((boolean)set.isEmpty());
        return set.tailSet(-1L);
    }

    public void testConstructor1() {
        LongIntervalSubSetTest.assertEquals((int)0, (int)LongIntervalSubSetTest.set0().size());
    }

    public void testEmpty() {
        LongSortedSet q = LongIntervalSubSetTest.set0();
        LongIntervalSubSetTest.assertTrue((boolean)q.isEmpty());
        q.add(1L);
        LongIntervalSubSetTest.assertFalse((boolean)q.isEmpty());
        q.add(2L);
        q.pollFirst();
        q.pollFirst();
        LongIntervalSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        LongSortedSet q = this.populatedSet(20);
        for (i = 0; i < 20; ++i) {
            LongIntervalSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            q.pollFirst();
        }
        for (i = 0; i < 20; ++i) {
            LongIntervalSubSetTest.assertEquals((int)i, (int)q.size());
            q.add(i);
        }
    }

    public void testAdd() {
        LongSortedSet q = LongIntervalSubSetTest.set0();
        LongIntervalSubSetTest.assertTrue((boolean)q.add(6L));
    }

    public void testAddDup() {
        LongSortedSet q = LongIntervalSubSetTest.set0();
        LongIntervalSubSetTest.assertTrue((boolean)q.add(6L));
        LongIntervalSubSetTest.assertFalse((boolean)q.add(6L));
    }

    public void testAddAll1() {
        try {
            LongSortedSet q = LongIntervalSubSetTest.set0();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAll5() {
        long[] empty = new long[]{};
        long[] ints = new long[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = 19 - i;
        }
        LongSortedSet q = LongIntervalSubSetTest.set0();
        LongIntervalSubSetTest.assertFalse((boolean)q.addAll(LongCollections.asList(empty)));
        LongIntervalSubSetTest.assertTrue((boolean)q.addAll(LongCollections.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            LongIntervalSubSetTest.assertEquals((long)i, (long)q.pollFirst());
        }
    }

    public void testPoll() {
        LongSortedSet q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            LongIntervalSubSetTest.assertEquals((long)i, (long)q.pollFirst());
        }
        try {
            q.pollFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        LongSortedSet q = this.populatedSet(20);
        for (i = 1; i < 20; i += 2) {
            LongIntervalSubSetTest.assertTrue((boolean)q.remove(i));
        }
        for (i = 0; i < 20; i += 2) {
            LongIntervalSubSetTest.assertTrue((boolean)q.remove(i));
            LongIntervalSubSetTest.assertFalse((boolean)q.remove(i + 1));
        }
        LongIntervalSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        LongSortedSet q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            LongIntervalSubSetTest.assertTrue((boolean)q.contains(i));
            q.pollFirst();
            LongIntervalSubSetTest.assertFalse((boolean)q.contains(i));
        }
    }

    public void testClear() {
        LongSortedSet q = this.populatedSet(20);
        q.clear();
        LongIntervalSubSetTest.assertTrue((boolean)q.isEmpty());
        LongIntervalSubSetTest.assertEquals((int)0, (int)q.size());
        q.add(1L);
        LongIntervalSubSetTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        LongIntervalSubSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        LongSortedSet q = this.populatedSet(20);
        LongSortedSet p = LongIntervalSubSetTest.set0();
        for (int i = 0; i < 20; ++i) {
            LongIntervalSubSetTest.assertTrue((boolean)q.containsAll(p));
            LongIntervalSubSetTest.assertFalse((boolean)p.containsAll(q));
            p.add(i);
        }
        LongIntervalSubSetTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        LongSortedSet q = this.populatedSet(20);
        LongSortedSet p = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                LongIntervalSubSetTest.assertFalse((boolean)changed);
            } else {
                LongIntervalSubSetTest.assertTrue((boolean)changed);
            }
            LongIntervalSubSetTest.assertTrue((boolean)q.containsAll(p));
            LongIntervalSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            p.pollFirst();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            LongSortedSet q = this.populatedSet(20);
            LongSortedSet p = this.populatedSet(i);
            LongIntervalSubSetTest.assertTrue((boolean)q.removeAll(p));
            LongIntervalSubSetTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                long I = p.pollFirst();
                LongIntervalSubSetTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testLower() {
        LongSortedSet q = this.set5();
        long e1 = q.lower(3L);
        LongIntervalSubSetTest.assertEquals((long)2L, (long)e1);
        long e2 = q.lower(6L);
        LongIntervalSubSetTest.assertEquals((long)5L, (long)e2);
        try {
            long e3 = q.lower(1L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            long e4 = q.lower(0L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testHigher() {
        LongSortedSet q = this.set5();
        long e1 = q.higher(3L);
        LongIntervalSubSetTest.assertEquals((long)4L, (long)e1);
        long e2 = q.higher(0L);
        LongIntervalSubSetTest.assertEquals((long)1L, (long)e2);
        try {
            long e3 = q.higher(5L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            long e4 = q.higher(6L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testFloor() {
        LongSortedSet q = this.set5();
        long e1 = q.floor(3L);
        LongIntervalSubSetTest.assertEquals((long)3L, (long)e1);
        long e2 = q.floor(6L);
        LongIntervalSubSetTest.assertEquals((long)5L, (long)e2);
        long e3 = q.floor(1L);
        LongIntervalSubSetTest.assertEquals((long)1L, (long)e3);
        try {
            long e4 = q.floor(0L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testCeiling() {
        LongSortedSet q = this.set5();
        long e1 = q.ceiling(3L);
        LongIntervalSubSetTest.assertEquals((long)3L, (long)e1);
        long e2 = q.ceiling(0L);
        LongIntervalSubSetTest.assertEquals((long)1L, (long)e2);
        long e3 = q.ceiling(5L);
        LongIntervalSubSetTest.assertEquals((long)5L, (long)e3);
        try {
            long e4 = q.ceiling(6L);
            this.shouldThrow();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testToArray() {
        LongSortedSet q = this.populatedSet(20);
        long[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            LongIntervalSubSetTest.assertEquals((long)o[i], (long)q.pollFirst());
        }
    }

    public void testToArray2() {
        LongSortedSet q = this.populatedSet(20);
        long[] ints = new long[20];
        ints = q.toArray(ints);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            LongIntervalSubSetTest.assertEquals((long)ints[i], (long)q.pollFirst());
        }
    }

    public void testIterator() {
        LongSortedSet q = this.populatedSet(20);
        int i = 0;
        LongIterator it = q.iterator();
        while (it.hasNext()) {
            LongIntervalSubSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LongIntervalSubSetTest.assertEquals((int)i, (int)20);
    }

    public void testEmptyIterator() {
        LongSortedSet q = LongIntervalSubSetTest.set0();
        int i = 0;
        LongIterator it = q.iterator();
        while (it.hasNext()) {
            LongIntervalSubSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LongIntervalSubSetTest.assertEquals((int)i, (int)0);
    }

    public void testIteratorRemove() {
        LongSortedSet q = LongIntervalSubSetTest.set0();
        q.add(2L);
        q.add(1L);
        q.add(3L);
        LongIterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        LongIntervalSubSetTest.assertEquals((long)it.next(), (long)2L);
        LongIntervalSubSetTest.assertEquals((long)it.next(), (long)3L);
        LongIntervalSubSetTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        LongSortedSet q = this.populatedSet(20);
        String s = ((Object)q).toString();
        for (int i = 0; i < 20; ++i) {
            LongIntervalSubSetTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() {
        LongSortedSet q = this.populatedSet(20);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
            out.writeObject(q);
            out.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
            LongSortedSet r = (LongSortedSet)in.readObject();
            LongIntervalSubSetTest.assertEquals((int)q.size(), (int)r.size());
            while (!q.isEmpty()) {
                LongIntervalSubSetTest.assertEquals((long)q.pollFirst(), (long)r.pollFirst());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.unexpectedException();
        }
    }

    public void testSubSetContents() {
        LongSortedSet set = this.set5();
        LongSortedSet sm = set.subSet(2L, 3L);
        LongIntervalSubSetTest.assertEquals((long)2L, (long)sm.first());
        LongIntervalSubSetTest.assertEquals((long)3L, (long)sm.last());
        LongIntervalSubSetTest.assertEquals((int)2, (int)sm.size());
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(1L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(3L));
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(4L));
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSubSetTest.assertEquals((long)2L, (long)k);
        k = i.next();
        LongIntervalSubSetTest.assertEquals((long)3L, (long)k);
        LongIntervalSubSetTest.assertFalse((boolean)i.hasNext());
        LongIterator j = sm.iterator();
        j.next();
        j.remove();
        LongIntervalSubSetTest.assertFalse((boolean)set.contains(2L));
        LongIntervalSubSetTest.assertEquals((int)4, (int)set.size());
        LongIntervalSubSetTest.assertEquals((int)1, (int)sm.size());
        LongIntervalSubSetTest.assertEquals((long)3L, (long)sm.first());
        LongIntervalSubSetTest.assertEquals((long)3L, (long)sm.last());
        LongIntervalSubSetTest.assertTrue((boolean)sm.remove(3L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.isEmpty());
        LongIntervalSubSetTest.assertEquals((int)3, (int)set.size());
    }

    public void testSubSetContents2() {
        LongSortedSet set = this.set5();
        LongSortedSet sm = set.subSet(2L, 2L);
        LongIntervalSubSetTest.assertEquals((int)1, (int)sm.size());
        LongIntervalSubSetTest.assertEquals((long)2L, (long)sm.first());
        LongIntervalSubSetTest.assertEquals((long)2L, (long)sm.last());
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(1L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(3L));
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(4L));
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSubSetTest.assertEquals((long)2L, (long)k);
        LongIntervalSubSetTest.assertFalse((boolean)i.hasNext());
        LongIterator j = sm.iterator();
        j.next();
        j.remove();
        LongIntervalSubSetTest.assertFalse((boolean)set.contains(2L));
        LongIntervalSubSetTest.assertEquals((int)4, (int)set.size());
        LongIntervalSubSetTest.assertEquals((int)0, (int)sm.size());
        LongIntervalSubSetTest.assertTrue((boolean)sm.isEmpty());
        LongIntervalSubSetTest.assertFalse((boolean)sm.remove(3L));
        LongIntervalSubSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testHeadSetContents() {
        LongSortedSet set = this.set5();
        LongSortedSet sm = set.headSet(3L);
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(1L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(3L));
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(4L));
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSubSetTest.assertEquals((long)1L, (long)k);
        k = i.next();
        LongIntervalSubSetTest.assertEquals((long)2L, (long)k);
        k = i.next();
        LongIntervalSubSetTest.assertEquals((long)3L, (long)k);
        LongIntervalSubSetTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        LongIntervalSubSetTest.assertTrue((boolean)sm.isEmpty());
        LongIntervalSubSetTest.assertEquals((int)2, (int)set.size());
        LongIntervalSubSetTest.assertEquals((long)4L, (long)set.first());
    }

    public void testTailSetContents() {
        LongSortedSet set = this.set5();
        LongSortedSet sm = set.tailSet(2L);
        LongIntervalSubSetTest.assertFalse((boolean)sm.contains(1L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(2L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(3L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(4L));
        LongIntervalSubSetTest.assertTrue((boolean)sm.contains(5L));
        LongIterator i = sm.iterator();
        long k = i.next();
        LongIntervalSubSetTest.assertEquals((long)2L, (long)k);
        k = i.next();
        LongIntervalSubSetTest.assertEquals((long)3L, (long)k);
        k = i.next();
        LongIntervalSubSetTest.assertEquals((long)4L, (long)k);
        k = i.next();
        LongIntervalSubSetTest.assertEquals((long)5L, (long)k);
        LongIntervalSubSetTest.assertFalse((boolean)i.hasNext());
        LongSortedSet ssm = sm.tailSet(4L);
        LongIntervalSubSetTest.assertEquals((long)4L, (long)ssm.first());
        LongIntervalSubSetTest.assertEquals((long)5L, (long)ssm.last());
        LongIntervalSubSetTest.assertTrue((boolean)ssm.remove(4L));
        LongIntervalSubSetTest.assertEquals((int)1, (int)ssm.size());
        LongIntervalSubSetTest.assertEquals((int)3, (int)sm.size());
        LongIntervalSubSetTest.assertEquals((int)4, (int)set.size());
    }

    static class MyReverseComparator
    implements Comparator {
        MyReverseComparator() {
        }

        public int compare(Object x, Object y) {
            int j;
            int i = (Integer)x;
            if (i < (j = ((Integer)y).intValue())) {
                return 1;
            }
            if (i > j) {
                return -1;
            }
            return 0;
        }
    }
}

