/*
 * Decompiled with CFR 0.152.
 */
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;

class LoopHelpers {
    static final SimpleRandom staticRNG = new SimpleRandom();
    public static final long compute8InitialValue = 88172645463325252L;

    LoopHelpers() {
    }

    public static int compute1(int x) {
        int lo = 16807 * (x & 0xFFFF);
        int hi = 16807 * (x >>> 16);
        if (((lo += (hi & Short.MAX_VALUE) << 16) & Integer.MIN_VALUE) != 0) {
            lo &= Integer.MAX_VALUE;
            ++lo;
        }
        if ((lo += hi >>> 15) == 0 || (lo & Integer.MIN_VALUE) != 0) {
            lo &= Integer.MAX_VALUE;
            ++lo;
        }
        return lo;
    }

    public static int compute2(int x) {
        int loops = x >>> 4 & 7;
        while (loops-- > 0) {
            x = x * Integer.MAX_VALUE % 16807;
        }
        return x;
    }

    public static int compute3(int x) {
        int t = x % 127773 * 16807 - x / 127773 * 2836;
        return t > 0 ? t : t + Integer.MAX_VALUE;
    }

    public static int compute4(int x) {
        return x * 134775813 + 1;
    }

    public static int compute5(int x) {
        return 36969 * (x & 0xFFFF) + (x >> 16);
    }

    public static int compute6(int y) {
        y ^= y << 1;
        y ^= y >>> 3;
        y ^= y << 10;
        return y;
    }

    public static int compute7(int y) {
        y ^= y << 6;
        y ^= y >>> 21;
        y ^= y << 7;
        return y;
    }

    public static long compute8(long x) {
        x ^= x << 13;
        x ^= x >>> 7;
        x ^= x << 17;
        return x;
    }

    public static String rightJustify(long n) {
        String field = "         ";
        String num = Long.toString(n);
        if (num.length() >= field.length()) {
            return num;
        }
        StringBuffer b = new StringBuffer(field);
        b.replace(b.length() - num.length(), b.length(), num);
        return b.toString();
    }

    public static class BarrierTimer
    implements Runnable {
        public volatile long startTime;
        public volatile long endTime;

        public void run() {
            long t = Utils.nanoTime();
            if (this.startTime == 0L) {
                this.startTime = t;
            } else {
                this.endTime = t;
            }
        }

        public void clear() {
            this.startTime = 0L;
            this.endTime = 0L;
        }

        public long getTime() {
            return this.endTime - this.startTime;
        }
    }

    public static class SimpleRandom {
        private static final long multiplier = 25214903917L;
        private static final long addend = 11L;
        private static final long mask = 0xFFFFFFFFFFFFL;
        static final AtomicLong seq = new AtomicLong(1L);
        private long seed = Utils.nanoTime() + seq.getAndIncrement();

        public void setSeed(long s) {
            this.seed = s;
        }

        public int next() {
            long nextseed;
            this.seed = nextseed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return (int)(nextseed >>> 17) & Integer.MAX_VALUE;
        }
    }

    public static class MarsagliaRandom {
        int x;
        int y = 842502087;
        int z = 34663;
        int w = 273326509;

        public MarsagliaRandom(int seed) {
            this.x = seed;
        }

        public MarsagliaRandom() {
            this((int)Utils.nanoTime());
        }

        public int next() {
            int t = this.x ^ this.x << 11;
            this.x = this.y;
            this.y = this.z;
            this.z = this.w;
            this.w = this.w ^ this.w >>> 19 ^ (t ^ t >>> 8);
            return this.w;
        }
    }
}

