/*
 * Decompiled with CFR 0.152.
 */
import edu.emory.mathcs.util.collections.RadkeHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class MapCheck {
    static final int absentSize = 131072;
    static final int absentMask = 131071;
    static Object[] absent = new Object[131072];
    static final Object MISSING = new Object();
    static TestTimer timer = new TestTimer();
    static Random rng = new Random();

    static void reallyAssert(boolean b) {
        if (!b) {
            throw new Error("Failed Assertion");
        }
    }

    public static void main(String[] args) throws Exception {
        Class mapClass = RadkeHashMap.class;
        System.out.println(Arrays.asList(args));
        int numTests = 50;
        int size = 50000;
        if (args.length > 0) {
            try {
                mapClass = Class.forName(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class " + args[0] + " not found.");
            }
        }
        if (args.length > 1) {
            numTests = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            size = Integer.parseInt(args[2]);
        }
        boolean doSerializeTest = args.length > 3;
        System.out.println("Testing " + mapClass.getName() + " trials: " + numTests + " size: " + size);
        for (int i = 0; i < 131072; ++i) {
            MapCheck.absent[i] = new Object();
        }
        Object[] key = new Object[size];
        for (int i = 0; i < size; ++i) {
            key[i] = new Object();
        }
        MapCheck.forceMem(size * 8);
        for (int rep = 0; rep < numTests; ++rep) {
            MapCheck.runTest(MapCheck.newMap(mapClass), key);
        }
        TestTimer.printStats();
        if (doSerializeTest) {
            MapCheck.stest(MapCheck.newMap(mapClass), size);
        }
    }

    static Map newMap(Class cl) {
        try {
            Map m = (Map)cl.newInstance();
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate " + cl + ": " + e);
        }
    }

    static void runTest(Map s, Object[] key) {
        MapCheck.shuffle(key);
        int size = key.length;
        long startTime = System.currentTimeMillis();
        MapCheck.test(s, key);
        long time = System.currentTimeMillis() - startTime;
    }

    static void forceMem(int n) {
        Long[] junk = new Long[n];
        for (int i = 0; i < junk.length; ++i) {
            junk[i] = new Long(i);
        }
        int sum = 0;
        for (int i = 0; i < junk.length; ++i) {
            sum += (int)(junk[i] + (long)i);
        }
        if (sum == 0) {
            System.out.println("Useless number = " + sum);
        }
        junk = null;
    }

    static void t1(String nm, int n, Map s, Object[] key, int expect) {
        int sum = 0;
        int iters = 4;
        timer.start(nm, n * iters);
        for (int j = 0; j < iters; ++j) {
            for (int i = 0; i < n; ++i) {
                if (s.get(key[i]) == null) continue;
                ++sum;
            }
        }
        timer.finish();
        MapCheck.reallyAssert(sum == expect * iters);
    }

    static void t2(String nm, int n, Map s, Object[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            if (s.remove(key[i]) == null) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == expect);
    }

    static void t3(String nm, int n, Map s, Object[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            if (s.put(key[i], absent[i & 0x1FFFF]) != null) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == expect);
    }

    static void t4(String nm, int n, Map s, Object[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            if (!s.containsKey(key[i])) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == expect);
    }

    static void t5(String nm, int n, Map s, Object[] key, int expect) {
        int sum = 0;
        timer.start(nm, n / 2);
        for (int i = n - 2; i >= 0; i -= 2) {
            if (s.remove(key[i]) == null) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == expect);
    }

    static void t6(String nm, int n, Map s, Object[] k1, Object[] k2) {
        int sum = 0;
        timer.start(nm, n * 2);
        for (int i = 0; i < n; ++i) {
            if (s.get(k1[i]) != null) {
                ++sum;
            }
            if (s.get(k2[i & 0x1FFFF]) == null) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == n);
    }

    static void t7(String nm, int n, Map s, Object[] k1, Object[] k2) {
        int sum = 0;
        timer.start(nm, n * 2);
        for (int i = 0; i < n; ++i) {
            if (s.containsKey(k1[i])) {
                ++sum;
            }
            if (!s.containsKey(k2[i & 0x1FFFF])) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == n);
    }

    static void t8(String nm, int n, Map s, Object[] key, int expect) {
        int sum = 0;
        timer.start(nm, n);
        for (int i = 0; i < n; ++i) {
            if (s.get(key[i]) == null) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == expect);
    }

    static void t9(Map s) {
        int sum = 0;
        int iters = 20;
        timer.start("ContainsValue (/n)     ", iters * s.size());
        int step = 131072 / iters;
        for (int i = 0; i < 131072; i += step) {
            if (!s.containsValue(absent[i])) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum != 0);
    }

    static void ktest(Map s, int size, Object[] key) {
        timer.start("ContainsKey            ", size);
        Set ks = s.keySet();
        int sum = 0;
        for (int i = 0; i < size; ++i) {
            if (!ks.contains(key[i])) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void ittest1(Map s, int size) {
        int sum = 0;
        timer.start("Iter Key               ", size);
        Iterator it = s.keySet().iterator();
        while (it.hasNext()) {
            if (it.next() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void ittest2(Map s, int size) {
        int sum = 0;
        timer.start("Iter Value             ", size);
        Iterator it = s.values().iterator();
        while (it.hasNext()) {
            if (it.next() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void ittest3(Map s, int size) {
        int sum = 0;
        timer.start("Iter Entry             ", size);
        Iterator it = s.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void ittest4(Map s, int size, int pos) {
        IdentityHashMap seen = new IdentityHashMap(size);
        MapCheck.reallyAssert(s.size() == size);
        int sum = 0;
        timer.start("Iter XEntry            ", size);
        Iterator it = s.entrySet().iterator();
        Object k = null;
        Object v = null;
        for (int i = 0; i < size - pos; ++i) {
            Map.Entry x = it.next();
            k = x.getKey();
            v = x.getValue();
            seen.put(k, k);
            if (x == MISSING) continue;
            ++sum;
        }
        MapCheck.reallyAssert(s.containsKey(k));
        it.remove();
        MapCheck.reallyAssert(!s.containsKey(k));
        while (it.hasNext()) {
            Map.Entry x = it.next();
            Object k2 = x.getKey();
            seen.put(k2, k2);
            if (x == MISSING) continue;
            ++sum;
        }
        MapCheck.reallyAssert(s.size() == size - 1);
        s.put(k, v);
        MapCheck.reallyAssert(seen.size() == size);
        timer.finish();
        MapCheck.reallyAssert(sum == size);
        MapCheck.reallyAssert(s.size() == size);
    }

    static void ittest(Map s, int size) {
        MapCheck.ittest1(s, size);
        MapCheck.ittest2(s, size);
        MapCheck.ittest3(s, size);
    }

    static void entest1(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iter Enumeration Key   ", size);
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void entest2(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iter Enumeration Value ", size);
        Enumeration en = ht.elements();
        while (en.hasMoreElements()) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void entest3(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iterf Enumeration Key  ", size);
        Enumeration en = ht.keys();
        for (int i = 0; i < size; ++i) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void entest4(Hashtable ht, int size) {
        int sum = 0;
        timer.start("Iterf Enumeration Value", size);
        Enumeration en = ht.elements();
        for (int i = 0; i < size; ++i) {
            if (en.nextElement() == MISSING) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
    }

    static void entest(Map s, int size) {
        if (s instanceof Hashtable) {
            Hashtable ht = (Hashtable)s;
            MapCheck.entest1(ht, size);
            MapCheck.entest2(ht, size);
            MapCheck.entest1(ht, size);
            MapCheck.entest2(ht, size);
            MapCheck.entest1(ht, size);
            MapCheck.entest2(ht, size);
        }
    }

    static void rtest(Map s, int size) {
        timer.start("Remove (iterator)      ", size);
        Iterator it = s.keySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        timer.finish();
    }

    static void rvtest(Map s, int size) {
        timer.start("Remove (iterator)      ", size);
        Iterator it = s.values().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        timer.finish();
    }

    static void dtest(Map s, int size, Object[] key) {
        timer.start("Put (putAll)           ", size * 2);
        Map s2 = null;
        try {
            s2 = (Map)s.getClass().newInstance();
            s2.putAll(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        timer.finish();
        timer.start("Iter Equals            ", size * 2);
        boolean eqt = ((Object)s2).equals(s) && ((Object)s).equals(s2);
        MapCheck.reallyAssert(eqt);
        timer.finish();
        timer.start("Iter HashCode          ", size * 2);
        int shc = ((Object)s).hashCode();
        int s2hc = ((Object)s2).hashCode();
        MapCheck.reallyAssert(shc == s2hc);
        timer.finish();
        timer.start("Put (present)          ", size);
        s2.putAll(s);
        timer.finish();
        timer.start("Iter EntrySet contains ", size * 2);
        Set es2 = s2.entrySet();
        int sum = 0;
        Iterator i1 = s.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry entry = i1.next();
            if (!es2.contains(entry)) continue;
            ++sum;
        }
        timer.finish();
        MapCheck.reallyAssert(sum == size);
        MapCheck.t6("Get                    ", size, s2, key, absent);
        Object hold = s2.get(key[size - 1]);
        s2.put(key[size - 1], absent[0]);
        timer.start("Iter Equals            ", size * 2);
        eqt = ((Object)s2).equals(s) && ((Object)s).equals(s2);
        MapCheck.reallyAssert(!eqt);
        timer.finish();
        timer.start("Iter HashCode          ", size * 2);
        int s1h = ((Object)s).hashCode();
        int s2h = ((Object)s2).hashCode();
        MapCheck.reallyAssert(s1h != s2h);
        timer.finish();
        s2.put(key[size - 1], hold);
        timer.start("Remove (iterator)      ", size * 2);
        Iterator s2i = s2.entrySet().iterator();
        Set es = s.entrySet();
        while (s2i.hasNext()) {
            es.remove(s2i.next());
        }
        timer.finish();
        MapCheck.reallyAssert(s.isEmpty());
        timer.start("Clear                  ", size);
        s2.clear();
        timer.finish();
        MapCheck.reallyAssert(s2.isEmpty() && s.isEmpty());
    }

    static void stest(Map s, int size) throws Exception {
        if (!(s instanceof Serializable)) {
            return;
        }
        System.out.print("Serialize              : ");
        for (int i = 0; i < size; ++i) {
            s.put(new Integer(i), Boolean.TRUE);
        }
        long startTime = System.currentTimeMillis();
        FileOutputStream fs = new FileOutputStream("MapCheck.dat");
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(fs));
        out.writeObject(s);
        out.close();
        FileInputStream is = new FileInputStream("MapCheck.dat");
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(is));
        Map m = (Map)in.readObject();
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        System.out.print(time + "ms");
        if (s instanceof IdentityHashMap) {
            return;
        }
        MapCheck.reallyAssert(((Object)s).equals(m));
    }

    static void test(Map s, Object[] key) {
        int size = key.length;
        MapCheck.t3("Put (absent)           ", size, s, key, size);
        MapCheck.t3("Put (present)          ", size, s, key, 0);
        MapCheck.t7("ContainsKey            ", size, s, key, absent);
        MapCheck.t4("ContainsKey            ", size, s, key, size);
        MapCheck.ktest(s, size, key);
        MapCheck.t4("ContainsKey            ", 131072, s, absent, 0);
        MapCheck.t6("Get                    ", size, s, key, absent);
        MapCheck.t1("Get (present)          ", size, s, key, size);
        MapCheck.t1("Get (absent)           ", 131072, s, absent, 0);
        MapCheck.t2("Remove (absent)        ", 131072, s, absent, 0);
        MapCheck.t5("Remove (present)       ", size, s, key, size / 2);
        MapCheck.t3("Put (half present)     ", size, s, key, size / 2);
        MapCheck.ittest(s, size);
        MapCheck.entest(s, size);
        MapCheck.t9(s);
        MapCheck.rtest(s, size);
        MapCheck.t4("ContainsKey            ", size, s, key, 0);
        MapCheck.t2("Remove (absent)        ", size, s, key, 0);
        MapCheck.t3("Put (presized)         ", size, s, key, size);
        MapCheck.dtest(s, size, key);
    }

    static void shuffle(Object[] keys) {
        int size;
        for (int i = size = keys.length; i > 1; --i) {
            int r = rng.nextInt(i);
            Object t = keys[i - 1];
            keys[i - 1] = keys[r];
            keys[r] = t;
        }
    }

    static class Stats {
        double sum = 0.0;
        double least;
        int number = 0;

        Stats(double t) {
            this.least = t;
        }
    }

    static class TestTimer {
        private String name;
        private long numOps;
        private long startTime;
        private String cname;
        static final TreeMap accum = new TreeMap();

        TestTimer() {
        }

        static void printStats() {
            Iterator it = accum.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Stats stats = (Stats)e.getValue();
                int n = stats.number;
                double t = n > 0 ? stats.sum / (double)n : stats.least;
                long nano = Math.round(1000000.0 * t);
                System.out.println(e.getKey() + ": " + nano);
            }
        }

        void start(String name, long numOps) {
            this.name = name;
            this.cname = this.classify();
            this.numOps = numOps;
            this.startTime = System.currentTimeMillis();
        }

        String classify() {
            if (this.name.startsWith("Get")) {
                return "Get                    ";
            }
            if (this.name.startsWith("Put")) {
                return "Put                    ";
            }
            if (this.name.startsWith("Remove")) {
                return "Remove                 ";
            }
            if (this.name.startsWith("Iter")) {
                return "Iter                   ";
            }
            return null;
        }

        void finish() {
            Stats stats;
            long endTime = System.currentTimeMillis();
            long time = endTime - this.startTime;
            double timePerOp = (double)time / (double)this.numOps;
            Object st = accum.get(this.name);
            if (st == null) {
                accum.put(this.name, new Stats(timePerOp));
            } else {
                stats = (Stats)st;
                stats.sum += timePerOp;
                ++stats.number;
                if (timePerOp < stats.least) {
                    stats.least = timePerOp;
                }
            }
            if (this.cname != null) {
                st = accum.get(this.cname);
                if (st == null) {
                    accum.put(this.cname, new Stats(timePerOp));
                } else {
                    stats = (Stats)st;
                    stats.sum += timePerOp;
                    ++stats.number;
                    if (timePerOp < stats.least) {
                        stats.least = timePerOp;
                    }
                }
            }
        }
    }
}

