/*
 * Decompiled with CFR 0.152.
 */
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CyclicBarrier;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import java.util.Map;
import java.util.Random;

public class MapLoops {
    static int nkeys = 10000;
    static int pinsert = 60;
    static int premove = 2;
    static int maxThreads = 100;
    static int nops = 8000000;
    static int removesPerMaxRandom;
    static int insertsPerMaxRandom;
    static final ExecutorService pool;

    public static void main(String[] args) throws Exception {
        Class mapClass = null;
        if (args.length > 0) {
            try {
                mapClass = Class.forName(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class " + args[0] + " not found.");
            }
        } else {
            Class clazz = mapClass = ConcurrentHashMap.class;
        }
        if (args.length > 1) {
            maxThreads = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            nkeys = Integer.parseInt(args[2]);
        }
        if (args.length > 3) {
            pinsert = Integer.parseInt(args[3]);
        }
        if (args.length > 4) {
            premove = Integer.parseInt(args[4]);
        }
        if (args.length > 5) {
            nops = Integer.parseInt(args[5]);
        }
        removesPerMaxRandom = (int)((double)premove / 100.0 * 2.147483647E9);
        insertsPerMaxRandom = (int)((double)pinsert / 100.0 * 2.147483647E9);
        System.out.print("Class: " + mapClass.getName());
        System.out.print(" threads: " + maxThreads);
        System.out.print(" size: " + nkeys);
        System.out.print(" ins: " + pinsert);
        System.out.print(" rem: " + premove);
        System.out.print(" ops: " + nops);
        System.out.println();
        int k = 1;
        int warmups = 2;
        int i = 1;
        while (i <= maxThreads) {
            Thread.sleep(100L);
            MapLoops.test(i, nkeys, mapClass);
            if (warmups > 0) {
                --warmups;
                continue;
            }
            if (i == k) {
                k = i << 1;
                i += i >>> 1;
                continue;
            }
            if (i == 1 && k == 2) {
                i = k;
                warmups = 1;
                continue;
            }
            i = k;
        }
        pool.shutdown();
    }

    static Integer[] makeKeys(int n) {
        LoopHelpers.SimpleRandom rng = new LoopHelpers.SimpleRandom();
        Integer[] key = new Integer[n];
        for (int i = 0; i < key.length; ++i) {
            key[i] = new Integer(rng.next());
        }
        return key;
    }

    static void shuffleKeys(Integer[] key) {
        Random rng = new Random();
        for (int i = key.length; i > 1; --i) {
            int j = rng.nextInt(i);
            Integer tmp = key[j];
            key[j] = key[i - 1];
            key[i - 1] = tmp;
        }
    }

    static void test(int i, int nkeys, Class mapClass) throws Exception {
        System.out.print("Threads: " + i + "\t:");
        Map map = (Map)mapClass.newInstance();
        Integer[] key = MapLoops.makeKeys(nkeys);
        LoopHelpers.BarrierTimer timer = new LoopHelpers.BarrierTimer();
        CyclicBarrier barrier = new CyclicBarrier(i + 1, (Runnable)timer);
        for (int t = 0; t < i; ++t) {
            pool.execute((Runnable)new Runner(map, key, barrier));
        }
        barrier.await();
        barrier.await();
        long time = timer.getTime();
        long tpo = time / ((long)i * (long)nops);
        System.out.print(LoopHelpers.rightJustify(tpo) + " ns per op");
        double secs = (double)time / 1.0E9;
        System.out.println("\t " + secs + "s run time");
        map.clear();
    }

    static {
        pool = Executors.newCachedThreadPool();
    }

    static class Runner
    implements Runnable {
        final Map map;
        final Integer[] key;
        final LoopHelpers.SimpleRandom rng = new LoopHelpers.SimpleRandom();
        final CyclicBarrier barrier;
        int position;
        int total;

        Runner(Map map, Integer[] key, CyclicBarrier barrier) {
            this.map = map;
            this.key = key;
            this.barrier = barrier;
            this.position = key.length / 2;
        }

        int step() {
            int r = this.rng.next();
            this.position += (r & 7) - 3;
            while (this.position >= this.key.length) {
                this.position -= this.key.length;
            }
            while (this.position < 0) {
                this.position += this.key.length;
            }
            Integer k = this.key[this.position];
            Integer x = (Integer)this.map.get(k);
            if (x != null) {
                if (x.intValue() != k.intValue()) {
                    throw new Error("bad mapping: " + x + " to " + k);
                }
                if (r < removesPerMaxRandom && this.map.remove(k) != null) {
                    this.position = this.total % this.key.length;
                    return 2;
                }
            } else if (r < insertsPerMaxRandom) {
                ++this.position;
                this.map.put(k, k);
                return 2;
            }
            this.total += r;
            return 1;
        }

        public void run() {
            try {
                this.barrier.await();
                for (int ops = nops; ops > 0; ops -= this.step()) {
                }
                this.barrier.await();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

