/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class SetBash {
    static Random rnd = new Random();

    public static void main(String[] args) {
        int numItr = Integer.parseInt(args[1]);
        int setSize = Integer.parseInt(args[2]);
        Class<?> cl = null;
        try {
            cl = Class.forName(args[0]);
        }
        catch (ClassNotFoundException e) {
            SetBash.fail("Class " + args[0] + " not found.");
        }
        boolean synch = args.length > 3;
        for (int i = 0; i < numItr; ++i) {
            Set s1 = SetBash.newSet(cl, synch);
            SetBash.AddRandoms(s1, setSize);
            Set s2 = SetBash.newSet(cl, synch);
            SetBash.AddRandoms(s2, setSize);
            Set intersection = SetBash.clone(s1, cl, synch);
            intersection.retainAll(s2);
            Set diff1 = SetBash.clone(s1, cl, synch);
            diff1.removeAll(s2);
            Set diff2 = SetBash.clone(s2, cl, synch);
            diff2.removeAll(s1);
            Set union = SetBash.clone(s1, cl, synch);
            union.addAll(s2);
            if (diff1.removeAll(diff2)) {
                SetBash.fail("Set algebra identity 2 failed");
            }
            if (diff1.removeAll(intersection)) {
                SetBash.fail("Set algebra identity 3 failed");
            }
            if (diff2.removeAll(diff1)) {
                SetBash.fail("Set algebra identity 4 failed");
            }
            if (diff2.removeAll(intersection)) {
                SetBash.fail("Set algebra identity 5 failed");
            }
            if (intersection.removeAll(diff1)) {
                SetBash.fail("Set algebra identity 6 failed");
            }
            if (intersection.removeAll(diff1)) {
                SetBash.fail("Set algebra identity 7 failed");
            }
            intersection.addAll(diff1);
            intersection.addAll(diff2);
            if (!((Object)intersection).equals(union)) {
                SetBash.fail("Set algebra identity 1 failed");
            }
            Iterator e = union.iterator();
            while (e.hasNext()) {
                if (intersection.remove(e.next())) continue;
                SetBash.fail("Couldn't remove element from copy.");
            }
            if (!intersection.isEmpty()) {
                SetBash.fail("Copy nonempty after deleting all elements: " + intersection.size());
            }
            e = union.iterator();
            while (e.hasNext()) {
                Object o = e.next();
                if (!union.contains(o)) {
                    SetBash.fail("Set doesn't contain one of its elements.");
                }
                e.remove();
                if (!union.contains(o)) continue;
                SetBash.fail("Set contains element after deletion.");
            }
            if (!union.isEmpty()) {
                SetBash.fail("Set nonempty after deleting all elements.");
            }
            s1.clear();
            if (s1.isEmpty()) continue;
            SetBash.fail("Set nonempty after clear.");
        }
        System.out.println("Success.");
    }

    static Set clone(Set s, Class cl, boolean synch) {
        Set clone = SetBash.newSet(cl, synch);
        clone.addAll(Arrays.asList(s.toArray()));
        if (!((Object)s).equals(clone)) {
            SetBash.fail("Set not equal to copy.");
        }
        if (!s.containsAll(clone)) {
            SetBash.fail("Set does not contain copy.");
        }
        if (!clone.containsAll(s)) {
            SetBash.fail("Copy does not contain set.");
        }
        return clone;
    }

    static Set newSet(Class cl, boolean synch) {
        try {
            Set s = (Set)cl.newInstance();
            if (synch) {
                s = Collections.synchronizedSet(s);
            }
            if (!s.isEmpty()) {
                SetBash.fail("New instance non empty.");
            }
            return s;
        }
        catch (Throwable t) {
            SetBash.fail("Can't instantiate " + cl + ": " + t);
            return null;
        }
    }

    static void AddRandoms(Set s, int n) {
        for (int i = 0; i < n; ++i) {
            int r = rnd.nextInt() % n;
            Integer e = new Integer(r < 0 ? -r : r);
            int preSize = s.size();
            boolean prePresent = s.contains(e);
            boolean added = s.add(e);
            if (!s.contains(e)) {
                SetBash.fail("Element not present after addition.");
            }
            if (added == prePresent) {
                SetBash.fail("added == alreadyPresent");
            }
            int postSize = s.size();
            if (added && preSize == postSize) {
                SetBash.fail("Add returned true, but size didn't change.");
            }
            if (added || preSize == postSize) continue;
            SetBash.fail("Add returned false, but size changed.");
        }
    }

    static void fail(String s) {
        System.out.println(s);
        System.exit(1);
    }
}

