/*
 * Decompiled with CFR 0.152.
 */
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UtilTestCase
extends TestCase {
    volatile boolean threadFailed;
    static final int SIZE = 20;

    public static void main(String[] args) {
        int iters = 1;
        if (args.length > 0) {
            iters = Integer.parseInt(args[0]);
        }
        Test s = UtilTestCase.suite();
        for (int i = 0; i < iters; ++i) {
            TestRunner.run((Test)s);
            System.gc();
            System.runFinalization();
        }
        System.exit(0);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Emory Util Unit Tests");
        suite.addTest((Test)new TestSuite(LongIntervalSetTest.class));
        suite.addTest((Test)new TestSuite(LongIntervalSubSetTest.class));
        return suite;
    }

    public void setUp() {
        this.threadFailed = false;
    }

    public void tearDown() {
        UtilTestCase.assertFalse((boolean)this.threadFailed);
    }

    public void threadFail(String reason) {
        this.threadFailed = true;
        UtilTestCase.fail((String)reason);
    }

    public void threadAssertTrue(boolean b) {
        if (!b) {
            this.threadFailed = true;
            UtilTestCase.assertTrue((boolean)b);
        }
    }

    public void threadAssertFalse(boolean b) {
        if (b) {
            this.threadFailed = true;
            UtilTestCase.assertFalse((boolean)b);
        }
    }

    public void threadAssertNull(Object x) {
        if (x != null) {
            this.threadFailed = true;
            UtilTestCase.assertNull((Object)x);
        }
    }

    public void threadAssertEquals(long x, long y) {
        if (x != y) {
            this.threadFailed = true;
            UtilTestCase.assertEquals((long)x, (long)y);
        }
    }

    public void threadAssertEquals(Object x, Object y) {
        if (!(x == y || x != null && x.equals(y))) {
            this.threadFailed = true;
            UtilTestCase.assertEquals((Object)x, (Object)y);
        }
    }

    public void threadShouldThrow() {
        this.threadFailed = true;
        UtilTestCase.fail((String)"should throw exception");
    }

    public void threadUnexpectedException() {
        this.threadFailed = true;
        UtilTestCase.fail((String)"Unexpected exception");
    }

    public void shouldThrow() {
        UtilTestCase.fail((String)"Should throw exception");
    }

    public void unexpectedException() {
        UtilTestCase.fail((String)"Unexpected exception");
    }

    static class AdjustablePolicy
    extends Policy {
        Permissions perms = new Permissions();

        AdjustablePolicy() {
        }

        void addPermission(Permission perm) {
            this.perms.add(perm);
        }

        void clearPermissions() {
            this.perms = new Permissions();
        }

        public PermissionCollection getPermissions(CodeSource cs) {
            return this.perms;
        }

        public PermissionCollection getPermissions(ProtectionDomain pd) {
            return this.perms;
        }

        public boolean implies(ProtectionDomain pd, Permission p) {
            return this.perms.implies(p);
        }

        public void refresh() {
        }
    }
}

