/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util;

import edu.emory.mathcs.util.ExpansionException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PropertyUtils {
    private static final String MACRO_PATTERN = "\\$([a-zA-Z_0-9\\.]*)\\{([^\\{\\}]*)\\}";
    public static final Macro MACRO_SYSTEM_PROPERTY = new PropertyExpansionMacro();
    public static final Macro MACRO_FILE_TO_URL = new Macro(){

        public String process(String input) {
            return new File(input).toURI().toString();
        }
    };
    public static final Macro MACRO_URL_TO_FILE = new Macro(){

        public String process(String input) throws ExpansionException {
            try {
                return new File(new URI(input)).getPath();
            }
            catch (URISyntaxException e) {
                throw new ExpansionException("Ill-formed URI", e);
            }
            catch (IllegalArgumentException e) {
                throw new ExpansionException("Not a local file URI", e);
            }
        }
    };
    public static final Macro MACRO_ABSFILE = new Macro(){

        public String process(String input) {
            return new File(input).getAbsolutePath();
        }
    };
    public static final Macro MACRO_TRIM = new Macro(){

        public String process(String input) {
            return input.trim();
        }
    };
    public static final Macro MACRO_UPPERCASE = new Macro(){

        public String process(String input) {
            return input.toUpperCase();
        }
    };
    public static final Macro MACRO_LOWERCASE = new Macro(){

        public String process(String input) {
            return input.toLowerCase();
        }
    };
    public static final Macro MACRO_LIBNAME = new Macro(){

        public String process(String input) {
            return System.mapLibraryName(input);
        }
    };
    public static final Macro MACRO_EXECUTABLE = new Macro(){

        public String process(String input) {
            String osname = System.getProperty("os.name").toLowerCase();
            if (osname.startsWith("windows")) {
                input = input + ".exe";
            }
            return input;
        }
    };
    private static final Map defaultMacros = new HashMap();
    private static Pattern macroPattern;

    public static Map getDefaultMacros() {
        return Collections.unmodifiableMap(defaultMacros);
    }

    private static synchronized Pattern getMacroExpansionPattern() {
        if (macroPattern == null) {
            macroPattern = Pattern.compile(MACRO_PATTERN);
        }
        return macroPattern;
    }

    public static final String enumerate(Properties p) {
        StringBuffer sb = new StringBuffer(1024);
        Iterator<Object> i = p.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            sb.append(key);
            sb.append('=');
            sb.append(p.getProperty(key));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final Properties getPropertiesFromString(String propertiesString) {
        Properties p = new Properties();
        StringTokenizer st = new StringTokenizer(propertiesString, ";");
        while (st.hasMoreTokens()) {
            String nameValuePair = st.nextToken();
            int eqPos = nameValuePair.indexOf(61);
            if (eqPos == -1) continue;
            String name = nameValuePair.substring(0, eqPos);
            String value = nameValuePair.substring(eqPos + 1);
            p.put(name, value);
        }
        return p;
    }

    public static final Properties getPropertiesFromStream(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(new BufferedInputStream(is));
        return p;
    }

    public static Set getKeysStartingWith(Properties props, String prefix) {
        HashSet<Object> keys = new HashSet<Object>(props.keySet());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.startsWith(prefix)) continue;
            i.remove();
        }
        return keys;
    }

    public static String escapeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported");
        }
    }

    public static String unescapeString(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported");
        }
    }

    public static final String expand(String value) throws ExpansionException {
        return PropertyUtils.expand(value, PropertyUtils.getDefaultMacros());
    }

    public static final String expand(String value, Map macros) throws ExpansionException {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(value.length() * 4);
        sb.append(value);
        try {
            int occurrences;
            Pattern macroPattern = PropertyUtils.getMacroExpansionPattern();
            do {
                Matcher m = macroPattern.matcher(sb.toString());
                sb.setLength(0);
                occurrences = 0;
                while (m.find()) {
                    ++occurrences;
                    String macroName = m.group(1);
                    String input = m.group(2);
                    Macro macro = (Macro)macros.get(macroName);
                    if (macro == null) {
                        throw new ExpansionException("Undefined macro: \"" + macroName + "\"");
                    }
                    String replacement = macro.process(input);
                    if (replacement == null) {
                        replacement = "";
                    }
                    m.appendReplacement(sb, PropertyUtils.escapeReplacement(replacement));
                }
                m.appendTail(sb);
            } while (occurrences > 0);
        }
        catch (PatternSyntaxException pse) {
            throw new RuntimeException(pse);
        }
        return sb.toString();
    }

    private static String escapeReplacement(String replacement) {
        StringBuffer buf = new StringBuffer(replacement.length() + 10);
        int len = replacement.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = replacement.charAt(i);
            switch (ch) {
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                case '$': {
                    buf.append("\\$");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static String getProperty(Properties props, String name, String defVal) {
        return props.getProperty(name, defVal);
    }

    public static void setProperty(Properties props, String name, String val) {
        props.setProperty(name, val);
    }

    public static void setOrRemoveProperty(Properties props, String name, String val) {
        if (val != null) {
            props.setProperty(name, val);
        } else {
            props.remove(name);
        }
    }

    public static Boolean getBooleanProperty(Properties props, String name) {
        String val = props.getProperty(name);
        if (val == null) {
            return null;
        }
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("1");
    }

    public static boolean getBooleanProperty(Properties props, String name, boolean defVal) {
        String val = props.getProperty(name, defVal ? "true" : "false");
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("1");
    }

    public static void setBooleanProperty(Properties props, String name, boolean val) {
        props.setProperty(name, val ? "true" : "false");
    }

    public static Integer getIntegerProperty(Properties props, String name) {
        String val = props.getProperty(name);
        if (val == null) {
            return null;
        }
        return Integer.valueOf(val);
    }

    public static int getIntegerProperty(Properties props, String name, int defVal) {
        String val = props.getProperty(name);
        if (val == null) {
            return defVal;
        }
        return Integer.parseInt(val);
    }

    public static void setIntegerProperty(Properties props, String name, int val) {
        props.setProperty(name, String.valueOf(val));
    }

    public static final String uris2string(URI[] classpath) {
        StringBuffer buf = new StringBuffer(classpath.length * 30);
        for (int i = 0; i < classpath.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(classpath[i].toString());
        }
        return buf.toString();
    }

    public static final URI[] string2uris(String classpath) throws URISyntaxException {
        String[] split = classpath.split("\\s");
        URI[] uris = new URI[split.length];
        for (int i = 0; i < split.length; ++i) {
            uris[i] = new URI(split[i]);
        }
        return uris;
    }

    static {
        defaultMacros.put("", MACRO_SYSTEM_PROPERTY);
        defaultMacros.put("fileurl", MACRO_FILE_TO_URL);
        defaultMacros.put("url2file", MACRO_URL_TO_FILE);
        defaultMacros.put("absfile", MACRO_ABSFILE);
        defaultMacros.put("trim", MACRO_TRIM);
        defaultMacros.put("uppercase", MACRO_UPPERCASE);
        defaultMacros.put("lowercase", MACRO_LOWERCASE);
        defaultMacros.put("libname", MACRO_LIBNAME);
        defaultMacros.put("executable", MACRO_EXECUTABLE);
        macroPattern = null;
    }

    public static final class PropertyExpansionMacro
    implements Macro {
        final Properties props;

        public PropertyExpansionMacro() {
            this(null);
        }

        public PropertyExpansionMacro(Properties props) {
            this.props = props;
        }

        public String process(String input) {
            String defVal;
            int i;
            if (this.props == null) {
                if ("/".equals(input)) {
                    return File.separator;
                }
                if (":".equals(input)) {
                    return File.pathSeparator;
                }
            }
            String pname = (i = input.indexOf(44)) >= 0 ? input.substring(0, i) : input;
            String string = defVal = i >= 0 ? input.substring(i + 1) : null;
            if (this.props == null) {
                return System.getProperty(pname, defVal);
            }
            return this.props.getProperty(pname, defVal);
        }
    }

    public static interface Macro {
        public String process(String var1) throws ExpansionException;
    }
}

