/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader.jar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarURLConnection
extends java.net.JarURLConnection {
    final JarOpener opener;
    boolean connected;
    JarFile jfile;
    JarEntry jentry;

    public JarURLConnection(URL url, JarOpener opener) throws IOException {
        super(url);
        this.opener = opener;
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.jfile = this.opener.openJarFile(this);
        if (this.jfile != null && this.getEntryName() != null) {
            this.jentry = this.jfile.getJarEntry(this.getEntryName());
            if (this.jentry == null) {
                throw new FileNotFoundException("Entry " + this.getEntryName() + " not found in " + this.getJarFileURL());
            }
        }
        this.connected = true;
    }

    public synchronized JarFile getJarFile() throws IOException {
        this.connect();
        return this.jfile;
    }

    public synchronized JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jentry;
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        return this.jfile.getInputStream(this.jentry);
    }

    public Permission getPermission() throws IOException {
        return this.getJarFileURL().openConnection().getPermission();
    }

    public static interface JarOpener {
        public JarFile openJarFile(java.net.JarURLConnection var1) throws IOException;
    }
}

