/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections;

import edu.emory.mathcs.util.collections.RadkeHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap
extends AbstractMap {
    private static final Entry REMOVED = new Entry(null, null, null);
    transient Entry[] elements;
    transient int size;
    transient int fill;
    int treshold;
    private final ReferenceQueue rqueue = new ReferenceQueue();
    final float loadFactor;
    final float resizeTreshold;
    transient EntrySetView entrySet;
    transient KeySetView keySet;

    public WeakIdentityHashMap() {
        this(19);
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.6f);
    }

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        float resizeTreshold = 0.3f;
        initialCapacity = RadkeHashMap.radkeAtLeast(initialCapacity);
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be betweeen 0 and 1");
        }
        if (resizeTreshold <= 0.0f || resizeTreshold > 1.0f) {
            throw new IllegalArgumentException("Fill treshold must be betweeen 0 and 1");
        }
        this.elements = new Entry[initialCapacity];
        this.size = 0;
        this.fill = 0;
        this.loadFactor = loadFactor;
        this.resizeTreshold = resizeTreshold;
        this.treshold = (int)(loadFactor * (float)initialCapacity);
    }

    public WeakIdentityHashMap(Map m) {
        this(Math.max((int)((double)m.size() / 0.6) + 1, 19), 0.6f);
        this.putAll(m);
    }

    public Object put(Object key, Object val) {
        this.pruneUnreferencedEntries();
        return this.putImpl(key, val);
    }

    private Object putImpl(Object key, Object val) {
        int hsize = this.elements.length;
        int start = WeakIdentityHashMap.hash(key) % hsize;
        int refill = -1;
        Entry prev = this.elements[start];
        if (prev == null) {
            this.elements[start] = new Entry(key, val, this.rqueue);
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (prev == REMOVED || prev.getValue() == REMOVED) {
            refill = start;
        } else if (prev.getKey() == key) {
            return prev.setValue(val);
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prev = this.elements[p]) == null) {
            if (refill >= 0) {
                this.elements[refill] = new Entry(key, val, this.rqueue);
                ++this.size;
                return null;
            }
            this.elements[p] = new Entry(key, val, this.rqueue);
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (prev == REMOVED || prev.getValue() == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (prev.getKey() == key) {
            return prev.setValue(val);
        }
        if ((p = start - 1) < 0) {
            p += hsize;
        }
        if ((prev = this.elements[p]) == null) {
            if (refill >= 0) {
                this.elements[refill] = new Entry(key, val, this.rqueue);
                ++this.size;
                return null;
            }
            this.elements[p] = new Entry(key, val, this.rqueue);
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (prev == REMOVED || prev.getValue() == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (prev.getKey() == key) {
            return prev.setValue(val);
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prev = this.elements[pu]) == null) {
                if (refill >= 0) {
                    this.elements[refill] = new Entry(key, val, this.rqueue);
                    ++this.size;
                    return null;
                }
                this.elements[pu] = new Entry(key, val, this.rqueue);
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (prev == REMOVED || prev.getValue() == REMOVED) {
                if (refill < 0) {
                    refill = pu;
                }
            } else if (prev.getKey() == key) {
                return prev.setValue(val);
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prev = this.elements[pd]) == null) {
                if (refill >= 0) {
                    this.elements[refill] = new Entry(key, val, this.rqueue);
                    ++this.size;
                    return null;
                }
                this.elements[pd] = new Entry(key, val, this.rqueue);
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (prev == REMOVED || prev.getValue() == REMOVED) {
                if (refill < 0) {
                    refill = pd;
                }
            } else if (prev.getKey() == key) {
                return prev.setValue(val);
            }
            pu += j;
            pd -= j;
        }
        throw new RuntimeException("map is full");
    }

    public Object get(Object key) {
        this.pruneUnreferencedEntries();
        return this.getImpl(key);
    }

    private Object getImpl(Object key) {
        int hsize = this.elements.length;
        int start = WeakIdentityHashMap.hash(key) % hsize;
        Entry prev = this.elements[start];
        if (prev == null) {
            return null;
        }
        if (prev.getKey() == key) {
            return prev.getValue();
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return null;
        }
        if (prev.getKey() == key) {
            return prev.getValue();
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return null;
        }
        if (prev.getKey() == key) {
            return prev.getValue();
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prev = this.elements[pu]) == null) {
                return null;
            }
            if (prev.getKey() == key) {
                return prev.getValue();
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prev = this.elements[pd]) == null) {
                return null;
            }
            if (prev.getKey() == key) {
                return prev.getValue();
            }
            pu += j;
            pd -= j;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        this.pruneUnreferencedEntries();
        return this.containsKeyImpl(key);
    }

    private boolean containsKeyImpl(Object key) {
        int hsize = this.elements.length;
        int start = WeakIdentityHashMap.hash(key) % hsize;
        Entry prev = this.elements[start];
        if (prev == null) {
            return false;
        }
        if (prev.getKey() == key) {
            return true;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return false;
        }
        if (prev.getKey() == key) {
            return true;
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return false;
        }
        if (prev.getKey() == key) {
            return true;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prev = this.elements[pu]) == null) {
                return false;
            }
            if (prev.getKey() == key) {
                return true;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prev = this.elements[pd]) == null) {
                return false;
            }
            if (prev.getKey() == key) {
                return true;
            }
            pu += j;
            pd -= j;
        }
        return false;
    }

    public Object remove(Object key) {
        this.pruneUnreferencedEntries();
        return this.removeImpl(key);
    }

    private Object removeImpl(Object key) {
        int p = this.find(key);
        if (p < 0) {
            return null;
        }
        Object old = this.elements[p].getValue();
        this.elements[p] = REMOVED;
        --this.size;
        return old;
    }

    private boolean removeMapping(Object key, Object value) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        Object val = this.elements[p].getValue();
        if (!WeakIdentityHashMap.eq(value, val)) {
            return false;
        }
        this.elements[p] = REMOVED;
        --this.size;
        return true;
    }

    private int find(Object key) {
        int hsize = this.elements.length;
        int start = WeakIdentityHashMap.hash(key) % hsize;
        Entry prev = this.elements[start];
        if (prev == null) {
            return -1;
        }
        if (prev.getKey() == key) {
            return start;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return -1;
        }
        if (prev.getKey() == key) {
            return p;
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return -1;
        }
        if (prev.getKey() == key) {
            return p;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prev = this.elements[pu]) == null) {
                return -1;
            }
            if (prev.getKey() == key) {
                return pu;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prev = this.elements[pd]) == null) {
                return -1;
            }
            if (prev.getKey() == key) {
                return pd;
            }
            pu += j;
            pd -= j;
        }
        return -1;
    }

    private void rehash() {
        if ((float)this.size >= (float)this.fill * this.resizeTreshold) {
            this.rehash(RadkeHashMap.radkeAtLeast(this.elements.length + 1));
        } else {
            this.rehash(this.elements.length);
        }
    }

    private void rehash(int newcapacity) {
        Entry[] oldelements = this.elements;
        this.elements = new Entry[newcapacity];
        this.size = 0;
        this.fill = 0;
        this.treshold = (int)(this.loadFactor * (float)newcapacity);
        for (int i = 0; i < oldelements.length; ++i) {
            Entry old = oldelements[i];
            if (oldelements[i] == null || oldelements[i] == REMOVED) continue;
            Object key = old.getKey();
            if (old == null) continue;
            this.putImpl(key, old.getValue());
        }
    }

    public void clear() {
        Arrays.fill(this.elements, null);
        this.size = 0;
        this.fill = 0;
    }

    public boolean isEmpty() {
        if (this.size == 0) {
            return true;
        }
        this.pruneUnreferencedEntries();
        return this.size == 0;
    }

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.pruneUnreferencedEntries();
        return this.size;
    }

    public void putAll(Map m) {
        this.pruneUnreferencedEntries();
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            this.putImpl(e.getKey(), e.getValue());
        }
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySetView();
        }
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySetView();
        }
        return this.keySet;
    }

    public Object clone() {
        WeakIdentityHashMap result;
        this.pruneUnreferencedEntries();
        try {
            result = (WeakIdentityHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result.elements = new Entry[this.elements.length];
        result.fill = 0;
        result.size = 0;
        result.putAll((Map)this);
        return result;
    }

    private void pruneUnreferencedEntries() {
        Entry e;
        while ((e = (Entry)this.rqueue.poll()) != null) {
            e.setValue(REMOVED);
            --this.size;
        }
    }

    private static int hash(Object o) {
        return System.identityHashCode(o) & Integer.MAX_VALUE;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private class KeySetView
    extends AbstractSet {
        private KeySetView() {
        }

        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        public boolean isEmpty() {
            return WeakIdentityHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return WeakIdentityHashMap.this.removeImpl(o) != null;
        }

        public Iterator iterator() {
            WeakIdentityHashMap.this.pruneUnreferencedEntries();
            return new HashEntrySetIterator(){

                public Object next() {
                    return ((Entry)super.next()).getKey();
                }
            };
        }
    }

    private class EntrySetView
    extends AbstractSet {
        private EntrySetView() {
        }

        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        public boolean isEmpty() {
            return WeakIdentityHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            WeakIdentityHashMap.this.pruneUnreferencedEntries();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object val = WeakIdentityHashMap.this.getImpl(key);
            return val != null ? val.equals(e.getValue()) : e.getValue() == null && WeakIdentityHashMap.this.containsKeyImpl(key);
        }

        public boolean remove(Object o) {
            WeakIdentityHashMap.this.pruneUnreferencedEntries();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakIdentityHashMap.this.removeMapping(e.getKey(), e.getValue());
        }

        public boolean addAll(Collection c) {
            WeakIdentityHashMap.this.pruneUnreferencedEntries();
            int size = WeakIdentityHashMap.this.size;
            HashEntrySetIterator itr = new HashEntrySetIterator();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                WeakIdentityHashMap.this.putImpl(e.getKey(), e.getValue());
            }
            return size != WeakIdentityHashMap.this.size;
        }

        public Iterator iterator() {
            WeakIdentityHashMap.this.pruneUnreferencedEntries();
            return new HashEntrySetIterator();
        }
    }

    private class HashEntrySetIterator
    implements Iterator {
        int curr = -1;
        int next = 0;
        Object nextKey;

        HashEntrySetIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next < WeakIdentityHashMap.this.elements.length;
        }

        public Object next() {
            if (this.next >= WeakIdentityHashMap.this.elements.length) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.findNext();
            return WeakIdentityHashMap.this.elements[this.curr];
        }

        private void findNext() {
            while (this.next < WeakIdentityHashMap.this.elements.length && (WeakIdentityHashMap.this.elements[this.next] == null || (this.nextKey = WeakIdentityHashMap.this.elements[this.next].getKey()) == null)) {
                ++this.next;
            }
        }

        public void remove() {
            if (this.curr >= 0 && WeakIdentityHashMap.this.elements[this.curr] != REMOVED) {
                WeakIdentityHashMap.this.elements[this.curr] = REMOVED;
                --WeakIdentityHashMap.this.size;
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private static class Entry
    extends WeakReference
    implements Map.Entry {
        Object val;

        Entry(Object key, Object val, ReferenceQueue queue) {
            super(key, queue);
            this.val = val;
        }

        public Object getKey() {
            return this.get();
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object newVal) {
            Object oldVal = this.val;
            this.val = newVal;
            return oldVal;
        }

        public int hashCode() {
            Object key = this.getKey();
            return (key != null ? System.identityHashCode(key) : 0) ^ (this.val != null ? this.val.hashCode() : 0);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)other;
            Object key = this.getKey();
            if (key == null) {
                return false;
            }
            return this.getKey().equals(that.getKey()) && WeakIdentityHashMap.eq(this.getValue(), that.getValue());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

