/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class WeakValueMap
extends AbstractMap
implements Map {
    private final Map map;
    transient Set entrySet;
    private final ReferenceQueue rqueue = new ReferenceQueue();

    public WeakValueMap() {
        this(new HashMap());
    }

    public WeakValueMap(Map map) {
        if (!map.isEmpty()) {
            throw new IllegalStateException("Backing map is not empty");
        }
        this.map = map;
    }

    public int size() {
        if (this.map.isEmpty()) {
            return 0;
        }
        this.prune();
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        if (this.map.isEmpty()) {
            return true;
        }
        this.prune();
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        if (this.map.isEmpty()) {
            return false;
        }
        this.prune();
        return value == null ? false : this.map.containsValue(new CompareRef(value));
    }

    public void putAll(Map t) {
        if (!this.map.isEmpty()) {
            this.prune();
        }
        Iterator itr = t.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            Object key = e.getKey();
            this.map.put(key, WeakValueMap.wrapValue(key, e.getValue(), this.rqueue));
        }
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySetView();
        }
        return this.entrySet;
    }

    public Object get(Object key) {
        if (this.map.isEmpty()) {
            return null;
        }
        this.prune();
        return WeakValueMap.unwrapValue(this.map.get(key));
    }

    public Object remove(Object key) {
        if (this.map.isEmpty()) {
            return null;
        }
        this.prune();
        return WeakValueMap.detachValue(this.map.remove(key));
    }

    public Object put(Object key, Object value) {
        ValueRef ref = WeakValueMap.wrapValue(key, value, this.rqueue);
        if (this.map.isEmpty()) {
            this.map.put(key, ref);
            return null;
        }
        this.prune();
        return WeakValueMap.detachValue(this.map.put(key, WeakValueMap.wrapValue(key, value, this.rqueue)));
    }

    private void prune() {
        ValueRef ref;
        while ((ref = (ValueRef)this.rqueue.poll()) != null) {
            Object key = ref.getKey();
            if (this.map.get(key) != ref) continue;
            this.map.remove(key);
        }
    }

    private static boolean eqNonNull(Object o1, Object o2) {
        return o1 == null ? false : o1.equals(o2);
    }

    private static ValueRef wrapValue(Object key, Object value, ReferenceQueue rqueue) {
        return new ValueRef(key, value, rqueue);
    }

    private static Object unwrapValue(Object value) {
        return value == null ? null : ((ValueRef)value).getValue();
    }

    private static Object detachValue(Object value) {
        if (value == null) {
            return null;
        }
        ValueRef ref = (ValueRef)value;
        Object val = ref.getValue();
        ref.clear();
        return val;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private class EntryWrapper
    implements Map.Entry {
        final Map.Entry entry;
        Object val;

        EntryWrapper(Map.Entry entry, Object val) {
            this.entry = entry;
            this.val = val;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object val) {
            Object old = this.val;
            this.entry.setValue(WeakValueMap.wrapValue(this.entry.getKey(), val, WeakValueMap.this.rqueue));
            this.val = val;
            return old;
        }

        void clear() {
            ValueRef val = (ValueRef)this.entry.getValue();
            val.clear();
            val.enqueue();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakValueMap.eq(this.entry.getKey(), e.getKey()) && this.val.equals(e.getValue());
        }

        public int hashCode() {
            Object key = this.entry.getKey();
            return (key == null ? 0 : key.hashCode()) ^ this.val.hashCode();
        }

        public String toString() {
            return this.entry.getKey() + "=" + this.val;
        }
    }

    private class EntryIterator
    implements Iterator {
        final Iterator itr;
        EntryWrapper cursor;
        EntryWrapper lastRet;

        EntryIterator(Iterator itr) {
            this.itr = itr;
            this.cursor = this.fetchNext();
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.fetchNext();
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.lastRet.clear();
            this.lastRet = null;
        }

        private EntryWrapper fetchNext() {
            while (this.itr.hasNext()) {
                Map.Entry e = (Map.Entry)this.itr.next();
                Object val = WeakValueMap.unwrapValue(e.getValue());
                if (val == null) continue;
                return new EntryWrapper(e, val);
            }
            return null;
        }
    }

    private class EntrySetView
    extends AbstractSet {
        EntrySetView() {
        }

        public int size() {
            if (WeakValueMap.this.map.isEmpty()) {
                return 0;
            }
            WeakValueMap.this.prune();
            return WeakValueMap.this.map.size();
        }

        public void clear() {
            WeakValueMap.this.map.clear();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object val = e.getValue();
            if (val == null) {
                return false;
            }
            return WeakValueMap.eqNonNull(WeakValueMap.unwrapValue(WeakValueMap.this.map.get(e.getKey())), val);
        }

        public boolean isEmpty() {
            if (WeakValueMap.this.map.isEmpty()) {
                return true;
            }
            WeakValueMap.this.prune();
            return WeakValueMap.this.map.isEmpty();
        }

        public boolean remove(Object o) {
            if (WeakValueMap.this.map.isEmpty()) {
                return false;
            }
            WeakValueMap.this.prune();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object val = e.getValue();
            if (val == null) {
                return false;
            }
            ValueRef ref = (ValueRef)WeakValueMap.this.map.get(key);
            if (ref == null || !val.equals(ref.getValue())) {
                return false;
            }
            WeakValueMap.this.map.remove(key);
            return true;
        }

        public Iterator iterator() {
            return new EntryIterator(WeakValueMap.this.map.entrySet().iterator());
        }
    }

    private static class CompareRef {
        final Object val;

        CompareRef(Object val) {
            this.val = val;
        }

        public Object getValue() {
            return this.val;
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ValueRef) {
                return WeakValueMap.eqNonNull(this.getValue(), ((ValueRef)other).getValue());
            }
            return false;
        }
    }

    private static class ValueRef
    extends WeakReference {
        final Object key;

        ValueRef(Object key, Object val, ReferenceQueue rqueue) {
            super(val, rqueue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.get();
        }

        public int hashCode() {
            Object val = this.getValue();
            return val == null ? 0 : val.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ValueRef) {
                return WeakValueMap.eqNonNull(this.getValue(), ((ValueRef)other).getValue());
            }
            if (other instanceof CompareRef) {
                return WeakValueMap.eqNonNull(this.getValue(), ((CompareRef)other).getValue());
            }
            return false;
        }
    }
}

