/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.ints.AbstractIntInterval;
import edu.emory.mathcs.util.collections.ints.AbstractIntSortedSet;
import edu.emory.mathcs.util.collections.ints.IntCollection;
import edu.emory.mathcs.util.collections.ints.IntCollections;
import edu.emory.mathcs.util.collections.ints.IntInterval;
import edu.emory.mathcs.util.collections.ints.IntIterator;
import edu.emory.mathcs.util.collections.ints.IntSet;
import edu.emory.mathcs.util.collections.ints.IntSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntIntervalSet
extends AbstractIntSortedSet
implements Serializable {
    transient Entry root;
    transient int size;
    transient int intervalCount;
    transient int modCount;
    final int min;
    final int max;

    public IntIntervalSet() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntIntervalSet(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntIntervalSet(IntCollection c) {
        this();
        this.addAll(c);
    }

    public IntIntervalSet(IntSet c) {
        this(c.min(), c.max());
        this.addAll(c);
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int intervalCount() {
        return this.intervalCount;
    }

    public int size64() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.root = null;
        this.intervalCount = 0;
        this.size = 0;
    }

    public boolean add(int n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Entry e = this.getInsertionPoint(n);
        if (e == null) {
            this.insertRight(new Entry(n, n), this.getLastEntry());
            ++this.size;
            return true;
        }
        if (n < e.first - 1) {
            this.insertLeft(new Entry(n, n), e);
            ++this.size;
            return true;
        }
        if (n == e.first - 1) {
            e.first--;
            ++this.size;
            return true;
        }
        if (n <= e.last) {
            return false;
        }
        Entry next = IntIntervalSet.successor(e);
        if (next != null && n == next.first - 1) {
            e.last = next.last;
            this.delete(next);
            ++this.size;
            return true;
        }
        e.last++;
        ++this.size;
        return true;
    }

    public boolean addInterval(int first, int last) {
        Entry e;
        if (first > last) {
            return false;
        }
        if (first == last) {
            return this.add(first);
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        if ((e = this.getInsertionPoint(first)) == null) {
            this.insertRight(new Entry(first, last), this.getLastEntry());
            this.size += last - first + 1;
            return true;
        }
        if (last < e.first - 1) {
            this.insertLeft(new Entry(first, last), e);
            this.size += last - first + 1;
            return true;
        }
        if (last <= e.last) {
            if (first >= e.first) {
                return false;
            }
            this.size += e.first - first;
            e.first = first;
            return true;
        }
        Entry base = e;
        if (first < base.first) {
            this.size += base.first - first;
            base.first = first;
        }
        e = IntIntervalSet.successor(e);
        while (e != null) {
            if (last < e.first - 1) {
                this.size += last - base.last;
                base.last = last;
                return true;
            }
            this.size -= e.last - e.first + 1;
            if (last <= e.last) {
                this.size += e.last - base.last;
                base.last = e.last;
                this.delete(e);
                return true;
            }
            e = this.deleteAndAdvance(e);
        }
        this.size += last - base.last;
        base.last = last;
        return true;
    }

    public boolean addAll(IntCollection c) {
        if (c == this) {
            return false;
        }
        if (c instanceof SubView) {
            SubView s = (SubView)c;
            if (s.base == this) {
                return false;
            }
        } else if (c instanceof ComplementSubView) {
            ComplementSubView s = (ComplementSubView)c;
            if (s.base == this) {
                return this.addInterval(s.min(), s.max());
            }
        }
        return super.addAll(c);
    }

    public boolean remove(int n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Entry e = this.getEntry(n);
        if (e == null) {
            return false;
        }
        if (e.first == e.last) {
            this.delete(e);
        } else if (n == e.first) {
            e.first++;
        } else if (n == e.last) {
            e.last--;
        } else {
            int last = e.last;
            e.last = n - 1;
            this.insertRight(new Entry(n + 1, last), e);
        }
        --this.size;
        return true;
    }

    public boolean removeInterval(int first, int last) {
        if (first > last) {
            return false;
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        if (first == last) {
            return this.remove(first);
        }
        Entry e = this.getCeilingEntry(first);
        if (e == null) {
            return false;
        }
        boolean modified = false;
        if (first > e.first) {
            if (last < e.last) {
                Entry newe = new Entry(last + 1, e.last);
                e.last = first - 1;
                this.insertRight(newe, e);
                this.size -= last - first + 1;
                return true;
            }
            this.size -= first - e.last;
            e.last = first - 1;
            e = IntIntervalSet.successor(e);
            if (e == null) {
                return true;
            }
            modified = true;
        }
        while (last >= e.last) {
            if ((e = this.deleteAndAdvance(e)) == null) {
                return true;
            }
            modified = true;
        }
        if (last >= e.first) {
            this.size -= last - e.first + 1;
            e.first = last + 1;
            return true;
        }
        return modified;
    }

    public boolean removeAll(IntCollection c) {
        if (c == this) {
            boolean modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        if (c instanceof SubView) {
            SubView s = (SubView)c;
            if (s.base == this) {
                return this.removeInterval(s.min(), s.max());
            }
        } else if (c instanceof ComplementSubView) {
            ComplementSubView s = (ComplementSubView)c;
            if (s.base == this) {
                return false;
            }
        }
        return super.removeAll(c);
    }

    public boolean contains(int n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        return this.getEntry(n) != null;
    }

    public boolean containsInterval(int first, int last) {
        if (first > last) {
            return true;
        }
        if (first == last) {
            return this.contains(first);
        }
        if (first < this.min || last > this.max) {
            return false;
        }
        Entry e = this.getEntry(first);
        return e != null && e.last >= last;
    }

    public IntInterval enclosingInterval(int e) {
        if (e < this.min || e > this.max) {
            return null;
        }
        return this.getEntry(e);
    }

    public int lower(int n) {
        if (n == this.min) {
            throw new NoSuchElementException();
        }
        return this.floor(n - 1);
    }

    public int floor(int n) {
        if (n < this.min) {
            throw new NoSuchElementException();
        }
        Entry e = this.getFloorEntry(n);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return n <= e.last ? n : e.last;
    }

    public int higher(int n) {
        if (n == this.max) {
            throw new NoSuchElementException();
        }
        return this.ceiling(n + 1);
    }

    public int ceiling(int n) {
        if (n > this.max) {
            throw new NoSuchElementException();
        }
        Entry e = this.getCeilingEntry(n);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return n >= e.first ? n : e.first;
    }

    public Iterator intervalIterator() {
        return new ForwardIntervalIterator(this.getFirstEntry());
    }

    public IntIterator iterator() {
        return new ForwardItemIterator();
    }

    public Iterator descendingIntervalIterator() {
        return new ReverseIntervalIterator(this.getLastEntry());
    }

    public IntIterator descendingIterator() {
        return new ReverseItemIterator();
    }

    public int first() {
        Entry r = this.getFirstEntry();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return r.first;
    }

    public int last() {
        Entry r = this.getLastEntry();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return r.last;
    }

    public int pollFirst() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        int first = e.first;
        if (e.first == e.last) {
            this.delete(e);
        } else {
            e.first++;
        }
        --this.size;
        return first;
    }

    public int pollLast() {
        Entry e = this.getLastEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        int last = e.last;
        if (e.first == e.last) {
            this.delete(e);
        } else {
            e.last--;
        }
        --this.size;
        return last;
    }

    public IntInterval firstInterval() {
        return this.getFirstEntry();
    }

    public IntInterval lastInterval() {
        return this.getLastEntry();
    }

    public IntInterval ceilingInterval(int n) {
        return this.getCeilingEntry(n);
    }

    public IntInterval floorInterval(int n) {
        return this.getFloorEntry(n);
    }

    public IntInterval higherInterval(int n) {
        return this.getHigherEntry(n);
    }

    public IntInterval lowerInterval(int n) {
        return this.getLowerEntry(n);
    }

    public IntInterval pollFirstInterval() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            return null;
        }
        int first = e.first;
        int last = e.last;
        this.delete(e);
        this.size -= last - first + 1;
        return IntCollections.interval(first, last);
    }

    public IntInterval pollLastInterval() {
        Entry e = this.getLastEntry();
        if (e == null) {
            return null;
        }
        int first = e.first;
        int last = e.last;
        this.delete(e);
        this.size -= last - first + 1;
        return IntCollections.interval(first, last);
    }

    public IntSortedSet subSet(int first, int last) {
        if (first == this.min && last == this.max) {
            return this;
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        return new SubView(this, first, last);
    }

    public IntSet complementSet() {
        return new ComplementSubView(this, this.min, this.max);
    }

    private static IntInterval fix(IntInterval r, int min, int max) {
        int first = r.first();
        int last = r.last();
        if (first >= min && last <= max) {
            return r;
        }
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        return IntCollections.interval(first, last);
    }

    private Entry getEntry(int n) {
        Entry t = this.root;
        while (true) {
            if (t == null) {
                return null;
            }
            if (n < t.first) {
                t = t.left;
                continue;
            }
            if (n <= t.last) break;
            t = t.right;
        }
        return t;
    }

    private Entry getInsertionPoint(int n) {
        return n > Integer.MIN_VALUE ? this.getCeilingEntry(n - 1) : this.getFirstEntry();
    }

    private Entry getHigherEntry(int n) {
        Entry t = this.root;
        if (t == null) {
            return null;
        }
        while (true) {
            if (n < t.first) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                return t;
            }
            if (t.right == null) break;
            t = t.right;
        }
        Entry parent = t.parent;
        while (parent != null && t == parent.right) {
            t = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry getFirstEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.left != null) {
            e = e.left;
        }
        return e;
    }

    private Entry getLastEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.right != null) {
            e = e.right;
        }
        return e;
    }

    private Entry getCeilingEntry(int n) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                if (n < e.first) {
                    if (e.left != null) {
                        e = e.left;
                        continue;
                    }
                    return e;
                }
                if (n <= e.last) break block5;
                if (e.right == null) break;
                e = e.right;
            }
            Entry p = e.parent;
            while (p != null && e == p.right) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    private Entry getLowerEntry(int n) {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (true) {
            if (n > e.last) {
                if (e.right != null) {
                    e = e.right;
                    continue;
                }
                return e;
            }
            if (e.left == null) break;
            e = e.left;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry getFloorEntry(int n) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                if (n > e.last) {
                    if (e.right != null) {
                        e = e.right;
                        continue;
                    }
                    return e;
                }
                if (n >= e.first) break block5;
                if (e.left == null) break;
                e = e.left;
            }
            Entry p = e.parent;
            while (p != null && e == p.left) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    private void insertLeft(Entry e, Entry where) {
        if (where == null) {
            this.root = e;
            this.intervalCount = 1;
            return;
        }
        if (where.left == null) {
            where.left = e;
        } else {
            where = where.left;
            while (where.right != null) {
                where = where.right;
            }
            where.right = e;
        }
        e.parent = where;
        this.fixAfterInsertion(e);
        ++this.intervalCount;
    }

    private void insertRight(Entry e, Entry where) {
        if (where == null) {
            this.root = e;
            this.intervalCount = 1;
            return;
        }
        if (where.right == null) {
            where.right = e;
        } else {
            where = where.right;
            while (where.left != null) {
                where = where.left;
            }
            where.left = e;
        }
        e.parent = where;
        this.fixAfterInsertion(e);
        ++this.intervalCount;
    }

    private static Entry successor(Entry e) {
        if (e.right != null) {
            e = e.right;
            while (e.left != null) {
                e = e.left;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.right) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private static Entry predecessor(Entry e) {
        if (e.left != null) {
            e = e.left;
            while (e.right != null) {
                e = e.right;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry deleteAndAdvance(Entry e) {
        Entry next = e.left == null || e.right == null ? IntIntervalSet.successor(e) : e;
        this.delete(e);
        return next;
    }

    private void delete(Entry e) {
        if (e.left == null && e.right == null && e.parent == null) {
            this.root = null;
            this.intervalCount = 0;
            return;
        }
        if (e.left != null && e.right != null) {
            Entry s = IntIntervalSet.successor(e);
            e.first = s.first;
            e.last = s.last;
            e = s;
        }
        if (e.left == null && e.right == null) {
            if (e.color) {
                this.fixAfterDeletion(e);
            }
            if (e.parent != null) {
                if (e == e.parent.left) {
                    e.parent.left = null;
                } else if (e == e.parent.right) {
                    e.parent.right = null;
                }
                e.parent = null;
            }
        } else {
            Entry replacement = e.left;
            if (replacement == null) {
                replacement = e.right;
            }
            replacement.parent = e.parent;
            if (e.parent == null) {
                this.root = replacement;
            } else if (e == e.parent.left) {
                e.parent.left = replacement;
            } else {
                e.parent.right = replacement;
            }
            e.left = null;
            e.right = null;
            e.parent = null;
            if (e.color) {
                this.fixAfterDeletion(replacement);
            }
        }
        --this.intervalCount;
    }

    static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private final void rotateLeft(Entry e) {
        Entry r = e.right;
        e.right = r.left;
        if (r.left != null) {
            r.left.parent = e;
        }
        r.parent = e.parent;
        if (e.parent == null) {
            this.root = r;
        } else if (e.parent.left == e) {
            e.parent.left = r;
        } else {
            e.parent.right = r;
        }
        r.left = e;
        e.parent = r;
    }

    private final void rotateRight(Entry e) {
        Entry l = e.left;
        e.left = l.right;
        if (l.right != null) {
            l.right.parent = e;
        }
        l.parent = e.parent;
        if (e.parent == null) {
            this.root = l;
        } else if (e.parent.right == e) {
            e.parent.right = l;
        } else {
            e.parent.left = l;
        }
        l.right = e;
        e.parent = l;
    }

    private final void fixAfterInsertion(Entry e) {
        e.color = false;
        Entry x = e;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (IntIntervalSet.parentOf(x) == IntIntervalSet.leftOf(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)))) {
                y = IntIntervalSet.rightOf(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)));
                if (!IntIntervalSet.colorOf(y)) {
                    IntIntervalSet.setColor(IntIntervalSet.parentOf(x), true);
                    IntIntervalSet.setColor(y, true);
                    IntIntervalSet.setColor(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)), false);
                    x = IntIntervalSet.parentOf(IntIntervalSet.parentOf(x));
                    continue;
                }
                if (x == IntIntervalSet.rightOf(IntIntervalSet.parentOf(x))) {
                    x = IntIntervalSet.parentOf(x);
                    this.rotateLeft(x);
                }
                IntIntervalSet.setColor(IntIntervalSet.parentOf(x), true);
                IntIntervalSet.setColor(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)), false);
                if (IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)) == null) continue;
                this.rotateRight(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)));
                continue;
            }
            y = IntIntervalSet.leftOf(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)));
            if (!IntIntervalSet.colorOf(y)) {
                IntIntervalSet.setColor(IntIntervalSet.parentOf(x), true);
                IntIntervalSet.setColor(y, true);
                IntIntervalSet.setColor(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)), false);
                x = IntIntervalSet.parentOf(IntIntervalSet.parentOf(x));
                continue;
            }
            if (x == IntIntervalSet.leftOf(IntIntervalSet.parentOf(x))) {
                x = IntIntervalSet.parentOf(x);
                this.rotateRight(x);
            }
            IntIntervalSet.setColor(IntIntervalSet.parentOf(x), true);
            IntIntervalSet.setColor(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)), false);
            if (IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)) == null) continue;
            this.rotateLeft(IntIntervalSet.parentOf(IntIntervalSet.parentOf(x)));
        }
        this.root.color = true;
    }

    private final Entry fixAfterDeletion(Entry e) {
        Entry x = e;
        while (x != this.root && IntIntervalSet.colorOf(x)) {
            Entry sib;
            if (x == IntIntervalSet.leftOf(IntIntervalSet.parentOf(x))) {
                sib = IntIntervalSet.rightOf(IntIntervalSet.parentOf(x));
                if (!IntIntervalSet.colorOf(sib)) {
                    IntIntervalSet.setColor(sib, true);
                    IntIntervalSet.setColor(IntIntervalSet.parentOf(x), false);
                    this.rotateLeft(IntIntervalSet.parentOf(x));
                    sib = IntIntervalSet.rightOf(IntIntervalSet.parentOf(x));
                }
                if (IntIntervalSet.colorOf(IntIntervalSet.leftOf(sib)) && IntIntervalSet.colorOf(IntIntervalSet.rightOf(sib))) {
                    IntIntervalSet.setColor(sib, false);
                    x = IntIntervalSet.parentOf(x);
                    continue;
                }
                if (IntIntervalSet.colorOf(IntIntervalSet.rightOf(sib))) {
                    IntIntervalSet.setColor(IntIntervalSet.leftOf(sib), true);
                    IntIntervalSet.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = IntIntervalSet.rightOf(IntIntervalSet.parentOf(x));
                }
                IntIntervalSet.setColor(sib, IntIntervalSet.colorOf(IntIntervalSet.parentOf(x)));
                IntIntervalSet.setColor(IntIntervalSet.parentOf(x), true);
                IntIntervalSet.setColor(IntIntervalSet.rightOf(sib), true);
                this.rotateLeft(IntIntervalSet.parentOf(x));
                x = this.root;
                continue;
            }
            sib = IntIntervalSet.leftOf(IntIntervalSet.parentOf(x));
            if (!IntIntervalSet.colorOf(sib)) {
                IntIntervalSet.setColor(sib, true);
                IntIntervalSet.setColor(IntIntervalSet.parentOf(x), false);
                this.rotateRight(IntIntervalSet.parentOf(x));
                sib = IntIntervalSet.leftOf(IntIntervalSet.parentOf(x));
            }
            if (IntIntervalSet.colorOf(IntIntervalSet.rightOf(sib)) && IntIntervalSet.colorOf(IntIntervalSet.leftOf(sib))) {
                IntIntervalSet.setColor(sib, false);
                x = IntIntervalSet.parentOf(x);
                continue;
            }
            if (IntIntervalSet.colorOf(IntIntervalSet.leftOf(sib))) {
                IntIntervalSet.setColor(IntIntervalSet.rightOf(sib), true);
                IntIntervalSet.setColor(sib, false);
                this.rotateLeft(sib);
                sib = IntIntervalSet.leftOf(IntIntervalSet.parentOf(x));
            }
            IntIntervalSet.setColor(sib, IntIntervalSet.colorOf(IntIntervalSet.parentOf(x)));
            IntIntervalSet.setColor(IntIntervalSet.parentOf(x), true);
            IntIntervalSet.setColor(IntIntervalSet.leftOf(sib), true);
            this.rotateRight(IntIntervalSet.parentOf(x));
            x = this.root;
        }
        IntIntervalSet.setColor(x, true);
        return this.root;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.intervalCount);
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            IntInterval iv = (IntInterval)itr.next();
            out.writeInt(iv.first());
            out.writeInt(iv.last());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int intervalCount = in.readInt();
        for (int i = 0; i < intervalCount; ++i) {
            int first = in.readInt();
            int last = in.readInt();
            this.addInterval(first, last);
        }
    }

    private static class ReverseComplementSubIntervalIterator
    implements Iterator {
        final IntIntervalSet base;
        final int min;
        final int max;
        IntInterval prev;
        int cursor;
        Entry next;
        IntInterval lastRet;

        ReverseComplementSubIntervalIterator(IntIntervalSet base, int min, int max) {
            this.base = base;
            this.min = min;
            this.max = max;
            Entry e = base.getCeilingEntry(max);
            if (e != null) {
                this.cursor = e.first < max ? e.first : max;
                this.next = IntIntervalSet.predecessor(e);
            } else {
                this.cursor = max;
                this.next = base.getLowerEntry(max);
            }
        }

        public boolean hasNext() {
            return this.cursor > this.min;
        }

        public Object next() {
            int first;
            int last;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = last = this.cursor < this.max ? this.cursor - 1 : this.max;
            if (this.next == null) {
                this.cursor = first = this.min;
            } else {
                first = this.next.last + 1;
                if (first < this.min) {
                    first = this.min;
                }
                this.cursor = this.next.first;
                this.next = IntIntervalSet.predecessor(this.next);
            }
            this.lastRet = IntCollections.interval(first, last);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.base.addInterval(this.lastRet.first(), this.lastRet.last());
            this.lastRet = null;
            this.next = this.base.getLowerEntry(this.cursor);
        }
    }

    private static class ForwardComplementSubIntervalIterator
    implements Iterator {
        final IntIntervalSet base;
        final int min;
        final int max;
        IntInterval prev;
        int cursor;
        Entry next;
        IntInterval lastRet;

        ForwardComplementSubIntervalIterator(IntIntervalSet base, int min, int max) {
            this.base = base;
            this.min = min;
            this.max = max;
            this.cursor = min;
            Entry e = base.getFloorEntry(min);
            if (e != null) {
                this.cursor = e.last > min ? e.last : min;
                this.next = IntIntervalSet.successor(e);
            } else {
                this.cursor = min;
                this.next = base.getHigherEntry(min);
            }
        }

        public boolean hasNext() {
            return this.cursor < this.max;
        }

        public Object next() {
            int last;
            int first;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = first = this.cursor > this.min ? this.cursor + 1 : this.min;
            if (this.next == null) {
                this.cursor = last = this.max;
            } else {
                last = this.next.first - 1;
                if (last > this.max) {
                    last = this.max;
                }
                this.cursor = this.next.last;
                this.next = IntIntervalSet.successor(this.next);
            }
            this.lastRet = IntCollections.interval(first, last);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.base.addInterval(this.lastRet.first(), this.lastRet.last());
            this.lastRet = null;
            this.next = this.base.getHigherEntry(this.cursor);
        }
    }

    private static class ReverseSubItemIterator
    extends AbstractIntSortedSet.ReverseIntervalItemIterator {
        ReverseSubItemIterator(IntIntervalSet base, int first, int last) {
            super(new ReverseSubIntervalIterator(base, first, last, base.getFloorEntry(last)));
        }

        public void remove() {
            boolean restructured;
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            ReverseSubIntervalIterator s = (ReverseSubIntervalIterator)this.it;
            if (this.currInterval != null) {
                int cfirst = this.currInterval.first();
                int clast = this.currInterval.last();
                restructured = this.lastRet < clast || cfirst == s.first || clast == s.last;
            } else {
                restructured = false;
            }
            s.base.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ReverseSubIntervalIterator(s.base, s.first, s.last, s.base.getLowerEntry(this.lastRet));
            }
        }
    }

    private static class ReverseSubIntervalIterator
    implements Iterator {
        final IntIntervalSet base;
        Entry cursor;
        int first;
        int last;
        Entry lastRet;

        ReverseSubIntervalIterator(IntIntervalSet base, int first, int last, Entry e) {
            this.base = base;
            this.first = first;
            this.last = last;
            this.cursor = e;
        }

        public boolean hasNext() {
            return this.cursor != null && this.cursor.last >= this.first;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = IntIntervalSet.predecessor(this.cursor);
            return IntIntervalSet.fix(this.lastRet, this.first, this.last);
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.first >= this.first) {
                if (this.lastRet.left != null && this.lastRet.right != null) {
                    this.cursor = this.lastRet;
                }
                this.base.delete(this.lastRet);
                this.lastRet = null;
            } else {
                this.cursor = null;
                this.base.removeInterval(this.lastRet.first, this.lastRet.last);
                this.lastRet = null;
            }
        }
    }

    private static class ForwardSubItemIterator
    extends AbstractIntSortedSet.ForwardIntervalItemIterator {
        ForwardSubItemIterator(IntIntervalSet base, int first, int last) {
            super(new ForwardSubIntervalIterator(base, first, last, base.getCeilingEntry(first)));
        }

        public void remove() {
            boolean restructured;
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            ForwardSubIntervalIterator s = (ForwardSubIntervalIterator)this.it;
            if (this.currInterval != null) {
                int cfirst = this.currInterval.first();
                int clast = this.currInterval.last();
                restructured = this.lastRet > cfirst || cfirst == s.first || clast == s.last;
            } else {
                restructured = false;
            }
            s.base.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ForwardSubIntervalIterator(s.base, s.first, s.last, s.base.getHigherEntry(this.lastRet));
            }
        }
    }

    private static class ForwardSubIntervalIterator
    implements Iterator {
        final IntIntervalSet base;
        Entry cursor;
        int first;
        int last;
        Entry lastRet;

        ForwardSubIntervalIterator(IntIntervalSet base, int first, int last, Entry e) {
            this.base = base;
            this.first = first;
            this.last = last;
            this.cursor = e;
        }

        public boolean hasNext() {
            return this.cursor != null && this.cursor.first <= this.last;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = IntIntervalSet.successor(this.cursor);
            return IntIntervalSet.fix(this.lastRet, this.first, this.last);
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.last <= this.last) {
                if (this.lastRet.left != null && this.lastRet.right != null) {
                    this.cursor = this.lastRet;
                }
                this.base.delete(this.lastRet);
                this.lastRet = null;
            } else {
                this.cursor = null;
                this.base.removeInterval(this.lastRet.first, this.lastRet.last);
                this.lastRet = null;
            }
        }
    }

    private static abstract class AbstractSubIntervalIterator
    implements Iterator {
        protected final IntIntervalSet base;
        protected final int min;
        protected final int max;
        protected IntInterval curr;
        protected IntInterval next;

        AbstractSubIntervalIterator(IntIntervalSet base, int min, int max) {
            this.base = base;
            this.min = min;
            this.max = max;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = this.fetchNext();
            return this.curr;
        }

        protected abstract IntInterval fetchNext();

        protected IntInterval fix(IntInterval r) {
            int first = r.first();
            int last = r.last();
            if (first >= this.min && last <= this.max) {
                return r;
            }
            if (first < this.min) {
                first = this.min;
            }
            if (last > this.max) {
                last = this.max;
            }
            return IntCollections.interval(first, last);
        }
    }

    static class ComplementSubView
    extends AbstractIntSortedSet.AbstractComplementSubView
    implements Serializable {
        ComplementSubView(IntIntervalSet base, int beg, int end) {
            super(base, beg, end);
        }

        public boolean addAll(IntCollection c) {
            if (c == this) {
                return false;
            }
            if (c instanceof IntIntervalSet) {
                if (c == this.base) {
                    return this.addInterval(this.beg, this.end);
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.addInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.addAll(c);
        }

        public boolean removeAll(IntCollection c) {
            if (c == this) {
                boolean modified = !this.isEmpty();
                this.clear();
                return modified;
            }
            if (c instanceof IntIntervalSet) {
                if (c == this.base) {
                    return this.removeInterval(this.min(), this.max());
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.removeInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.removeAll(c);
        }

        public Iterator intervalIterator() {
            return new ForwardComplementSubIntervalIterator((IntIntervalSet)this.base, this.beg, this.end);
        }

        public Iterator descendingIntervalIterator() {
            return new ReverseComplementSubIntervalIterator((IntIntervalSet)this.base, this.beg, this.end);
        }

        public IntSortedSet subSet(int first, int last) {
            if (first == this.beg && last == this.end) {
                return this;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return new ComplementSubView((IntIntervalSet)this.base, first, last);
        }

        public IntSet complementSet() {
            if (this.beg == Integer.MIN_VALUE && this.end == Integer.MAX_VALUE) {
                return this.base;
            }
            return this.base.subSet(this.beg, this.end);
        }
    }

    static class SubView
    extends AbstractIntSortedSet.AbstractSubView
    implements Serializable {
        SubView(IntIntervalSet base, int min, int max) {
            super(base, min, max);
        }

        public boolean addAll(IntCollection c) {
            if (c == this) {
                return false;
            }
            if (c instanceof IntIntervalSet) {
                if (c == this.base) {
                    return false;
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return false;
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return this.addInterval(s.min(), s.max());
                }
            }
            return super.addAll(c);
        }

        public boolean removeAll(IntCollection c) {
            if (c == this) {
                boolean modified = !this.isEmpty();
                this.clear();
                return modified;
            }
            if (c instanceof IntIntervalSet) {
                if (c == this.base) {
                    return this.removeInterval(this.min(), this.max());
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.removeInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.removeAll(c);
        }

        public Iterator intervalIterator() {
            IntIntervalSet lbase = (IntIntervalSet)this.base;
            return new ForwardSubIntervalIterator(lbase, this.beg, this.end, lbase.getCeilingEntry(this.beg));
        }

        public IntIterator iterator() {
            IntIntervalSet lbase = (IntIntervalSet)this.base;
            return new ForwardSubItemIterator(lbase, this.beg, this.end);
        }

        public Iterator descendingIntervalIterator() {
            IntIntervalSet lbase = (IntIntervalSet)this.base;
            return new ReverseSubIntervalIterator(lbase, this.beg, this.end, lbase.getFloorEntry(this.end));
        }

        public IntIterator descendingIterator() {
            IntIntervalSet lbase = (IntIntervalSet)this.base;
            return new ReverseSubItemIterator(lbase, this.beg, this.end);
        }

        public IntSet complementSet() {
            return new ComplementSubView((IntIntervalSet)this.base, this.beg, this.end);
        }

        public IntSortedSet subSet(int first, int last) {
            if (first == this.beg && last == this.end) {
                return this;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return this.base.subSet(first, last);
        }
    }

    private class ReverseItemIterator
    extends AbstractIntSortedSet.ReverseIntervalItemIterator {
        ReverseItemIterator() {
            super(new ReverseIntervalIterator(IntIntervalSet.this.getLastEntry()));
        }

        public void remove() {
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            boolean restructured = this.currInterval != null && this.lastRet < this.currInterval.last();
            IntIntervalSet.this.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ReverseIntervalIterator(IntIntervalSet.this.getLowerEntry(this.lastRet));
            }
        }
    }

    private class ReverseIntervalIterator
    implements Iterator {
        Entry cursor;
        Entry lastRet;

        ReverseIntervalIterator(Entry cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = IntIntervalSet.predecessor(this.cursor);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            IntIntervalSet.this.size += this.cursor.last - this.cursor.first + 1;
            if (this.lastRet.left != null && this.lastRet.right != null) {
                this.cursor = this.lastRet;
            }
            IntIntervalSet.this.delete(this.lastRet);
            this.lastRet = null;
        }
    }

    private class ForwardItemIterator
    extends AbstractIntSortedSet.ForwardIntervalItemIterator {
        ForwardItemIterator() {
            super(new ForwardIntervalIterator(IntIntervalSet.this.getFirstEntry()));
        }

        public void remove() {
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            boolean restructured = this.currInterval != null && this.lastRet > this.currInterval.first();
            IntIntervalSet.this.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ForwardIntervalIterator(IntIntervalSet.this.getHigherEntry(this.lastRet));
            }
        }
    }

    private class ForwardIntervalIterator
    implements Iterator {
        Entry cursor;
        Entry lastRet;

        ForwardIntervalIterator(Entry cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = IntIntervalSet.successor(this.cursor);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            IntIntervalSet.this.size += this.cursor.last - this.cursor.first + 1;
            if (this.lastRet.left != null && this.lastRet.right != null) {
                this.cursor = this.lastRet;
            }
            IntIntervalSet.this.delete(this.lastRet);
            this.lastRet = null;
        }
    }

    private static class Entry
    extends AbstractIntInterval {
        private static final boolean RED = false;
        private static final boolean BLACK = true;
        private int first;
        private int last;
        private Entry parent;
        private Entry left;
        private Entry right;
        private boolean color;

        Entry(int first, int last) {
            this.first = first;
            this.last = last;
        }

        protected int getFirst() {
            return this.first;
        }

        protected int getLast() {
            return this.last;
        }

        public int first() {
            return this.first;
        }

        public int last() {
            return this.last;
        }

        public int min() {
            return this.first;
        }

        public int max() {
            return this.last;
        }
    }
}

