/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.longs.AbstractLongSortedSet;
import edu.emory.mathcs.util.collections.longs.LongCollections;
import edu.emory.mathcs.util.collections.longs.LongInterval;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongSet;
import edu.emory.mathcs.util.collections.longs.LongSortedSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractLongInterval
extends AbstractLongSortedSet
implements LongInterval {
    protected abstract long getFirst();

    protected abstract long getLast();

    public long min() {
        return this.getFirst();
    }

    public long max() {
        return this.getLast();
    }

    public long first() {
        long last;
        long first = this.getFirst();
        if (first > (last = this.getLast())) {
            throw new NoSuchElementException();
        }
        return first;
    }

    public long last() {
        long last;
        long first = this.getFirst();
        if (first > (last = this.getLast())) {
            throw new NoSuchElementException();
        }
        return last;
    }

    public int intervalCount() {
        return this.isEmpty() ? 0 : 1;
    }

    public LongInterval firstInterval() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public LongInterval lastInterval() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public LongInterval lowerInterval(long n) {
        return n > this.getLast() ? this : null;
    }

    public LongInterval floorInterval(long n) {
        return n >= this.getFirst() ? this : null;
    }

    public LongInterval higherInterval(long n) {
        return n < this.getFirst() ? this : null;
    }

    public LongInterval ceilingInterval(long n) {
        return n <= this.getLast() ? this : null;
    }

    public long size64() {
        long last;
        long first = this.getFirst();
        if (first > (last = this.getLast())) {
            return 0L;
        }
        return last - first + 1L;
    }

    public boolean isEmpty() {
        return this.getFirst() > this.getLast();
    }

    public boolean contains(long e) {
        return e >= this.getFirst() && e <= this.getLast();
    }

    public long higher(long e) {
        long first = this.getFirst();
        long last = this.getLast();
        if (e >= last || first > last) {
            throw new NoSuchElementException();
        }
        if (e < first) {
            return first;
        }
        return e + 1L;
    }

    public long ceiling(long e) {
        long first = this.getFirst();
        long last = this.getLast();
        if (e > last || first > last) {
            throw new NoSuchElementException();
        }
        if (e < first) {
            return first;
        }
        return e;
    }

    public long lower(long e) {
        long first = this.getFirst();
        long last = this.getLast();
        if (e <= first || first > last) {
            throw new NoSuchElementException();
        }
        if (e > last) {
            return last;
        }
        return e - 1L;
    }

    public long floor(long e) {
        long first = this.getFirst();
        long last = this.getLast();
        if (e < first || first > last) {
            throw new NoSuchElementException();
        }
        if (e > last) {
            return last;
        }
        return e;
    }

    public boolean containsInterval(long first, long last) {
        return first >= this.getFirst() && last <= this.getLast();
    }

    public LongInterval enclosingInterval(long e) {
        if (!this.contains(e)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public LongIterator iterator() {
        return new SimpleIntervalItemIterator(this.getFirst(), this.getLast());
    }

    public LongIterator descendingIterator() {
        return new SimpleReverseIntervalItemIterator(this.getFirst(), this.getLast());
    }

    public Iterator intervalIterator() {
        return new IntervalIterator();
    }

    public Iterator descendingIntervalIterator() {
        return new IntervalIterator();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addInterval(long first, long last) {
        throw new UnsupportedOperationException();
    }

    public boolean removeInterval(long first, long last) {
        throw new UnsupportedOperationException();
    }

    public boolean retainInterval(long first, long last) {
        throw new UnsupportedOperationException();
    }

    public long pollFirst() {
        throw new UnsupportedOperationException();
    }

    public long pollLast() {
        throw new UnsupportedOperationException();
    }

    public LongInterval pollFirstInterval() {
        throw new UnsupportedOperationException();
    }

    public LongInterval pollLastInterval() {
        throw new UnsupportedOperationException();
    }

    public LongSortedSet subSet(long first, long last) {
        return new ConstrainedView(this, first, last);
    }

    public LongSet complementSet() {
        return new ComplementView(this, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public String toString() {
        long last;
        long first = this.getFirst();
        if (first > (last = this.getLast())) {
            return "_";
        }
        if (first == last) {
            return String.valueOf(first);
        }
        return "" + first + ".." + last;
    }

    private static class ComplementIterator
    implements Iterator {
        final LongInterval[] intervals = new LongInterval[2];
        final boolean forward;
        int idx;

        ComplementIterator(ComplementView c, boolean forward) {
            this.forward = forward;
            long first = c.base.getFirst();
            long last = c.base.getLast();
            long min = c.min();
            long max = c.max();
            if (min < first) {
                this.intervals[0] = LongCollections.interval(min, first - 1L);
            }
            if (max > last) {
                this.intervals[1] = LongCollections.interval(last + 1L, max);
            }
            this.idx = forward ? 0 : 1;
        }

        public boolean hasNext() {
            for (int nextIdx = this.idx; nextIdx >= 0 || nextIdx <= 2; nextIdx += this.forward ? 1 : -1) {
                if (this.intervals[nextIdx] == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.idx >= 0 && this.idx <= 1) {
                LongInterval r = this.intervals[this.idx];
                this.idx += this.forward ? 1 : -1;
                if (r == null) continue;
                return r;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ComplementView
    extends AbstractLongSortedSet {
        final AbstractLongInterval base;
        final long beg;
        final long end;

        ComplementView(AbstractLongInterval base, long beg, long end) {
            if (beg > end) {
                throw new IllegalArgumentException();
            }
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public long min() {
            long min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public long max() {
            long max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public long first() {
            long min = this.min();
            if (min < this.base.getFirst()) {
                return min;
            }
            long max = this.max();
            long last = this.base.getLast();
            if (last < max) {
                return last + 1L;
            }
            throw new NoSuchElementException();
        }

        public long last() {
            long max = this.max();
            if (max > this.base.getLast()) {
                return max;
            }
            long min = this.min();
            long first = this.base.getFirst();
            if (first > min) {
                return first - 1L;
            }
            throw new NoSuchElementException();
        }

        public boolean contains(long e) {
            return e >= this.min() && e <= this.max() && !this.base.contains(e);
        }

        public boolean containsInterval(long first, long last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.min() || last > this.max()) {
                return false;
            }
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            return last < bfirst || blast < first;
        }

        public LongInterval enclosingInterval(long e) {
            if (!this.contains(e)) {
                return null;
            }
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            if (e < bfirst) {
                return LongCollections.interval(this.min(), bfirst - 1L);
            }
            if (e > blast) {
                return LongCollections.interval(blast + 1L, this.max());
            }
            return null;
        }

        public LongInterval higherInterval(long n) {
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            long min = this.min();
            long max = this.max();
            if (bfirst > Long.MIN_VALUE && n < min && min < bfirst - 1L) {
                return LongCollections.interval(min, bfirst - 1L);
            }
            if (blast < Long.MAX_VALUE && n <= blast && blast + 1L < max) {
                return LongCollections.interval(blast + 1L, max);
            }
            return null;
        }

        public LongInterval ceilingInterval(long n) {
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            long min = this.min();
            long max = this.max();
            if (bfirst > Long.MIN_VALUE && n < bfirst && bfirst - 1L > min) {
                return LongCollections.interval(min, bfirst - 1L);
            }
            if (blast < Long.MAX_VALUE && n <= max && this.end > blast + 1L) {
                return LongCollections.interval(blast + 1L, max);
            }
            return null;
        }

        public LongInterval lowerInterval(long n) {
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            long min = this.min();
            long max = this.max();
            if (blast < Long.MAX_VALUE && n > max && max > blast + 1L) {
                return LongCollections.interval(blast + 1L, max);
            }
            if (bfirst > Long.MIN_VALUE && n >= bfirst && bfirst - 1L > min) {
                return LongCollections.interval(min, bfirst - 1L);
            }
            return null;
        }

        public LongInterval floorInterval(long n) {
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            long min = this.min();
            long max = this.max();
            if (blast < Long.MAX_VALUE && n > blast && blast + 1L < max) {
                return LongCollections.interval(blast + 1L, max);
            }
            if (bfirst > Long.MIN_VALUE && n >= min && min < bfirst - 1L) {
                return LongCollections.interval(min, bfirst - 1L);
            }
            return null;
        }

        public LongInterval firstInterval() {
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            long min = this.min();
            long max = this.max();
            if (bfirst > Long.MIN_VALUE && min < bfirst - 1L) {
                return LongCollections.interval(min, bfirst - 1L);
            }
            if (blast < Long.MAX_VALUE && blast + 1L < max) {
                return LongCollections.interval(blast + 1L, max);
            }
            return null;
        }

        public LongInterval lastInterval() {
            long bfirst = this.base.getFirst();
            long blast = this.base.getLast();
            long min = this.min();
            long max = this.max();
            if (blast < Long.MAX_VALUE && blast + 1L < max) {
                return LongCollections.interval(blast + 1L, max);
            }
            if (bfirst > Long.MIN_VALUE && min < bfirst - 1L) {
                return LongCollections.interval(min, bfirst - 1L);
            }
            return null;
        }

        public LongInterval pollFirstInterval() {
            throw new UnsupportedOperationException();
        }

        public LongInterval pollLastInterval() {
            throw new UnsupportedOperationException();
        }

        public int intervalCount() {
            int count = 0;
            if (this.min() < this.base.getFirst()) {
                ++count;
            }
            if (this.max() > this.base.getLast()) {
                ++count;
            }
            return count;
        }

        public LongSortedSet subSet(long first, long last) {
            if (first <= this.beg && last >= this.end) {
                return this;
            }
            long beg = first > this.beg ? first : this.beg;
            long end = last < this.end ? last : this.end;
            return new ComplementView(this.base, beg, end);
        }

        public LongSet complementSet() {
            if (this.beg == Long.MIN_VALUE && this.end == Long.MAX_VALUE) {
                return this.base;
            }
            return new ConstrainedView(this.base, this.beg, this.end);
        }

        public Iterator intervalIterator() {
            return new ComplementIterator(this, true);
        }

        public Iterator descendingIntervalIterator() {
            return new ComplementIterator(this, false);
        }
    }

    protected static class ConstrainedView
    extends AbstractLongInterval {
        final AbstractLongInterval base;
        final long beg;
        final long end;

        ConstrainedView(AbstractLongInterval base, long beg, long end) {
            if (beg > end) {
                throw new IllegalArgumentException();
            }
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        protected long getFirst() {
            long first = this.base.getFirst();
            return first > this.beg ? first : this.beg;
        }

        protected long getLast() {
            long last = this.base.getLast();
            return last < this.end ? last : this.end;
        }

        public long min() {
            long min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public long max() {
            long max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public LongSortedSet subSet(long first, long last) {
            if (first <= this.beg && last >= this.end) {
                return this;
            }
            long beg = first > this.beg ? first : this.beg;
            long end = last < this.end ? last : this.end;
            return new ConstrainedView(this.base, beg, end);
        }

        public LongSet complementSet() {
            return new ComplementView(this.base, this.beg, this.end);
        }
    }

    public static class SimpleReverseIntervalItemIterator
    implements LongIterator {
        final long first;
        final long last;
        long curr;
        boolean eof;

        SimpleReverseIntervalItemIterator(long first, long last) {
            this.first = first;
            this.last = last;
            this.curr = last;
            if (first > last) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            this.eof = false;
            return false;
        }

        public long next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            if (this.curr == this.first) {
                this.eof = true;
                return this.curr;
            }
            return this.curr--;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SimpleIntervalItemIterator
    implements LongIterator {
        final long first;
        final long last;
        long curr;
        boolean eof;

        SimpleIntervalItemIterator(long first, long last) {
            this.first = first;
            this.last = last;
            this.curr = first;
            if (first > last) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            this.eof = false;
            return false;
        }

        public long next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            if (this.curr == this.last) {
                this.eof = true;
                return this.curr;
            }
            return this.curr++;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class IntervalIterator
    implements Iterator {
        boolean eof;

        IntervalIterator() {
            if (AbstractLongInterval.this.getFirst() > AbstractLongInterval.this.getLast()) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            return !this.eof;
        }

        public Object next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            this.eof = true;
            return AbstractLongInterval.this;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

