/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.longs.AbstractLongCollection;
import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongList;
import edu.emory.mathcs.util.collections.longs.LongListIterator;
import java.util.NoSuchElementException;

public class LongArrayList
extends AbstractLongCollection
implements LongList {
    long[] buffer;
    int size;

    public LongArrayList() {
        this(10);
    }

    public LongArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new long[initialCapacity];
    }

    public LongArrayList(LongCollection c) {
        int cap = c.size();
        cap += cap / 10;
        if (cap < 0) {
            cap = Integer.MAX_VALUE;
        }
        this.buffer = new long[cap];
        this.addAll(c);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(long e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            return true;
        }
        return false;
    }

    public LongIterator iterator() {
        return new Itr(0);
    }

    public long[] toArray() {
        long[] a = new long[this.size];
        System.arraycopy(this.buffer, 0, a, 0, this.size);
        return a;
    }

    public long[] toArray(long[] a) {
        if (a.length < this.size) {
            a = new long[this.size];
        }
        System.arraycopy(this.buffer, 0, a, 0, this.size);
        return a;
    }

    private void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (capacity > this.buffer.length) {
            int newlen = 2 * this.buffer.length;
            if (newlen < this.buffer.length) {
                newlen = Integer.MAX_VALUE;
            }
            if (newlen < capacity) {
                newlen = capacity;
            }
            long[] newbuf = new long[newlen];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.size);
            this.buffer = newbuf;
        }
    }

    public boolean add(long e) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size++] = e;
        return true;
    }

    public boolean remove(long e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            System.arraycopy(this.buffer, i + 1, this.buffer, i, this.size - i - 1);
            --this.size;
            return true;
        }
        return false;
    }

    public boolean addAll(LongCollection c) {
        this.ensureCapacity(this.size + c.size());
        LongIterator itr = c.iterator();
        while (itr.hasNext()) {
            this.buffer[this.size++] = itr.next();
        }
        return true;
    }

    public boolean addAll(int index, LongCollection c) {
        int csize = c.size();
        this.ensureCapacity(this.size + csize);
        System.arraycopy(this.buffer, index, this.buffer, index + csize, this.size - index);
        LongIterator itr = c.iterator();
        while (itr.hasNext()) {
            this.buffer[index++] = itr.next();
        }
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongList)) {
            return false;
        }
        LongList that = (LongList)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] == that.getAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + (int)this.buffer[i];
        }
        return hashCode;
    }

    public long getAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.buffer[index];
    }

    public long setAt(int index, long e) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        long old = this.buffer[index];
        this.buffer[index] = e;
        return old;
    }

    public void addAt(int index, long e) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.size - index);
        this.buffer[index] = e;
        ++this.size;
    }

    public long removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        long e = this.buffer[index];
        System.arraycopy(this.buffer, index + 1, this.buffer, index, this.size - index - 1);
        --this.size;
        return e;
    }

    public int indexOf(long e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long e) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.buffer[i] != e) continue;
            return i;
        }
        return -1;
    }

    public LongListIterator listIterator() {
        return new Itr(0);
    }

    public LongListIterator listIterator(int index) {
        return new Itr(index);
    }

    public LongList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public long size64() {
        return this.size;
    }

    class Itr
    implements LongListIterator {
        int cursor = 0;
        int last = -1;

        Itr(int idx) {
            this.cursor = idx;
        }

        public int nextIndex() {
            return this.cursor;
        }

        public boolean hasNext() {
            return this.cursor < LongArrayList.this.size();
        }

        public long next() {
            try {
                long e = LongArrayList.this.getAt(this.cursor);
                this.last = ++this.cursor;
                return e;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public long previous() {
            try {
                long e = LongArrayList.this.getAt(this.cursor - 1);
                this.last = --this.cursor;
                return e;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void set(long e) {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            LongArrayList.this.setAt(this.last, e);
        }

        public void add(long e) {
            LongArrayList.this.addAt(this.cursor++, e);
            this.last = -1;
        }

        public void remove() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            LongArrayList.this.removeAt(this.last);
            if (this.last < this.cursor) {
                --this.cursor;
            }
            this.last = -1;
        }
    }
}

