/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.longs.AbstractLongCollection;
import edu.emory.mathcs.util.collections.longs.AbstractLongInterval;
import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongInterval;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongList;
import edu.emory.mathcs.util.collections.longs.LongListIterator;
import java.util.NoSuchElementException;

public class LongCollections {
    public static final LongInterval EMPTY_INTERVAL = new AbstractLongInterval(){

        public boolean isEmpty() {
            return true;
        }

        public long getFirst() {
            return 0L;
        }

        public long getLast() {
            return -1L;
        }

        public long min() {
            return 0L;
        }

        public long max() {
            return -1L;
        }
    };
    public static final LongList EMPTY_LIST = new LongArrAsList(new long[0]);

    private LongCollections() {
    }

    public static LongInterval interval(long first, long last) {
        return first > last ? EMPTY_INTERVAL : new SimpleInterval(first, last);
    }

    public static LongList asList(long[] arr) {
        return new LongArrAsList(arr);
    }

    private static class LongArrAsList
    extends AbstractLongCollection
    implements LongList {
        final long[] arr;

        LongArrAsList(long[] arr) {
            this.arr = arr;
        }

        public int size() {
            return this.arr.length;
        }

        public boolean isEmpty() {
            return this.arr.length == 0;
        }

        public boolean contains(long e) {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] != e) continue;
                return true;
            }
            return false;
        }

        public LongIterator iterator() {
            return this.listIterator();
        }

        public long[] toArray() {
            long[] a = new long[this.arr.length];
            System.arraycopy(this.arr, 0, a, 0, this.arr.length);
            return a;
        }

        public long[] toArray(long[] a) {
            if (a.length < this.arr.length) {
                a = new long[this.arr.length];
            }
            System.arraycopy(this.arr, 0, a, 0, this.arr.length);
            return a;
        }

        public boolean add(long e) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int idx, LongCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(long e) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongList)) {
                return false;
            }
            LongList that = (LongList)o;
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == that.getAt(i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 1;
            for (int i = 0; i < this.arr.length; ++i) {
                hashCode = 31 * hashCode + (int)this.arr[i];
            }
            return hashCode;
        }

        public long getAt(int index) {
            return this.arr[index];
        }

        public long setAt(int index, long e) {
            long old = this.arr[index];
            this.arr[index] = e;
            return old;
        }

        public void addAt(int index, long e) {
            throw new UnsupportedOperationException();
        }

        public long removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(long e) {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] != e) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(long e) {
            for (int i = this.arr.length - 1; i >= 0; --i) {
                if (this.arr[i] != e) continue;
                return i;
            }
            return -1;
        }

        public LongListIterator listIterator() {
            return new ArrAsListItr(0);
        }

        public LongListIterator listIterator(int index) {
            return new ArrAsListItr(index);
        }

        public LongList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public long size64() {
            return this.arr.length;
        }

        private class ArrAsListItr
        implements LongListIterator {
            int cursor;

            ArrAsListItr(int cursor) {
                this.cursor = cursor;
            }

            public boolean hasNext() {
                return this.cursor < LongArrAsList.this.arr.length;
            }

            public long next() {
                if (this.cursor == LongArrAsList.this.arr.length) {
                    throw new NoSuchElementException();
                }
                return LongArrAsList.this.arr[this.cursor++];
            }

            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            public long previous() {
                if (this.cursor == 0) {
                    throw new NoSuchElementException();
                }
                return LongArrAsList.this.arr[--this.cursor];
            }

            public int nextIndex() {
                return this.cursor;
            }

            public int previousIndex() {
                return this.cursor - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(long e) {
                LongArrAsList.this.arr[this.cursor] = e;
            }

            public void add(long e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class SimpleInterval
    extends AbstractLongInterval {
        final long first;
        final long last;

        public SimpleInterval(long first, long last) {
            if (first > last) {
                throw new IllegalArgumentException();
            }
            this.first = first;
            this.last = last;
        }

        public long getFirst() {
            return this.first;
        }

        public long getLast() {
            return this.last;
        }

        public long first() {
            return this.first;
        }

        public long last() {
            return this.last;
        }

        public long min() {
            return this.first;
        }

        public long max() {
            return this.last;
        }
    }
}

