/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.RadkeHashMap;
import edu.emory.mathcs.util.collections.longs.AbstractLongSet;
import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongMap;
import edu.emory.mathcs.util.collections.longs.LongSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongRadkeHashMap
implements LongMap,
Cloneable,
Serializable {
    transient long[] keys;
    transient Object[] values;
    transient int size;
    transient int fill;
    int treshold;
    final long minKey;
    final long maxKey;
    final float loadFactor;
    final float resizeTreshold;
    transient KeySet keySet;
    transient EntrySet entrySet;
    transient Values valueCollection;
    private static final Object NULL = new Object();
    private static final Object REMOVED = new Object();

    public LongRadkeHashMap() {
        this(19);
    }

    public LongRadkeHashMap(int minInitialCapacity) {
        this(minInitialCapacity, 0.75f, 0.3f);
    }

    public LongRadkeHashMap(int minInitialCapacity, long minKey, long maxKey) {
        this(minInitialCapacity, minKey, maxKey, 0.75f, 0.3f);
    }

    public LongRadkeHashMap(int minInitialCapacity, float loadFactor, float resizeTreshold) {
        this(minInitialCapacity, Long.MIN_VALUE, Long.MAX_VALUE, loadFactor, resizeTreshold);
    }

    public LongRadkeHashMap(int minInitialCapacity, long minKey, long maxKey, float loadFactor, float resizeTreshold) {
        int initialCapacity = RadkeHashMap.radkeAtLeast(minInitialCapacity);
        if (minKey > maxKey) {
            throw new IllegalArgumentException();
        }
        this.minKey = minKey;
        this.maxKey = maxKey;
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be betweeen 0 and 1");
        }
        if (resizeTreshold <= 0.0f || resizeTreshold > 1.0f) {
            throw new IllegalArgumentException("Fill treshold must be betweeen 0 and 1");
        }
        this.keys = new long[initialCapacity];
        this.values = new Object[initialCapacity];
        this.size = 0;
        this.fill = 0;
        this.loadFactor = loadFactor;
        this.resizeTreshold = resizeTreshold;
        this.treshold = (int)(loadFactor * (float)initialCapacity);
    }

    public LongRadkeHashMap(LongMap m) {
        this(Math.max((int)((double)m.size() / 0.75) + 1, 19), m.keySet().min(), m.keySet().max());
        this.putAll(m);
    }

    public Object put(long key, Object value) {
        if (key < this.minKey || key > this.maxKey) {
            return null;
        }
        int hsize = this.keys.length;
        int start = LongRadkeHashMap.phash(key) % hsize;
        int refill = -1;
        value = LongRadkeHashMap.maskNull(value);
        Object oldval = this.values[start];
        if (oldval == null) {
            this.keys[start] = key;
            this.values[start] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (oldval == REMOVED) {
            refill = start;
        } else if (this.keys[start] == key) {
            this.values[start] = value;
            return oldval;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((oldval = this.values[p]) == null) {
            if (refill >= 0) {
                this.keys[refill] = key;
                this.values[refill] = value;
                ++this.size;
                return null;
            }
            this.keys[p] = key;
            this.values[p] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (oldval == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (this.keys[p] == key) {
            this.values[p] = value;
            return oldval;
        }
        if ((p = start - 1) < 0) {
            p += hsize;
        }
        if ((oldval = this.values[p]) == null) {
            if (refill >= 0) {
                this.keys[refill] = key;
                this.values[refill] = value;
                ++this.size;
                return null;
            }
            this.keys[p] = key;
            this.values[p] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (oldval == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (this.keys[p] == key) {
            this.values[p] = value;
            return oldval;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((oldval = this.values[pu]) == null) {
                if (refill >= 0) {
                    this.keys[refill] = key;
                    this.values[refill] = value;
                    ++this.size;
                    return null;
                }
                this.keys[pu] = key;
                this.values[pu] = value;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (oldval == REMOVED) {
                if (refill < 0) {
                    refill = pu;
                }
            } else if (this.keys[pu] == key) {
                this.values[pu] = value;
                return oldval;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((oldval = this.values[pd]) == null) {
                if (refill >= 0) {
                    this.keys[refill] = key;
                    this.values[refill] = value;
                    ++this.size;
                    return null;
                }
                this.keys[pd] = key;
                this.values[pd] = value;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (oldval == REMOVED) {
                if (refill < 0) {
                    refill = pd;
                }
            } else if (this.keys[pd] == key) {
                this.values[pd] = value;
                return oldval;
            }
            pu += j;
            pd -= j;
        }
        throw new RuntimeException("hash map is full");
    }

    public Object get(long key) {
        if (key < this.minKey || key > this.maxKey) {
            return null;
        }
        int hsize = this.keys.length;
        int start = LongRadkeHashMap.phash(key) % hsize;
        Object oldval = this.values[start];
        if (oldval == null) {
            return null;
        }
        if (oldval != REMOVED && this.keys[start] == key) {
            return LongRadkeHashMap.unmaskNull(oldval);
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return null;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return LongRadkeHashMap.unmaskNull(oldval);
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return null;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return LongRadkeHashMap.unmaskNull(oldval);
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((oldval = this.values[pu]) == null) {
                return null;
            }
            if (oldval != REMOVED && this.keys[pu] == key) {
                return LongRadkeHashMap.unmaskNull(oldval);
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((oldval = this.values[pd]) == null) {
                return null;
            }
            if (oldval != REMOVED && this.keys[pd] == key) {
                return LongRadkeHashMap.unmaskNull(oldval);
            }
            pu += j;
            pd -= j;
        }
        return null;
    }

    public boolean containsKey(long key) {
        return this.find(key) >= 0;
    }

    private boolean containsMapping(long key, Object value) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        return LongRadkeHashMap.equals(value, this.values[p]);
    }

    public Object remove(long key) {
        int p = this.find(key);
        if (p < 0) {
            return null;
        }
        Object removed = this.values[p];
        this.values[p] = REMOVED;
        --this.size;
        return LongRadkeHashMap.unmaskNull(removed);
    }

    private boolean removeMapping(long key, Object value) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        Object val = LongRadkeHashMap.unmaskNull(this.values[p]);
        if (!LongRadkeHashMap.equals(value, val)) {
            return false;
        }
        this.values[p] = REMOVED;
        --this.size;
        return true;
    }

    private int find(long key) {
        if (key < this.minKey || key > this.maxKey) {
            return -1;
        }
        int hsize = this.keys.length;
        int start = LongRadkeHashMap.phash(key) % hsize;
        Object oldval = this.values[start];
        if (oldval == null) {
            return -1;
        }
        if (oldval != REMOVED && this.keys[start] == key) {
            return start;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return -1;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return p;
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return -1;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return p;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((oldval = this.values[pu]) == null) {
                return -1;
            }
            if (oldval != REMOVED && this.keys[pu] == key) {
                return pu;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((oldval = this.values[pd]) == null) {
                return -1;
            }
            if (oldval != REMOVED && this.keys[pd] == key) {
                return pd;
            }
            pu += j;
            pd -= j;
        }
        return -1;
    }

    public boolean containsValue(Object val) {
        int p = this.findVal(val);
        return p >= 0;
    }

    private int findVal(Object value) {
        value = LongRadkeHashMap.maskNull(value);
        for (int i = 0; i < this.values.length; ++i) {
            if (!LongRadkeHashMap.equals(this.values[i], value)) continue;
            return i;
        }
        return -1;
    }

    private void rehash() {
        if ((float)this.size >= (float)this.fill * this.resizeTreshold) {
            this.rehash(RadkeHashMap.radkeAtLeast(this.keys.length + 1));
        } else {
            this.rehash(this.keys.length);
        }
    }

    private void rehash(int newcapacity) {
        long[] oldkeys = this.keys;
        Object[] oldvals = this.values;
        this.keys = new long[newcapacity];
        this.values = new Object[newcapacity];
        this.size = 0;
        this.fill = 0;
        this.treshold = (int)(this.loadFactor * (float)newcapacity);
        for (int i = 0; i < oldkeys.length; ++i) {
            if (oldvals[i] == null || oldvals[i] == REMOVED) continue;
            this.put(oldkeys[i], oldvals[i]);
        }
    }

    public void clear() {
        Arrays.fill(this.values, null);
        this.size = 0;
        this.fill = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public long size64() {
        return this.size;
    }

    public void putAll(LongMap map) {
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public LongSet keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.valueCollection == null) {
            this.valueCollection = new Values();
        }
        return this.valueCollection;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LongMap)) {
            return false;
        }
        LongMap that = (LongMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            Object val2;
            Object val = this.values[i];
            if (val == null || val == REMOVED || (val2 = that.get(this.keys[i])) != null && val.equals(val2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED) continue;
            hash += LongRadkeHashMap.hash(this.keys[i]) ^ (val == NULL ? 0 : val.hashCode());
        }
        return hash;
    }

    public Object clone() {
        LongRadkeHashMap result;
        try {
            result = (LongRadkeHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result.keys = new long[this.keys.length];
        result.values = new Object[this.values.length];
        result.keySet = null;
        result.entrySet = null;
        result.valueCollection = null;
        result.fill = 0;
        result.size = 0;
        result.putAll(this);
        return result;
    }

    private boolean keySetContainsAll(LongCollection c) {
        LongIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.containsKey(itr.next())) continue;
            return false;
        }
        return true;
    }

    private boolean keySetRemoveMapping(long key) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        Object removed = this.values[p];
        this.values[p] = REMOVED;
        --this.size;
        return true;
    }

    private boolean keySetRemoveAll(LongCollection c) {
        boolean modified = false;
        if (this.keys.length * 2 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || !c.contains(this.keys[i])) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            LongIterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.keySetRemoveMapping(itr.next());
            }
        }
        return modified;
    }

    private boolean keySetRetainAll(LongCollection c) {
        boolean modified = false;
        if (this.keys.length * 4 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || c.contains(this.keys[i])) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            LongRadkeHashMap tmp = new LongRadkeHashMap(this.keys.length, this.loadFactor, this.resizeTreshold);
            LongIterator itr = c.iterator();
            while (itr.hasNext()) {
                long key = itr.next();
                int p = this.find(key);
                if (p < 0) continue;
                tmp.put(key, this.values[p]);
                modified = true;
            }
            if (modified) {
                this.keys = tmp.keys;
                this.values = tmp.values;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    private long[] keySetToArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = this.keys[j];
        }
        return a;
    }

    private long[] keySetToArray() {
        long[] a = new long[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = this.keys[j];
        }
        return a;
    }

    private boolean entrySetContainsEntry(Object o) {
        if (!(o instanceof LongMap.Entry)) {
            return false;
        }
        LongMap.Entry e = (LongMap.Entry)o;
        return this.containsMapping(e.getKey(), e.getValue());
    }

    private boolean entrySetContainsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            LongMap.Entry e;
            Object o = itr.next();
            if (!(o instanceof LongMap.Entry) || this.containsMapping((e = (LongMap.Entry)o).getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean entrySetRemoveMapping(Object o) {
        if (!(o instanceof LongMap.Entry)) {
            return false;
        }
        LongMap.Entry e = (LongMap.Entry)o;
        return this.removeMapping(e.getKey(), e.getValue());
    }

    private boolean entrySetRemoveAll(Collection c) {
        boolean modified = false;
        if (this.keys.length < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || !c.contains(new SimpleEntry(this.keys[i], LongRadkeHashMap.unmaskNull(val)))) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.entrySetRemoveMapping(itr.next());
            }
        }
        return modified;
    }

    private boolean entrySetRetainAll(Collection c) {
        boolean modified = false;
        if (this.keys.length * 4 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || c.contains(new SimpleEntry(this.keys[i], LongRadkeHashMap.unmaskNull(val)))) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            LongRadkeHashMap tmp = new LongRadkeHashMap(this.keys.length, this.loadFactor, this.resizeTreshold);
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                LongMap.Entry e;
                int p;
                Object o = itr.next();
                if (!(o instanceof LongMap.Entry) || (p = this.find((e = (LongMap.Entry)o).getKey())) < 0) continue;
                Object val = LongRadkeHashMap.unmaskNull(this.values[p]);
                if (!LongRadkeHashMap.equals(e.getValue(), val)) continue;
                tmp.put(e.getKey(), val);
            }
            boolean bl = modified = this.size != tmp.size;
            if (modified) {
                this.keys = tmp.keys;
                this.values = tmp.values;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    private Object[] entrySetToArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = new SimpleEntry(this.keys[j], LongRadkeHashMap.unmaskNull(val));
        }
        return a;
    }

    private Object[] entrySetToArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = new SimpleEntry(this.keys[j], LongRadkeHashMap.unmaskNull(val));
        }
        return a;
    }

    private boolean valuesContainsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.containsValue(itr.next())) continue;
            return false;
        }
        return true;
    }

    private boolean valuesRemoveMapping(Object value) {
        int p = this.findVal(value);
        if (p < 0) {
            return false;
        }
        Object removed = this.values[p];
        this.values[p] = REMOVED;
        --this.size;
        return true;
    }

    private boolean valuesRemoveAll(Collection c) {
        boolean modified = false;
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED || !c.contains(LongRadkeHashMap.unmaskNull(val))) continue;
            this.values[i] = REMOVED;
            --this.size;
            modified = true;
        }
        return modified;
    }

    private boolean valuesRetainAll(Collection c) {
        boolean modified = false;
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED || c.contains(LongRadkeHashMap.unmaskNull(val))) continue;
            this.values[i] = REMOVED;
            --this.size;
            modified = true;
        }
        return modified;
    }

    private Object[] valuesToArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = LongRadkeHashMap.unmaskNull(val);
        }
        return a;
    }

    private Object[] valuesToArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = LongRadkeHashMap.unmaskNull(val);
        }
        return a;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        HashIterator itr = new HashIterator();
        while (itr.hasNext()) {
            itr.goNext();
            long k = this.keys[itr.curr];
            Object v = LongRadkeHashMap.unmaskNull(this.values[itr.curr]);
            buf.append(k).append("=").append(v == this ? "(this Map)" : v);
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.keys.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED) continue;
            out.writeLong(this.keys[i]);
            out.writeObject(LongRadkeHashMap.unmaskNull(val));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.keys = new long[capacity];
        this.values = new Object[capacity];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            long key = in.readLong();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    private static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static final Object maskNull(Object obj) {
        return obj == null ? NULL : obj;
    }

    private static final Object unmaskNull(Object obj) {
        return obj == NULL ? null : obj;
    }

    private static final int hash(long e) {
        return (int)(e & 0xFFFFFFFFFFFFFFFFL ^ e >>> 32);
    }

    private static final int phash(long e) {
        return (int)(e & Integer.MAX_VALUE ^ e >>> 33);
    }

    private class Values
    implements Collection {
        private Values() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            LongRadkeHashMap.this.clear();
        }

        public int size() {
            return LongRadkeHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongRadkeHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return LongRadkeHashMap.this.containsValue(o);
        }

        public boolean containsAll(Collection c) {
            return LongRadkeHashMap.this.valuesContainsAll(c);
        }

        public boolean remove(Object o) {
            return LongRadkeHashMap.this.valuesRemoveMapping(o);
        }

        public boolean removeAll(Collection c) {
            return LongRadkeHashMap.this.valuesRemoveAll(c);
        }

        public boolean retainAll(Collection c) {
            return LongRadkeHashMap.this.valuesRetainAll(c);
        }

        public Object[] toArray() {
            return LongRadkeHashMap.this.valuesToArray();
        }

        public Object[] toArray(Object[] a) {
            return LongRadkeHashMap.this.valuesToArray(a);
        }

        public Iterator iterator() {
            return new ValueIterator();
        }
    }

    private static class SimpleEntry
    implements LongMap.Entry {
        final long key;
        final Object value;

        SimpleEntry(long key, Object value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Immutable object");
        }

        public boolean equals(Object other) {
            if (!(other instanceof LongMap.Entry)) {
                return false;
            }
            LongMap.Entry that = (LongMap.Entry)other;
            if (this.getKey() != that.getKey()) {
                return false;
            }
            return LongRadkeHashMap.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            long key = this.getKey();
            Object val = this.getValue();
            return LongRadkeHashMap.hash(key) ^ (val == null ? 0 : val.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySet
    implements Set {
        private EntrySet() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            LongRadkeHashMap.this.clear();
        }

        public int size() {
            return LongRadkeHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongRadkeHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return LongRadkeHashMap.this.entrySetContainsEntry(o);
        }

        public boolean containsAll(Collection c) {
            return LongRadkeHashMap.this.entrySetContainsAll(c);
        }

        public boolean remove(Object o) {
            return LongRadkeHashMap.this.entrySetRemoveMapping(o);
        }

        public boolean removeAll(Collection c) {
            return LongRadkeHashMap.this.entrySetRemoveAll(c);
        }

        public boolean retainAll(Collection c) {
            return LongRadkeHashMap.this.entrySetRetainAll(c);
        }

        public Object[] toArray() {
            return LongRadkeHashMap.this.entrySetToArray();
        }

        public Object[] toArray(Object[] a) {
            return LongRadkeHashMap.this.entrySetToArray(a);
        }

        public Iterator iterator() {
            return new EntryIterator();
        }
    }

    private class KeySet
    extends AbstractLongSet
    implements LongSet {
        private KeySet() {
        }

        public long min() {
            return LongRadkeHashMap.this.minKey;
        }

        public long max() {
            return LongRadkeHashMap.this.maxKey;
        }

        public boolean add(long e) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(LongCollection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            LongRadkeHashMap.this.clear();
        }

        public long size64() {
            return LongRadkeHashMap.this.size64();
        }

        public boolean isEmpty() {
            return LongRadkeHashMap.this.isEmpty();
        }

        public boolean contains(long e) {
            return LongRadkeHashMap.this.containsKey(e);
        }

        public boolean containsAll(LongCollection c) {
            return LongRadkeHashMap.this.keySetContainsAll(c);
        }

        public boolean remove(long e) {
            return LongRadkeHashMap.this.keySetRemoveMapping(e);
        }

        public boolean removeAll(LongCollection c) {
            return LongRadkeHashMap.this.keySetRemoveAll(c);
        }

        public boolean retainAll(LongCollection c) {
            return LongRadkeHashMap.this.keySetRetainAll(c);
        }

        public long[] toArray() {
            return LongRadkeHashMap.this.keySetToArray();
        }

        public long[] toArray(long[] a) {
            return LongRadkeHashMap.this.keySetToArray(a);
        }

        public LongIterator iterator() {
            return new KeyIterator();
        }
    }

    private class ValueIterator
    extends HashIterator
    implements Iterator {
        private ValueIterator() {
        }

        public Object next() {
            this.goNext();
            return LongRadkeHashMap.unmaskNull(LongRadkeHashMap.this.values[this.curr]);
        }
    }

    private class EntryIterator
    extends HashIterator
    implements Iterator {
        private EntryIterator() {
        }

        public Object next() {
            this.goNext();
            return new Entry(this.curr);
        }
    }

    private class Entry
    implements LongMap.Entry {
        final int p;

        Entry(int p) {
            this.p = p;
        }

        public long getKey() {
            if (LongRadkeHashMap.this.values[this.p] == null || LongRadkeHashMap.this.values[this.p] == REMOVED) {
                throw new IllegalStateException("Mapping was removed");
            }
            return LongRadkeHashMap.this.keys[this.p];
        }

        public Object getValue() {
            if (LongRadkeHashMap.this.values[this.p] == null || LongRadkeHashMap.this.values[this.p] == REMOVED) {
                throw new IllegalStateException("Mapping was removed");
            }
            return LongRadkeHashMap.unmaskNull(LongRadkeHashMap.this.values[this.p]);
        }

        public Object setValue(Object value) {
            Object old = LongRadkeHashMap.this.values[this.p];
            if (old == null || old == REMOVED) {
                throw new IllegalStateException("Mapping was removed");
            }
            LongRadkeHashMap.this.values[this.p] = LongRadkeHashMap.maskNull(value);
            return LongRadkeHashMap.unmaskNull(old);
        }

        public boolean equals(Object other) {
            if (!(other instanceof LongMap.Entry)) {
                return false;
            }
            LongMap.Entry that = (LongMap.Entry)other;
            if (this.getKey() != that.getKey()) {
                return false;
            }
            return LongRadkeHashMap.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            Object val = LongRadkeHashMap.this.values[this.p];
            if (val == REMOVED || val == null) {
                return 0;
            }
            long key = LongRadkeHashMap.this.keys[this.p];
            return LongRadkeHashMap.hash(key) ^ (val == NULL ? 0 : val.hashCode());
        }

        public String toString() {
            Object val = LongRadkeHashMap.this.values[this.p];
            if (val == REMOVED || val == null) {
                return "REMOVED";
            }
            return LongRadkeHashMap.this.keys[this.p] + "=" + LongRadkeHashMap.unmaskNull(val);
        }
    }

    private class KeyIterator
    extends HashIterator
    implements LongIterator {
        private KeyIterator() {
        }

        public long next() {
            this.goNext();
            return LongRadkeHashMap.this.keys[this.curr];
        }
    }

    private class HashIterator {
        int curr = 0;
        int next = 0;

        HashIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next < LongRadkeHashMap.this.keys.length;
        }

        protected void goNext() {
            if (this.next >= LongRadkeHashMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.findNext();
        }

        private void findNext() {
            while (this.next < LongRadkeHashMap.this.keys.length && (LongRadkeHashMap.this.values[this.next] == null || LongRadkeHashMap.this.values[this.next] == REMOVED)) {
                ++this.next;
            }
        }

        public void remove() {
            if (LongRadkeHashMap.this.values[this.curr] != REMOVED) {
                LongRadkeHashMap.this.values[this.curr] = REMOVED;
                --LongRadkeHashMap.this.size;
            }
        }
    }
}

