/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.shorts;

import edu.emory.mathcs.util.collections.shorts.AbstractShortSet;
import edu.emory.mathcs.util.collections.shorts.ShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortCollections;
import edu.emory.mathcs.util.collections.shorts.ShortInterval;
import edu.emory.mathcs.util.collections.shorts.ShortIterator;
import edu.emory.mathcs.util.collections.shorts.ShortSortedSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractShortSortedSet
extends AbstractShortSet
implements ShortSortedSet {
    public boolean isEmpty() {
        return !this.intervalIterator().hasNext();
    }

    public int size() {
        int size = 0;
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            size = (short)(size + ((ShortInterval)itr.next()).size());
        }
        return size;
    }

    public int intervalCount() {
        int count = 0;
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            ++count;
        }
        return count;
    }

    public short first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.firstInterval().first();
    }

    public short last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.lastInterval().last();
    }

    public short pollFirst() {
        short first = this.first();
        this.remove(first);
        return first;
    }

    public short pollLast() {
        short last = this.last();
        this.remove(last);
        return last;
    }

    public ShortInterval firstInterval() {
        Iterator itr = this.intervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (ShortInterval)itr.next();
    }

    public ShortInterval lastInterval() {
        Iterator itr = this.descendingIntervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (ShortInterval)itr.next();
    }

    public ShortInterval pollFirstInterval() {
        Iterator itr = this.intervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        ShortInterval r = (ShortInterval)itr.next();
        itr.remove();
        return r;
    }

    public ShortInterval pollLastInterval() {
        Iterator itr = this.descendingIntervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        ShortInterval r = (ShortInterval)itr.next();
        itr.remove();
        return r;
    }

    public boolean retainAll(ShortCollection c) {
        if (c instanceof ShortSortedSet) {
            ShortSortedSet s = (ShortSortedSet)c;
            boolean modified = false;
            modified |= this.removeAll(s.complementSet());
            if (s.min() > this.min()) {
                modified |= this.removeInterval(this.min(), (short)(s.min() - 1));
            }
            if (s.max() < this.max()) {
                modified |= this.removeInterval((short)(s.max() + 1), this.max());
            }
            return modified;
        }
        return super.retainAll(c);
    }

    public boolean retainInterval(short first, short last) {
        boolean modified = false;
        short min = this.min();
        short max = this.max();
        if (first > min) {
            modified |= this.removeInterval(min, (short)(first - 1));
        }
        if (last < max) {
            modified |= this.removeInterval((short)(last + 1), max);
        }
        return modified;
    }

    public short higher(short e) {
        if (e == Short.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return this.tailSet((short)(e + 1)).first();
    }

    public short ceiling(short e) {
        return this.tailSet(e).first();
    }

    public short lower(short e) {
        if (e == Short.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.headSet((short)(e - 1)).last();
    }

    public short floor(short e) {
        return this.headSet(e).last();
    }

    public ShortSortedSet headSet(short last) {
        return this.subSet((short)Short.MIN_VALUE, last);
    }

    public ShortSortedSet tailSet(short first) {
        return this.subSet(first, (short)Short.MAX_VALUE);
    }

    public ShortIterator iterator() {
        return new ForwardIntervalItemIterator(this.intervalIterator());
    }

    public ShortIterator descendingIterator() {
        return new ReverseIntervalItemIterator(this.descendingIntervalIterator());
    }

    public String toCompactString() {
        Iterator itr = this.intervalIterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static abstract class AbstractComplementSubView
    extends AbstractShortSortedSet {
        protected final ShortSortedSet base;
        protected final short beg;
        protected final short end;

        protected AbstractComplementSubView(ShortSortedSet base, short beg, short end) {
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public short min() {
            short min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public short max() {
            short max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public int intervalCount() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                int count = this.base.intervalCount();
                if (count == 0) {
                    return this.isEmpty() ? 0 : 1;
                }
                --count;
                if (this.base.first() > this.min()) {
                    ++count;
                }
                if (this.base.last() < this.max()) {
                    ++count;
                }
                return count;
            }
            return super.intervalCount();
        }

        public boolean add(short e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.remove(e);
        }

        public boolean addInterval(short first, short last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.removeInterval(first, last);
        }

        public boolean remove(short e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.add(e);
        }

        public boolean removeInterval(short first, short last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.addInterval(first, last);
        }

        public boolean contains(short e) {
            return e < this.beg || e > this.end ? false : !this.base.contains(e);
        }

        public boolean containsInterval(short first, short last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.beg || last > this.end) {
                return false;
            }
            return !this.base.containsInterval(first, last);
        }

        public ShortInterval enclosingInterval(short e) {
            if (e < this.beg || e > this.end) {
                return null;
            }
            if (this.base.contains(e)) {
                return null;
            }
            ShortInterval l = this.base.lowerInterval(e);
            ShortInterval h = this.base.higherInterval(e);
            short first = l == null ? (short)Short.MIN_VALUE : (short)(l.last() + 1);
            short last = h == null ? (short)Short.MIN_VALUE : (short)(h.first() - 1);
            return this.trim(first, last);
        }

        public ShortInterval lowerInterval(short n) {
            ShortInterval e = this.base.enclosingInterval(n);
            ShortInterval l = this.base.lowerInterval(n);
            if (e != null) {
                short efirst = e.first();
                if (efirst == Short.MIN_VALUE) {
                    return null;
                }
                return this.trim((short)(l == null ? Short.MIN_VALUE : (short)(l.last() + 1)), (short)(efirst - 1));
            }
            if (l == null) {
                return null;
            }
            short lfirst = l.first();
            if (lfirst == Short.MIN_VALUE) {
                return null;
            }
            ShortInterval ll = this.base.lowerInterval((short)(lfirst - 1));
            return this.trim((short)(ll == null ? Short.MIN_VALUE : (short)(ll.last() + 1)), (short)(lfirst - 1));
        }

        public ShortInterval floorInterval(short n) {
            ShortInterval e = this.base.enclosingInterval(n);
            ShortInterval l = this.base.lowerInterval(n);
            if (e != null) {
                short efirst = e.first();
                if (efirst == Short.MIN_VALUE) {
                    return null;
                }
                return this.trim((short)(l == null ? Short.MIN_VALUE : (short)(l.last() + 1)), (short)(efirst - 1));
            }
            short first = l == null ? (short)Short.MIN_VALUE : (short)(l.last() + 1);
            ShortInterval h = this.base.higherInterval(n);
            short last = h == null ? (short)Short.MAX_VALUE : (short)(h.first() - 1);
            return this.trim(first, last);
        }

        public ShortInterval higherInterval(short n) {
            ShortInterval e = this.base.enclosingInterval(n);
            ShortInterval h = this.base.higherInterval(n);
            if (e != null) {
                short elast = e.last();
                if (elast == Short.MAX_VALUE) {
                    return null;
                }
                return this.trim((short)(elast + 1), h == null ? (short)Short.MAX_VALUE : (short)(h.first() - 1));
            }
            if (h == null) {
                return null;
            }
            short hlast = h.last();
            if (hlast == Short.MAX_VALUE) {
                return null;
            }
            ShortInterval hh = this.base.higherInterval((short)(hlast + 1));
            return this.trim((short)(hlast + 1), hh == null ? (short)Short.MAX_VALUE : (short)(hh.first() - 1));
        }

        public ShortInterval ceilingInterval(short n) {
            ShortInterval e = this.base.enclosingInterval(n);
            ShortInterval h = this.base.higherInterval(n);
            if (e != null) {
                short elast = e.last();
                if (elast == Short.MAX_VALUE) {
                    return null;
                }
                return this.trim((short)(elast + 1), h == null ? (short)Short.MIN_VALUE : (short)(h.first() - 1));
            }
            short last = h == null ? (short)Short.MAX_VALUE : (short)(h.first() - 1);
            ShortInterval l = this.base.lowerInterval(n);
            short first = l == null ? (short)Short.MIN_VALUE : (short)(l.last() + 1);
            return this.trim(first, last);
        }

        public void clear() {
            this.base.addInterval(this.beg, this.end);
        }

        private ShortInterval trim(short first, short last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return first <= last ? ShortCollections.interval(first, last) : null;
        }

        public abstract Iterator intervalIterator();

        public abstract Iterator descendingIntervalIterator();
    }

    protected static abstract class AbstractSubView
    extends AbstractShortSortedSet
    implements Serializable {
        protected final ShortSortedSet base;
        protected final short beg;
        protected final short end;

        protected AbstractSubView(ShortSortedSet base, short beg, short end) {
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public short min() {
            short min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public short max() {
            short max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public int size() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.base.size();
            }
            return super.size();
        }

        public int intervalCount() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.base.intervalCount();
            }
            return super.intervalCount();
        }

        public void clear() {
            this.removeInterval(this.beg, this.end);
        }

        public boolean add(short e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.add(e);
        }

        public boolean addInterval(short first, short last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.addInterval(first, last);
        }

        public boolean remove(short e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.remove(e);
        }

        public boolean removeInterval(short first, short last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.removeInterval(first, last);
        }

        public boolean contains(short e) {
            return e < this.beg || e > this.end ? false : this.base.contains(e);
        }

        public boolean containsInterval(short first, short last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.beg || last > this.end) {
                return false;
            }
            return this.base.containsInterval(first, last);
        }

        public ShortInterval enclosingInterval(short e) {
            if (e < this.beg || e > this.end) {
                return null;
            }
            return this.trim(this.base.enclosingInterval(e));
        }

        public ShortInterval higherInterval(short e) {
            return this.trim(this.base.higherInterval(e));
        }

        public ShortInterval ceilingInterval(short e) {
            return this.trim(this.base.ceilingInterval(e));
        }

        public ShortInterval lowerInterval(short e) {
            return this.trim(this.base.lowerInterval(e));
        }

        public ShortInterval floorInterval(short e) {
            return this.trim(this.base.floorInterval(e));
        }

        public abstract ShortSortedSet subSet(short var1, short var2);

        public abstract Iterator intervalIterator();

        public abstract Iterator descendingIntervalIterator();

        private ShortInterval trim(ShortInterval r) {
            short first = r.first();
            short last = r.last();
            if (first >= this.beg && last <= this.end) {
                return r;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return first <= last ? ShortCollections.interval(first, last) : null;
        }
    }

    protected static class ReverseIntervalItemIterator
    implements ShortIterator {
        Iterator it;
        ShortInterval currInterval;
        protected short cursor;
        protected short lastRet;
        protected boolean lastRetValid = false;

        ReverseIntervalItemIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext() || this.currInterval != null;
        }

        public short next() {
            if (this.currInterval == null) {
                this.currInterval = (ShortInterval)this.it.next();
                this.cursor = this.currInterval.last();
            }
            this.lastRet = this.cursor;
            this.lastRetValid = true;
            if (this.cursor > this.currInterval.first()) {
                this.cursor = (short)(this.cursor - 1);
            } else if (this.it.hasNext()) {
                this.currInterval = (ShortInterval)this.it.next();
                this.cursor = this.currInterval.last();
            } else {
                this.currInterval = null;
            }
            return this.lastRet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ForwardIntervalItemIterator
    implements ShortIterator {
        Iterator it;
        ShortInterval currInterval;
        protected short cursor;
        protected short lastRet;
        protected boolean lastRetValid = false;

        ForwardIntervalItemIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext() || this.currInterval != null;
        }

        public short next() {
            if (this.currInterval == null) {
                this.currInterval = (ShortInterval)this.it.next();
                this.cursor = this.currInterval.first();
            }
            this.lastRet = this.cursor;
            this.lastRetValid = true;
            if (this.cursor < this.currInterval.last()) {
                this.cursor = (short)(this.cursor + 1);
            } else if (this.it.hasNext()) {
                this.currInterval = (ShortInterval)this.it.next();
                this.cursor = this.currInterval.first();
            } else {
                this.currInterval = null;
            }
            return this.lastRet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

