/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.shorts;

import edu.emory.mathcs.util.collections.shorts.AbstractShortCollection;
import edu.emory.mathcs.util.collections.shorts.AbstractShortInterval;
import edu.emory.mathcs.util.collections.shorts.ShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortInterval;
import edu.emory.mathcs.util.collections.shorts.ShortIterator;
import edu.emory.mathcs.util.collections.shorts.ShortList;
import edu.emory.mathcs.util.collections.shorts.ShortListIterator;
import java.util.NoSuchElementException;

public class ShortCollections {
    public static final ShortInterval EMPTY_INTERVAL = new AbstractShortInterval(){

        public boolean isEmpty() {
            return true;
        }

        public short getFirst() {
            return 0;
        }

        public short getLast() {
            return -1;
        }

        public short min() {
            return 0;
        }

        public short max() {
            return -1;
        }
    };
    public static final ShortList EMPTY_LIST = new ShortArrAsList(new short[0]);

    private ShortCollections() {
    }

    public static ShortInterval interval(short first, short last) {
        return first > last ? EMPTY_INTERVAL : new SimpleInterval(first, last);
    }

    public static ShortList asList(short[] arr) {
        return new ShortArrAsList(arr);
    }

    private static class ShortArrAsList
    extends AbstractShortCollection
    implements ShortList {
        final short[] arr;

        ShortArrAsList(short[] arr) {
            this.arr = arr;
        }

        public int size() {
            return this.arr.length;
        }

        public boolean isEmpty() {
            return this.arr.length == 0;
        }

        public boolean contains(short e) {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] != e) continue;
                return true;
            }
            return false;
        }

        public ShortIterator iterator() {
            return this.listIterator();
        }

        public short[] toArray() {
            short[] a = new short[this.arr.length];
            System.arraycopy(this.arr, 0, a, 0, this.arr.length);
            return a;
        }

        public short[] toArray(short[] a) {
            if (a.length < this.arr.length) {
                a = new short[this.arr.length];
            }
            System.arraycopy(this.arr, 0, a, 0, this.arr.length);
            return a;
        }

        public boolean add(short e) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int idx, ShortCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(short e) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShortList)) {
                return false;
            }
            ShortList that = (ShortList)o;
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == that.getAt(i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 1;
            for (int i = 0; i < this.arr.length; ++i) {
                hashCode = 31 * hashCode + this.arr[i];
            }
            return hashCode;
        }

        public short getAt(int index) {
            return this.arr[index];
        }

        public short setAt(int index, short e) {
            short old = this.arr[index];
            this.arr[index] = e;
            return old;
        }

        public void addAt(int index, short e) {
            throw new UnsupportedOperationException();
        }

        public short removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(short e) {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] != e) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(short e) {
            for (int i = this.arr.length - 1; i >= 0; --i) {
                if (this.arr[i] != e) continue;
                return i;
            }
            return -1;
        }

        public ShortListIterator listIterator() {
            return new ArrAsListItr(0);
        }

        public ShortListIterator listIterator(int index) {
            return new ArrAsListItr(index);
        }

        public ShortList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        private class ArrAsListItr
        implements ShortListIterator {
            int cursor;

            ArrAsListItr(int cursor) {
                this.cursor = cursor;
            }

            public boolean hasNext() {
                return this.cursor < ShortArrAsList.this.arr.length;
            }

            public short next() {
                if (this.cursor == ShortArrAsList.this.arr.length) {
                    throw new NoSuchElementException();
                }
                return ShortArrAsList.this.arr[this.cursor++];
            }

            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            public short previous() {
                if (this.cursor == 0) {
                    throw new NoSuchElementException();
                }
                return ShortArrAsList.this.arr[--this.cursor];
            }

            public int nextIndex() {
                return this.cursor;
            }

            public int previousIndex() {
                return this.cursor - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(short e) {
                ShortArrAsList.this.arr[this.cursor] = e;
            }

            public void add(short e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class SimpleInterval
    extends AbstractShortInterval {
        final short first;
        final short last;

        public SimpleInterval(short first, short last) {
            if (first > last) {
                throw new IllegalArgumentException();
            }
            this.first = first;
            this.last = last;
        }

        public short getFirst() {
            return this.first;
        }

        public short getLast() {
            return this.last;
        }

        public short first() {
            return this.first;
        }

        public short last() {
            return this.last;
        }

        public short min() {
            return this.first;
        }

        public short max() {
            return this.last;
        }
    }
}

