/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.shorts;

import edu.emory.mathcs.util.collections.shorts.AbstractShortInterval;
import edu.emory.mathcs.util.collections.shorts.AbstractShortSortedSet;
import edu.emory.mathcs.util.collections.shorts.ShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortCollections;
import edu.emory.mathcs.util.collections.shorts.ShortInterval;
import edu.emory.mathcs.util.collections.shorts.ShortIterator;
import edu.emory.mathcs.util.collections.shorts.ShortSet;
import edu.emory.mathcs.util.collections.shorts.ShortSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ShortIntervalSet
extends AbstractShortSortedSet
implements Serializable {
    transient Entry root;
    transient short size;
    transient int intervalCount;
    transient int modCount;
    final short min;
    final short max;

    public ShortIntervalSet() {
        this(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public ShortIntervalSet(short min, short max) {
        this.min = min;
        this.max = max;
    }

    public ShortIntervalSet(ShortCollection c) {
        this();
        this.addAll(c);
    }

    public ShortIntervalSet(ShortSet c) {
        this(c.min(), c.max());
        this.addAll(c);
    }

    public short min() {
        return this.min;
    }

    public short max() {
        return this.max;
    }

    public int intervalCount() {
        return this.intervalCount;
    }

    public short size64() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.root = null;
        this.intervalCount = 0;
        this.size = 0;
    }

    public boolean add(short n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Entry e = this.getInsertionPoint(n);
        if (e == null) {
            this.insertRight(new Entry(n, n), this.getLastEntry());
            this.size = (short)(this.size + 1);
            return true;
        }
        if (n < e.first - 1) {
            this.insertLeft(new Entry(n, n), e);
            this.size = (short)(this.size + 1);
            return true;
        }
        if (n == e.first - 1) {
            Entry.access$010(e);
            this.size = (short)(this.size + 1);
            return true;
        }
        if (n <= e.last) {
            return false;
        }
        Entry next = ShortIntervalSet.successor(e);
        if (next != null && n == next.first - 1) {
            e.last = next.last;
            this.delete(next);
            this.size = (short)(this.size + 1);
            return true;
        }
        Entry.access$108(e);
        this.size = (short)(this.size + 1);
        return true;
    }

    public boolean addInterval(short first, short last) {
        Entry e;
        if (first > last) {
            return false;
        }
        if (first == last) {
            return this.add(first);
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        if ((e = this.getInsertionPoint(first)) == null) {
            this.insertRight(new Entry(first, last), this.getLastEntry());
            this.size = (short)(this.size + (short)(last - first + 1));
            return true;
        }
        if (last < e.first - 1) {
            this.insertLeft(new Entry(first, last), e);
            this.size = (short)(this.size + (short)(last - first + 1));
            return true;
        }
        if (last <= e.last) {
            if (first >= e.first) {
                return false;
            }
            this.size = (short)(this.size + (short)(e.first - first));
            e.first = first;
            return true;
        }
        Entry base = e;
        if (first < base.first) {
            this.size = (short)(this.size + (base.first - first));
            base.first = first;
        }
        e = ShortIntervalSet.successor(e);
        while (e != null) {
            if (last < e.first - 1) {
                this.size = (short)(this.size + (short)(last - base.last));
                base.last = last;
                return true;
            }
            this.size = (short)(this.size - (short)(e.last - e.first + 1));
            if (last <= e.last) {
                this.size = (short)(this.size + (short)(e.last - base.last));
                base.last = e.last;
                this.delete(e);
                return true;
            }
            e = this.deleteAndAdvance(e);
        }
        this.size = (short)(this.size + (short)(last - base.last));
        base.last = last;
        return true;
    }

    public boolean addAll(ShortCollection c) {
        if (c == this) {
            return false;
        }
        if (c instanceof SubView) {
            SubView s = (SubView)c;
            if (s.base == this) {
                return false;
            }
        } else if (c instanceof ComplementSubView) {
            ComplementSubView s = (ComplementSubView)c;
            if (s.base == this) {
                return this.addInterval(s.min(), s.max());
            }
        }
        return super.addAll(c);
    }

    public boolean remove(short n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Entry e = this.getEntry(n);
        if (e == null) {
            return false;
        }
        if (e.first == e.last) {
            this.delete(e);
        } else if (n == e.first) {
            Entry.access$008(e);
        } else if (n == e.last) {
            Entry.access$110(e);
        } else {
            short last = e.last;
            e.last = (short)(n - 1);
            this.insertRight(new Entry((short)(n + 1), last), e);
        }
        this.size = (short)(this.size - 1);
        return true;
    }

    public boolean removeInterval(short first, short last) {
        if (first > last) {
            return false;
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        if (first == last) {
            return this.remove(first);
        }
        Entry e = this.getCeilingEntry(first);
        if (e == null) {
            return false;
        }
        boolean modified = false;
        if (first > e.first) {
            if (last < e.last) {
                Entry newe = new Entry((short)(last + 1), e.last);
                e.last = (short)(first - 1);
                this.insertRight(newe, e);
                this.size = (short)(this.size - (short)(last - first + 1));
                return true;
            }
            this.size = (short)(this.size - (short)(first - e.last));
            e.last = (short)(first - 1);
            e = ShortIntervalSet.successor(e);
            if (e == null) {
                return true;
            }
            modified = true;
        }
        while (last >= e.last) {
            if ((e = this.deleteAndAdvance(e)) == null) {
                return true;
            }
            modified = true;
        }
        if (last >= e.first) {
            this.size = (short)(this.size - (short)(last - e.first + 1));
            e.first = (short)(last + 1);
            return true;
        }
        return modified;
    }

    public boolean removeAll(ShortCollection c) {
        if (c == this) {
            boolean modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        if (c instanceof SubView) {
            SubView s = (SubView)c;
            if (s.base == this) {
                return this.removeInterval(s.min(), s.max());
            }
        } else if (c instanceof ComplementSubView) {
            ComplementSubView s = (ComplementSubView)c;
            if (s.base == this) {
                return false;
            }
        }
        return super.removeAll(c);
    }

    public boolean contains(short n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        return this.getEntry(n) != null;
    }

    public boolean containsInterval(short first, short last) {
        if (first > last) {
            return true;
        }
        if (first == last) {
            return this.contains(first);
        }
        if (first < this.min || last > this.max) {
            return false;
        }
        Entry e = this.getEntry(first);
        return e != null && e.last >= last;
    }

    public ShortInterval enclosingInterval(short e) {
        if (e < this.min || e > this.max) {
            return null;
        }
        return this.getEntry(e);
    }

    public short lower(short n) {
        if (n == this.min) {
            throw new NoSuchElementException();
        }
        return this.floor((short)(n - 1));
    }

    public short floor(short n) {
        if (n < this.min) {
            throw new NoSuchElementException();
        }
        Entry e = this.getFloorEntry(n);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return n <= e.last ? n : e.last;
    }

    public short higher(short n) {
        if (n == this.max) {
            throw new NoSuchElementException();
        }
        return this.ceiling((short)(n + 1));
    }

    public short ceiling(short n) {
        if (n > this.max) {
            throw new NoSuchElementException();
        }
        Entry e = this.getCeilingEntry(n);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return n >= e.first ? n : e.first;
    }

    public Iterator intervalIterator() {
        return new ForwardIntervalIterator(this.getFirstEntry());
    }

    public ShortIterator iterator() {
        return new ForwardItemIterator();
    }

    public Iterator descendingIntervalIterator() {
        return new ReverseIntervalIterator(this.getLastEntry());
    }

    public ShortIterator descendingIterator() {
        return new ReverseItemIterator();
    }

    public short first() {
        Entry r = this.getFirstEntry();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return r.first;
    }

    public short last() {
        Entry r = this.getLastEntry();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return r.last;
    }

    public short pollFirst() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        short first = e.first;
        if (e.first == e.last) {
            this.delete(e);
        } else {
            Entry.access$008(e);
        }
        this.size = (short)(this.size - 1);
        return first;
    }

    public short pollLast() {
        Entry e = this.getLastEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        short last = e.last;
        if (e.first == e.last) {
            this.delete(e);
        } else {
            Entry.access$110(e);
        }
        this.size = (short)(this.size - 1);
        return last;
    }

    public ShortInterval firstInterval() {
        return this.getFirstEntry();
    }

    public ShortInterval lastInterval() {
        return this.getLastEntry();
    }

    public ShortInterval ceilingInterval(short n) {
        return this.getCeilingEntry(n);
    }

    public ShortInterval floorInterval(short n) {
        return this.getFloorEntry(n);
    }

    public ShortInterval higherInterval(short n) {
        return this.getHigherEntry(n);
    }

    public ShortInterval lowerInterval(short n) {
        return this.getLowerEntry(n);
    }

    public ShortInterval pollFirstInterval() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            return null;
        }
        short first = e.first;
        short last = e.last;
        this.delete(e);
        this.size = (short)(this.size - (last - first + 1));
        return ShortCollections.interval(first, last);
    }

    public ShortInterval pollLastInterval() {
        Entry e = this.getLastEntry();
        if (e == null) {
            return null;
        }
        short first = e.first;
        short last = e.last;
        this.delete(e);
        this.size = (short)(this.size - (last - first + 1));
        return ShortCollections.interval(first, last);
    }

    public ShortSortedSet subSet(short first, short last) {
        if (first == this.min && last == this.max) {
            return this;
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        return new SubView(this, first, last);
    }

    public ShortSet complementSet() {
        return new ComplementSubView(this, this.min, this.max);
    }

    private static ShortInterval fix(ShortInterval r, short min, short max) {
        short first = r.first();
        short last = r.last();
        if (first >= min && last <= max) {
            return r;
        }
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        return ShortCollections.interval(first, last);
    }

    private Entry getEntry(short n) {
        Entry t = this.root;
        while (true) {
            if (t == null) {
                return null;
            }
            if (n < t.first) {
                t = t.left;
                continue;
            }
            if (n <= t.last) break;
            t = t.right;
        }
        return t;
    }

    private Entry getInsertionPoint(short n) {
        return n > Short.MIN_VALUE ? this.getCeilingEntry((short)(n - 1)) : this.getFirstEntry();
    }

    private Entry getHigherEntry(short n) {
        Entry t = this.root;
        if (t == null) {
            return null;
        }
        while (true) {
            if (n < t.first) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                return t;
            }
            if (t.right == null) break;
            t = t.right;
        }
        Entry parent = t.parent;
        while (parent != null && t == parent.right) {
            t = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry getFirstEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.left != null) {
            e = e.left;
        }
        return e;
    }

    private Entry getLastEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.right != null) {
            e = e.right;
        }
        return e;
    }

    private Entry getCeilingEntry(short n) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                if (n < e.first) {
                    if (e.left != null) {
                        e = e.left;
                        continue;
                    }
                    return e;
                }
                if (n <= e.last) break block5;
                if (e.right == null) break;
                e = e.right;
            }
            Entry p = e.parent;
            while (p != null && e == p.right) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    private Entry getLowerEntry(short n) {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (true) {
            if (n > e.last) {
                if (e.right != null) {
                    e = e.right;
                    continue;
                }
                return e;
            }
            if (e.left == null) break;
            e = e.left;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry getFloorEntry(short n) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                if (n > e.last) {
                    if (e.right != null) {
                        e = e.right;
                        continue;
                    }
                    return e;
                }
                if (n >= e.first) break block5;
                if (e.left == null) break;
                e = e.left;
            }
            Entry p = e.parent;
            while (p != null && e == p.left) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    private void insertLeft(Entry e, Entry where) {
        if (where == null) {
            this.root = e;
            this.intervalCount = 1;
            return;
        }
        if (where.left == null) {
            where.left = e;
        } else {
            where = where.left;
            while (where.right != null) {
                where = where.right;
            }
            where.right = e;
        }
        e.parent = where;
        this.fixAfterInsertion(e);
        ++this.intervalCount;
    }

    private void insertRight(Entry e, Entry where) {
        if (where == null) {
            this.root = e;
            this.intervalCount = 1;
            return;
        }
        if (where.right == null) {
            where.right = e;
        } else {
            where = where.right;
            while (where.left != null) {
                where = where.left;
            }
            where.left = e;
        }
        e.parent = where;
        this.fixAfterInsertion(e);
        ++this.intervalCount;
    }

    private static Entry successor(Entry e) {
        if (e.right != null) {
            e = e.right;
            while (e.left != null) {
                e = e.left;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.right) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private static Entry predecessor(Entry e) {
        if (e.left != null) {
            e = e.left;
            while (e.right != null) {
                e = e.right;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry deleteAndAdvance(Entry e) {
        Entry next = e.left == null || e.right == null ? ShortIntervalSet.successor(e) : e;
        this.delete(e);
        return next;
    }

    private void delete(Entry e) {
        if (e.left == null && e.right == null && e.parent == null) {
            this.root = null;
            this.intervalCount = 0;
            return;
        }
        if (e.left != null && e.right != null) {
            Entry s = ShortIntervalSet.successor(e);
            e.first = s.first;
            e.last = s.last;
            e = s;
        }
        if (e.left == null && e.right == null) {
            if (e.color) {
                this.fixAfterDeletion(e);
            }
            if (e.parent != null) {
                if (e == e.parent.left) {
                    e.parent.left = null;
                } else if (e == e.parent.right) {
                    e.parent.right = null;
                }
                e.parent = null;
            }
        } else {
            Entry replacement = e.left;
            if (replacement == null) {
                replacement = e.right;
            }
            replacement.parent = e.parent;
            if (e.parent == null) {
                this.root = replacement;
            } else if (e == e.parent.left) {
                e.parent.left = replacement;
            } else {
                e.parent.right = replacement;
            }
            e.left = null;
            e.right = null;
            e.parent = null;
            if (e.color) {
                this.fixAfterDeletion(replacement);
            }
        }
        --this.intervalCount;
    }

    static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private final void rotateLeft(Entry e) {
        Entry r = e.right;
        e.right = r.left;
        if (r.left != null) {
            r.left.parent = e;
        }
        r.parent = e.parent;
        if (e.parent == null) {
            this.root = r;
        } else if (e.parent.left == e) {
            e.parent.left = r;
        } else {
            e.parent.right = r;
        }
        r.left = e;
        e.parent = r;
    }

    private final void rotateRight(Entry e) {
        Entry l = e.left;
        e.left = l.right;
        if (l.right != null) {
            l.right.parent = e;
        }
        l.parent = e.parent;
        if (e.parent == null) {
            this.root = l;
        } else if (e.parent.right == e) {
            e.parent.right = l;
        } else {
            e.parent.left = l;
        }
        l.right = e;
        e.parent = l;
    }

    private final void fixAfterInsertion(Entry e) {
        e.color = false;
        Entry x = e;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (ShortIntervalSet.parentOf(x) == ShortIntervalSet.leftOf(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)))) {
                y = ShortIntervalSet.rightOf(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)));
                if (!ShortIntervalSet.colorOf(y)) {
                    ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), true);
                    ShortIntervalSet.setColor(y, true);
                    ShortIntervalSet.setColor(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)), false);
                    x = ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x));
                    continue;
                }
                if (x == ShortIntervalSet.rightOf(ShortIntervalSet.parentOf(x))) {
                    x = ShortIntervalSet.parentOf(x);
                    this.rotateLeft(x);
                }
                ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), true);
                ShortIntervalSet.setColor(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)), false);
                if (ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)) == null) continue;
                this.rotateRight(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)));
                continue;
            }
            y = ShortIntervalSet.leftOf(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)));
            if (!ShortIntervalSet.colorOf(y)) {
                ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), true);
                ShortIntervalSet.setColor(y, true);
                ShortIntervalSet.setColor(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)), false);
                x = ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x));
                continue;
            }
            if (x == ShortIntervalSet.leftOf(ShortIntervalSet.parentOf(x))) {
                x = ShortIntervalSet.parentOf(x);
                this.rotateRight(x);
            }
            ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), true);
            ShortIntervalSet.setColor(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)), false);
            if (ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)) == null) continue;
            this.rotateLeft(ShortIntervalSet.parentOf(ShortIntervalSet.parentOf(x)));
        }
        this.root.color = true;
    }

    private final Entry fixAfterDeletion(Entry e) {
        Entry x = e;
        while (x != this.root && ShortIntervalSet.colorOf(x)) {
            Entry sib;
            if (x == ShortIntervalSet.leftOf(ShortIntervalSet.parentOf(x))) {
                sib = ShortIntervalSet.rightOf(ShortIntervalSet.parentOf(x));
                if (!ShortIntervalSet.colorOf(sib)) {
                    ShortIntervalSet.setColor(sib, true);
                    ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), false);
                    this.rotateLeft(ShortIntervalSet.parentOf(x));
                    sib = ShortIntervalSet.rightOf(ShortIntervalSet.parentOf(x));
                }
                if (ShortIntervalSet.colorOf(ShortIntervalSet.leftOf(sib)) && ShortIntervalSet.colorOf(ShortIntervalSet.rightOf(sib))) {
                    ShortIntervalSet.setColor(sib, false);
                    x = ShortIntervalSet.parentOf(x);
                    continue;
                }
                if (ShortIntervalSet.colorOf(ShortIntervalSet.rightOf(sib))) {
                    ShortIntervalSet.setColor(ShortIntervalSet.leftOf(sib), true);
                    ShortIntervalSet.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = ShortIntervalSet.rightOf(ShortIntervalSet.parentOf(x));
                }
                ShortIntervalSet.setColor(sib, ShortIntervalSet.colorOf(ShortIntervalSet.parentOf(x)));
                ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), true);
                ShortIntervalSet.setColor(ShortIntervalSet.rightOf(sib), true);
                this.rotateLeft(ShortIntervalSet.parentOf(x));
                x = this.root;
                continue;
            }
            sib = ShortIntervalSet.leftOf(ShortIntervalSet.parentOf(x));
            if (!ShortIntervalSet.colorOf(sib)) {
                ShortIntervalSet.setColor(sib, true);
                ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), false);
                this.rotateRight(ShortIntervalSet.parentOf(x));
                sib = ShortIntervalSet.leftOf(ShortIntervalSet.parentOf(x));
            }
            if (ShortIntervalSet.colorOf(ShortIntervalSet.rightOf(sib)) && ShortIntervalSet.colorOf(ShortIntervalSet.leftOf(sib))) {
                ShortIntervalSet.setColor(sib, false);
                x = ShortIntervalSet.parentOf(x);
                continue;
            }
            if (ShortIntervalSet.colorOf(ShortIntervalSet.leftOf(sib))) {
                ShortIntervalSet.setColor(ShortIntervalSet.rightOf(sib), true);
                ShortIntervalSet.setColor(sib, false);
                this.rotateLeft(sib);
                sib = ShortIntervalSet.leftOf(ShortIntervalSet.parentOf(x));
            }
            ShortIntervalSet.setColor(sib, ShortIntervalSet.colorOf(ShortIntervalSet.parentOf(x)));
            ShortIntervalSet.setColor(ShortIntervalSet.parentOf(x), true);
            ShortIntervalSet.setColor(ShortIntervalSet.leftOf(sib), true);
            this.rotateRight(ShortIntervalSet.parentOf(x));
            x = this.root;
        }
        ShortIntervalSet.setColor(x, true);
        return this.root;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.intervalCount);
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            ShortInterval iv = (ShortInterval)itr.next();
            out.writeShort(iv.first());
            out.writeShort(iv.last());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int intervalCount = in.readInt();
        for (int i = 0; i < intervalCount; ++i) {
            short first = in.readShort();
            short last = in.readShort();
            this.addInterval(first, last);
        }
    }

    private static class ReverseComplementSubIntervalIterator
    implements Iterator {
        final ShortIntervalSet base;
        final short min;
        final short max;
        ShortInterval prev;
        short cursor;
        Entry next;
        ShortInterval lastRet;

        ReverseComplementSubIntervalIterator(ShortIntervalSet base, short min, short max) {
            this.base = base;
            this.min = min;
            this.max = max;
            Entry e = base.getCeilingEntry(max);
            if (e != null) {
                this.cursor = e.first < max ? e.first : max;
                this.next = ShortIntervalSet.predecessor(e);
            } else {
                this.cursor = max;
                this.next = base.getLowerEntry(max);
            }
        }

        public boolean hasNext() {
            return this.cursor > this.min;
        }

        public Object next() {
            short first;
            short last;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short s = last = this.cursor < this.max ? (short)(this.cursor - 1) : this.max;
            if (this.next == null) {
                this.cursor = first = this.min;
            } else {
                first = (short)(this.next.last + 1);
                if (first < this.min) {
                    first = this.min;
                }
                this.cursor = this.next.first;
                this.next = ShortIntervalSet.predecessor(this.next);
            }
            this.lastRet = ShortCollections.interval(first, last);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.base.addInterval(this.lastRet.first(), this.lastRet.last());
            this.lastRet = null;
            this.next = this.base.getLowerEntry(this.cursor);
        }
    }

    private static class ForwardComplementSubIntervalIterator
    implements Iterator {
        final ShortIntervalSet base;
        final short min;
        final short max;
        ShortInterval prev;
        short cursor;
        Entry next;
        ShortInterval lastRet;

        ForwardComplementSubIntervalIterator(ShortIntervalSet base, short min, short max) {
            this.base = base;
            this.min = min;
            this.max = max;
            this.cursor = min;
            Entry e = base.getFloorEntry(min);
            if (e != null) {
                this.cursor = e.last > min ? e.last : min;
                this.next = ShortIntervalSet.successor(e);
            } else {
                this.cursor = min;
                this.next = base.getHigherEntry(min);
            }
        }

        public boolean hasNext() {
            return this.cursor < this.max;
        }

        public Object next() {
            short last;
            short first;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short s = first = this.cursor > this.min ? (short)(this.cursor + 1) : this.min;
            if (this.next == null) {
                this.cursor = last = this.max;
            } else {
                last = (short)(this.next.first - 1);
                if (last > this.max) {
                    last = this.max;
                }
                this.cursor = this.next.last;
                this.next = ShortIntervalSet.successor(this.next);
            }
            this.lastRet = ShortCollections.interval(first, last);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.base.addInterval(this.lastRet.first(), this.lastRet.last());
            this.lastRet = null;
            this.next = this.base.getHigherEntry(this.cursor);
        }
    }

    private static class ReverseSubItemIterator
    extends AbstractShortSortedSet.ReverseIntervalItemIterator {
        ReverseSubItemIterator(ShortIntervalSet base, short first, short last) {
            super(new ReverseSubIntervalIterator(base, first, last, base.getFloorEntry(last)));
        }

        public void remove() {
            boolean restructured;
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            ReverseSubIntervalIterator s = (ReverseSubIntervalIterator)this.it;
            if (this.currInterval != null) {
                short cfirst = this.currInterval.first();
                short clast = this.currInterval.last();
                restructured = this.lastRet < clast || cfirst == s.first || clast == s.last;
            } else {
                restructured = false;
            }
            s.base.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ReverseSubIntervalIterator(s.base, s.first, s.last, s.base.getLowerEntry(this.lastRet));
            }
        }
    }

    private static class ReverseSubIntervalIterator
    implements Iterator {
        final ShortIntervalSet base;
        Entry cursor;
        short first;
        short last;
        Entry lastRet;

        ReverseSubIntervalIterator(ShortIntervalSet base, short first, short last, Entry e) {
            this.base = base;
            this.first = first;
            this.last = last;
            this.cursor = e;
        }

        public boolean hasNext() {
            return this.cursor != null && this.cursor.last >= this.first;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = ShortIntervalSet.predecessor(this.cursor);
            return ShortIntervalSet.fix(this.lastRet, this.first, this.last);
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.first >= this.first) {
                if (this.lastRet.left != null && this.lastRet.right != null) {
                    this.cursor = this.lastRet;
                }
                this.base.delete(this.lastRet);
                this.lastRet = null;
            } else {
                this.cursor = null;
                this.base.removeInterval(this.lastRet.first, this.lastRet.last);
                this.lastRet = null;
            }
        }
    }

    private static class ForwardSubItemIterator
    extends AbstractShortSortedSet.ForwardIntervalItemIterator {
        ForwardSubItemIterator(ShortIntervalSet base, short first, short last) {
            super(new ForwardSubIntervalIterator(base, first, last, base.getCeilingEntry(first)));
        }

        public void remove() {
            boolean restructured;
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            ForwardSubIntervalIterator s = (ForwardSubIntervalIterator)this.it;
            if (this.currInterval != null) {
                short cfirst = this.currInterval.first();
                short clast = this.currInterval.last();
                restructured = this.lastRet > cfirst || cfirst == s.first || clast == s.last;
            } else {
                restructured = false;
            }
            s.base.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ForwardSubIntervalIterator(s.base, s.first, s.last, s.base.getHigherEntry(this.lastRet));
            }
        }
    }

    private static class ForwardSubIntervalIterator
    implements Iterator {
        final ShortIntervalSet base;
        Entry cursor;
        short first;
        short last;
        Entry lastRet;

        ForwardSubIntervalIterator(ShortIntervalSet base, short first, short last, Entry e) {
            this.base = base;
            this.first = first;
            this.last = last;
            this.cursor = e;
        }

        public boolean hasNext() {
            return this.cursor != null && this.cursor.first <= this.last;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = ShortIntervalSet.successor(this.cursor);
            return ShortIntervalSet.fix(this.lastRet, this.first, this.last);
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.last <= this.last) {
                if (this.lastRet.left != null && this.lastRet.right != null) {
                    this.cursor = this.lastRet;
                }
                this.base.delete(this.lastRet);
                this.lastRet = null;
            } else {
                this.cursor = null;
                this.base.removeInterval(this.lastRet.first, this.lastRet.last);
                this.lastRet = null;
            }
        }
    }

    private static abstract class AbstractSubIntervalIterator
    implements Iterator {
        protected final ShortIntervalSet base;
        protected final short min;
        protected final short max;
        protected ShortInterval curr;
        protected ShortInterval next;

        AbstractSubIntervalIterator(ShortIntervalSet base, short min, short max) {
            this.base = base;
            this.min = min;
            this.max = max;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = this.fetchNext();
            return this.curr;
        }

        protected abstract ShortInterval fetchNext();

        protected ShortInterval fix(ShortInterval r) {
            short first = r.first();
            short last = r.last();
            if (first >= this.min && last <= this.max) {
                return r;
            }
            if (first < this.min) {
                first = this.min;
            }
            if (last > this.max) {
                last = this.max;
            }
            return ShortCollections.interval(first, last);
        }
    }

    static class ComplementSubView
    extends AbstractShortSortedSet.AbstractComplementSubView
    implements Serializable {
        ComplementSubView(ShortIntervalSet base, short beg, short end) {
            super(base, beg, end);
        }

        public boolean addAll(ShortCollection c) {
            if (c == this) {
                return false;
            }
            if (c instanceof ShortIntervalSet) {
                if (c == this.base) {
                    return this.addInterval(this.beg, this.end);
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.addInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.addAll(c);
        }

        public boolean removeAll(ShortCollection c) {
            if (c == this) {
                boolean modified = !this.isEmpty();
                this.clear();
                return modified;
            }
            if (c instanceof ShortIntervalSet) {
                if (c == this.base) {
                    return this.removeInterval(this.min(), this.max());
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.removeInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.removeAll(c);
        }

        public Iterator intervalIterator() {
            return new ForwardComplementSubIntervalIterator((ShortIntervalSet)this.base, this.beg, this.end);
        }

        public Iterator descendingIntervalIterator() {
            return new ReverseComplementSubIntervalIterator((ShortIntervalSet)this.base, this.beg, this.end);
        }

        public ShortSortedSet subSet(short first, short last) {
            if (first == this.beg && last == this.end) {
                return this;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return new ComplementSubView((ShortIntervalSet)this.base, first, last);
        }

        public ShortSet complementSet() {
            if (this.beg == Short.MIN_VALUE && this.end == Short.MAX_VALUE) {
                return this.base;
            }
            return this.base.subSet(this.beg, this.end);
        }
    }

    static class SubView
    extends AbstractShortSortedSet.AbstractSubView
    implements Serializable {
        SubView(ShortIntervalSet base, short min, short max) {
            super(base, min, max);
        }

        public boolean addAll(ShortCollection c) {
            if (c == this) {
                return false;
            }
            if (c instanceof ShortIntervalSet) {
                if (c == this.base) {
                    return false;
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return false;
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return this.addInterval(s.min(), s.max());
                }
            }
            return super.addAll(c);
        }

        public boolean removeAll(ShortCollection c) {
            if (c == this) {
                boolean modified = !this.isEmpty();
                this.clear();
                return modified;
            }
            if (c instanceof ShortIntervalSet) {
                if (c == this.base) {
                    return this.removeInterval(this.min(), this.max());
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.removeInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.removeAll(c);
        }

        public Iterator intervalIterator() {
            ShortIntervalSet lbase = (ShortIntervalSet)this.base;
            return new ForwardSubIntervalIterator(lbase, this.beg, this.end, lbase.getCeilingEntry(this.beg));
        }

        public ShortIterator iterator() {
            ShortIntervalSet lbase = (ShortIntervalSet)this.base;
            return new ForwardSubItemIterator(lbase, this.beg, this.end);
        }

        public Iterator descendingIntervalIterator() {
            ShortIntervalSet lbase = (ShortIntervalSet)this.base;
            return new ReverseSubIntervalIterator(lbase, this.beg, this.end, lbase.getFloorEntry(this.end));
        }

        public ShortIterator descendingIterator() {
            ShortIntervalSet lbase = (ShortIntervalSet)this.base;
            return new ReverseSubItemIterator(lbase, this.beg, this.end);
        }

        public ShortSet complementSet() {
            return new ComplementSubView((ShortIntervalSet)this.base, this.beg, this.end);
        }

        public ShortSortedSet subSet(short first, short last) {
            if (first == this.beg && last == this.end) {
                return this;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return this.base.subSet(first, last);
        }
    }

    private class ReverseItemIterator
    extends AbstractShortSortedSet.ReverseIntervalItemIterator {
        ReverseItemIterator() {
            super(new ReverseIntervalIterator(ShortIntervalSet.this.getLastEntry()));
        }

        public void remove() {
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            boolean restructured = this.currInterval != null && this.lastRet < this.currInterval.last();
            ShortIntervalSet.this.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ReverseIntervalIterator(ShortIntervalSet.this.getLowerEntry(this.lastRet));
            }
        }
    }

    private class ReverseIntervalIterator
    implements Iterator {
        Entry cursor;
        Entry lastRet;

        ReverseIntervalIterator(Entry cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = ShortIntervalSet.predecessor(this.cursor);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            ShortIntervalSet.this.size = (short)(ShortIntervalSet.this.size + (this.cursor.last - this.cursor.first + 1));
            if (this.lastRet.left != null && this.lastRet.right != null) {
                this.cursor = this.lastRet;
            }
            ShortIntervalSet.this.delete(this.lastRet);
            this.lastRet = null;
        }
    }

    private class ForwardItemIterator
    extends AbstractShortSortedSet.ForwardIntervalItemIterator {
        ForwardItemIterator() {
            super(new ForwardIntervalIterator(ShortIntervalSet.this.getFirstEntry()));
        }

        public void remove() {
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            boolean restructured = this.currInterval != null && this.lastRet > this.currInterval.first();
            ShortIntervalSet.this.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ForwardIntervalIterator(ShortIntervalSet.this.getHigherEntry(this.lastRet));
            }
        }
    }

    private class ForwardIntervalIterator
    implements Iterator {
        Entry cursor;
        Entry lastRet;

        ForwardIntervalIterator(Entry cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = ShortIntervalSet.successor(this.cursor);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            ShortIntervalSet.this.size = (short)(ShortIntervalSet.this.size + (short)(this.cursor.last - this.cursor.first + 1));
            if (this.lastRet.left != null && this.lastRet.right != null) {
                this.cursor = this.lastRet;
            }
            ShortIntervalSet.this.delete(this.lastRet);
            this.lastRet = null;
        }
    }

    private static class Entry
    extends AbstractShortInterval {
        private static final boolean RED = false;
        private static final boolean BLACK = true;
        private short first;
        private short last;
        private Entry parent;
        private Entry left;
        private Entry right;
        private boolean color;

        Entry(short first, short last) {
            this.first = first;
            this.last = last;
        }

        protected short getFirst() {
            return this.first;
        }

        protected short getLast() {
            return this.last;
        }

        public short first() {
            return this.first;
        }

        public short last() {
            return this.last;
        }

        public short min() {
            return this.first;
        }

        public short max() {
            return this.last;
        }

        static /* synthetic */ short access$010(Entry x0) {
            short s = x0.first;
            x0.first = (short)(s - 1);
            return s;
        }

        static /* synthetic */ short access$108(Entry x0) {
            short s = x0.last;
            x0.last = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$008(Entry x0) {
            short s = x0.first;
            x0.first = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$110(Entry x0) {
            short s = x0.last;
            x0.last = (short)(s - 1);
            return s;
        }
    }
}

