/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.util.concurrent.Callback;
import java.io.PrintStream;

public class AsyncTask
implements Future {
    volatile boolean completed = false;
    CancellationException cancellationException;
    protected Cancellable cancellationHandler;
    final Callback callback;
    Object result;
    Throwable resultException;

    protected AsyncTask() {
        this(null);
    }

    protected AsyncTask(Callback cb) {
        this.callback = cb;
    }

    public boolean isDone() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object resultException = null;
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            if (this.cancellationHandler != null) {
                if (mayInterruptIfRunning) {
                    return this.cancellationHandler.cancel(true);
                }
                return false;
            }
            if (!this.completed) {
                this.cancellationException = new CancellationException("task cancelled");
                return true;
            }
            return false;
        }
    }

    public synchronized boolean isCancelled() {
        if (this.cancellationException != null) {
            return true;
        }
        if (this.cancellationHandler != null) {
            return this.cancellationHandler.isCancelled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCompleted(Object result) {
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            if (this.completed) {
                throw new IllegalStateException("task already completed");
            }
            this.completed = true;
            this.result = result;
            this.cancellationHandler = null;
            this.notifyAll();
        }
        this.invokeCallback(result, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFailed(Throwable exception) {
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            if (this.completed) {
                throw new IllegalStateException("task already completed");
            }
            this.completed = true;
            this.resultException = exception;
            this.cancellationHandler = null;
            this.notifyAll();
        }
        this.invokeCallback(null, exception);
    }

    public synchronized Object get() throws InterruptedException, ExecutionException {
        this.waitFor();
        return this.getResult();
    }

    public synchronized Object get(long timeout, TimeUnit tunit) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitFor(tunit.convert(timeout, TimeUnit.MILLISECONDS));
        if (!this.completed) {
            throw new TimeoutException("Timeout when waiting for a result");
        }
        return this.getResult();
    }

    private void waitFor() throws InterruptedException {
        while (!this.completed) {
            this.wait();
        }
    }

    private void waitFor(long timeout) throws InterruptedException {
        while (!this.completed && timeout > 0L) {
            long timestart = System.currentTimeMillis();
            this.wait(timeout);
            if (this.completed) {
                return;
            }
            timeout -= System.currentTimeMillis() - timestart;
        }
    }

    private Object getResult() throws ExecutionException {
        if (this.resultException != null) {
            throw new ExecutionException("task completed abruptly", this.resultException);
        }
        return this.result;
    }

    public static AsyncTask start(Executor executor, Callable call) {
        return AsyncTask.start(executor, call, null);
    }

    public static AsyncTask start(Executor executor, Callable call, Callback cb) {
        return AsyncTask.start(executor, call, cb, false);
    }

    public static AsyncTask start(Executor executor, Callable call, Callback cb, boolean disableStackTraces) {
        AsyncTask task = new AsyncTask(cb);
        executor.execute(task.createPerformer(call, disableStackTraces));
        return task;
    }

    protected Runnable createPerformer(final Callable call, boolean disableStackTraces) {
        final Throwable stackCxt = disableStackTraces ? null : new Throwable();
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (AsyncTask.this.cancellationException != null) {
                            throw AsyncTask.this.cancellationException;
                        }
                        AsyncTask.this.cancellationHandler = AsyncTask.this.createCancellationHandler(call);
                    }
                    Object result = call.call();
                    1 var2_4 = this;
                    synchronized (var2_4) {
                        AsyncTask.this.cancellationHandler = null;
                        if (Thread.interrupted()) {
                            throw new InterruptedException("Task interrupted");
                        }
                    }
                    AsyncTask.this.setCompleted(result);
                }
                catch (Throwable ex) {
                    if (stackCxt != null) {
                        AsyncTask.appendContextStackTrace(ex, stackCxt);
                    }
                    AsyncTask.this.setFailed(ex);
                }
            }
        };
    }

    protected Cancellable createCancellationHandler(Callable call) {
        if (call instanceof Cancellable) {
            return (Cancellable)call;
        }
        final Thread workThread = Thread.currentThread();
        return new Cancellable(){

            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning) {
                    workThread.interrupt();
                    return true;
                }
                return false;
            }

            public boolean isDone() {
                return false;
            }

            public boolean isCancelled() {
                return workThread.isInterrupted();
            }
        };
    }

    private static void appendContextStackTrace(Throwable ex, Throwable cxt) {
        StackTraceElement[] exTrace = ex.getStackTrace();
        StackTraceElement[] cxtTrace = cxt.getStackTrace();
        StackTraceElement[] combinedTrace = new StackTraceElement[exTrace.length + cxtTrace.length];
        System.arraycopy(exTrace, 0, combinedTrace, 0, exTrace.length);
        System.arraycopy(cxtTrace, 0, combinedTrace, exTrace.length, cxtTrace.length);
        ex.setStackTrace(combinedTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCallback(Object result, Throwable resultException) {
        if (this.callback != null) {
            try {
                if (resultException != null) {
                    this.callback.failed(resultException);
                } else {
                    this.callback.completed(result);
                }
            }
            catch (Throwable error) {
                PrintStream s;
                PrintStream printStream = s = System.err;
                synchronized (printStream) {
                    s.print("Exception occured within callback: ");
                    error.printStackTrace(s);
                }
            }
        }
    }

    public static interface Cancellable {
        public boolean cancel(boolean var1);

        public boolean isCancelled();
    }
}

