/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.util.collections.WeakIdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class DelegatableThreadLocal
extends InheritableThreadLocal {
    private static ThreadLocalMap threadLocalMap = new ThreadLocalMap();

    public Object get() {
        Map tlmap = (Map)threadLocalMap.get();
        Object value = tlmap.get(this);
        if (value != null) {
            return value;
        }
        if (tlmap.containsKey(this)) {
            return null;
        }
        value = this.initialValue();
        tlmap.put(this, value);
        return value;
    }

    public void set(Object value) {
        Map tlmap = (Map)threadLocalMap.get();
        tlmap.put(this, value);
    }

    protected Object initialValue() {
        return null;
    }

    protected Object childValue(Object parentValue) {
        return parentValue;
    }

    protected Object snapshotValue(Object origValue) {
        return origValue;
    }

    protected Object delegatedValue(Object snapshotValue) {
        return snapshotValue;
    }

    protected void onUndelegated(Object undelegatedValue) {
    }

    static Map takeSnapshot() {
        Map map = (Map)threadLocalMap.get();
        WeakIdentityHashMap snapshot = new WeakIdentityHashMap(map.size());
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            DelegatableThreadLocal dtl = (DelegatableThreadLocal)entry.getKey();
            snapshot.put(dtl, dtl.snapshotValue(entry.getValue()));
        }
        return snapshot;
    }

    static Map delegate(Map snapshot) {
        Map oldmap = (Map)threadLocalMap.get();
        WeakIdentityHashMap newmap = new WeakIdentityHashMap(snapshot.size());
        Iterator itr = snapshot.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            DelegatableThreadLocal dtl = (DelegatableThreadLocal)entry.getKey();
            newmap.put(dtl, dtl.delegatedValue(entry.getValue()));
        }
        threadLocalMap.set(newmap);
        return oldmap;
    }

    static void restore(Map oldmap) {
        Map map = (Map)threadLocalMap.get();
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            DelegatableThreadLocal dtl = (DelegatableThreadLocal)entry.getKey();
            dtl.onUndelegated(entry.getValue());
        }
        threadLocalMap.set(oldmap);
    }

    private static class ThreadLocalMap
    extends InheritableThreadLocal {
        private ThreadLocalMap() {
        }

        protected Object initialValue() {
            return new WeakIdentityHashMap();
        }

        protected Object childValue(Object parentValue) {
            Map oldmap = (Map)parentValue;
            WeakIdentityHashMap newmap = new WeakIdentityHashMap(oldmap.size());
            Iterator itr = oldmap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                DelegatableThreadLocal dtl = (DelegatableThreadLocal)entry.getKey();
                newmap.put(dtl, dtl.childValue(entry.getValue()));
            }
            return newmap;
        }
    }
}

