/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import edu.emory.mathcs.util.collections.WeakValueHashMap;
import java.util.HashSet;
import java.util.Set;

public class ReentrantNamedLock
implements Lock {
    private final Object name;
    private final ReentrantLock resolvedLock;
    private static WeakValueHashMap lockResolver = new WeakValueHashMap();
    private static Set lockedLocks = new HashSet();

    public ReentrantNamedLock(Object name) {
        this.name = name;
        this.resolvedLock = ReentrantNamedLock.getLockFor(name);
    }

    public void lock() {
        this.resolvedLock.lock();
        if (this.resolvedLock.getHoldCount() == 1) {
            ReentrantNamedLock.pin(this.resolvedLock);
        }
    }

    public boolean tryLock() {
        if (!this.resolvedLock.tryLock()) {
            return false;
        }
        if (this.resolvedLock.getHoldCount() == 1) {
            ReentrantNamedLock.pin(this.resolvedLock);
        }
        return true;
    }

    public void lockInterruptibly() throws InterruptedException {
        this.resolvedLock.lockInterruptibly();
        if (this.resolvedLock.getHoldCount() == 1) {
            ReentrantNamedLock.pin(this.resolvedLock);
        }
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.resolvedLock.tryLock(timeout, unit)) {
            return false;
        }
        if (this.resolvedLock.getHoldCount() == 1) {
            ReentrantNamedLock.pin(this.resolvedLock);
        }
        return true;
    }

    public void unlock() {
        if (this.resolvedLock.getHoldCount() == 1) {
            ReentrantNamedLock.unpin(this.resolvedLock);
        }
        this.resolvedLock.unlock();
    }

    public Condition newCondition() {
        return this.resolvedLock.newCondition();
    }

    static synchronized ReentrantLock getLockFor(Object name) {
        ReentrantLock lock = (ReentrantLock)lockResolver.get(name);
        if (lock == null) {
            lock = new ReentrantLock();
            lockResolver.put(name, lock);
        }
        return lock;
    }

    static synchronized void pin(ReentrantLock lock) {
        lockedLocks.add(lock);
    }

    static synchronized void unpin(ReentrantLock lock) {
        lockedLocks.remove(lock);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReentrantNamedLock)) {
            return false;
        }
        ReentrantNamedLock that = (ReentrantNamedLock)other;
        return this.name.equals(that.name);
    }
}

