/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.ExecutorUtils;

public class SecureThreadPoolExecutor
extends ThreadPoolExecutor {
    public SecureThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ExecutorUtils.safeThreadFactory());
    }

    public SecureThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadGroup threadGroup, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, (ThreadFactory)new ExecutorUtils.SafeThreadFactory(threadGroup, name));
    }

    public SecureThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ExecutorUtils.safeThreadFactory(), handler);
    }

    public SecureThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadGroup threadGroup, String name, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, (ThreadFactory)new ExecutorUtils.SafeThreadFactory(threadGroup, name), handler);
    }

    public void execute(Runnable runnable) {
        super.execute(ExecutorUtils.delegatedRunnable(runnable));
    }

    public void setThreadFactory(ThreadFactory factory) {
        throw new UnsupportedOperationException("Secure pooled executor does not allow user-defined thread factories");
    }
}

