/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.gc;

import edu.emory.mathcs.util.gc.FinalizationGroup;
import edu.emory.mathcs.util.gc.ReferenceCleaner;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;

public class FinalizationEngine {
    final ReferenceCleaner cleaner;
    final boolean manageLifetime;
    private final Set activeGroupSet = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FinalizationEngine() {
        this(new ReferenceCleaner(), true);
    }

    public FinalizationEngine(ReferenceCleaner cleaner, boolean manageLifetime) {
        this.cleaner = cleaner;
        this.manageLifetime = manageLifetime;
    }

    public FinalizationGroup createGroup() {
        return this.createGroup(null);
    }

    public FinalizationGroup createGroup(String name) {
        return new FinalizationGroup(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void groupActivated(FinalizationGroup group) {
        FinalizationEngine finalizationEngine = this;
        synchronized (finalizationEngine) {
            if (!$assertionsDisabled && this.activeGroupSet.contains(group)) {
                throw new AssertionError();
            }
            boolean wasEmpty = this.activeGroupSet.isEmpty();
            this.activeGroupSet.add(group);
            if (this.manageLifetime && wasEmpty) {
                this.cleaner.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void groupDeactivated(FinalizationGroup group) {
        FinalizationEngine finalizationEngine = this;
        synchronized (finalizationEngine) {
            boolean existed = this.activeGroupSet.remove(group);
            if (!$assertionsDisabled && !existed) {
                throw new AssertionError();
            }
            if (this.manageLifetime && this.activeGroupSet.isEmpty()) {
                this.cleaner.stop();
            }
        }
    }

    ReferenceQueue getQueue() {
        return this.cleaner.getQueue();
    }

    static {
        $assertionsDisabled = !FinalizationEngine.class.desiredAssertionStatus();
    }
}

