/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.gc;

import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.Callback;
import edu.emory.mathcs.util.gc.FinalizationEngine;
import edu.emory.mathcs.util.gc.FinalizationFuture;
import edu.emory.mathcs.util.gc.FinalizationStatus;
import edu.emory.mathcs.util.gc.Finalizer;
import edu.emory.mathcs.util.gc.ReferenceCleaner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FinalizationGroup {
    private static final Logger logger;
    final FinalizationEngine engine;
    final String logID;
    final Map finalizers = new HashMap();
    boolean enabled;
    boolean completed;
    int pendingCount = 0;
    final List completionCallbacks = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    FinalizationGroup(FinalizationEngine engine, String name) {
        this.engine = engine;
        this.logID = "Finalization group " + (name != null ? name : "" + System.identityHashCode(this)) + ": ";
        this.enabled = true;
    }

    private synchronized boolean checkCompleted() {
        if (!this.completed && !this.enabled && this.finalizers.isEmpty()) {
            this.completed = true;
            this.notifyAll();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.logID + "completed");
            }
            return true;
        }
        return false;
    }

    private void runCompletionCallbacks() {
        Iterator itr = this.completionCallbacks.iterator();
        while (itr.hasNext()) {
            Callback cb = (Callback)itr.next();
            cb.completed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        boolean completedNow = false;
        FinalizationGroup finalizationGroup = this;
        synchronized (finalizationGroup) {
            this.enabled = false;
            completedNow = this.checkCompleted();
        }
        if (completedNow) {
            this.runCompletionCallbacks();
        }
    }

    public FinalizationFuture registerFinalizer(Object referrent, Finalizer finalizer) {
        return this.registerFinalizer(referrent, finalizer, false);
    }

    public synchronized FinalizationFuture registerFinalizer(Object referrent, Finalizer finalizer, boolean phantom) {
        if (finalizer == null) {
            throw new NullPointerException();
        }
        if (!this.enabled) {
            throw new IllegalStateException("Group is disabled");
        }
        WeakReference ref = phantom ? new PhantomFinalizableRef(referrent, this) : new WeakFinalizableRef(referrent, this);
        Registration reg = new Registration((FinalizableRef)((Object)ref), finalizer);
        this.finalizers.put(ref, reg);
        if (this.pendingCount++ == 0) {
            this.engine.groupActivated(this);
        }
        if (logger.isLoggable(Level.FINE)) {
            this.logFinalizer(Level.FINE, finalizer, "registered (" + (phantom ? "phantom" : "weak)"));
        }
        return reg;
    }

    private void logFinalizer(Level level, Finalizer finalizer, String msg) {
        logger.log(level, this.logID + " finalizer \"" + finalizer + "\": " + msg);
    }

    public synchronized boolean addCompletionCallback(Callback cb) {
        if (this.completed) {
            return false;
        }
        this.completionCallbacks.add(cb);
        return true;
    }

    public synchronized boolean areAllDone() {
        return this.completed;
    }

    public synchronized void awaitAllDone() throws InterruptedException {
        while (!this.completed) {
            this.wait();
        }
    }

    public synchronized void awaitAllDone(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.completed) {
            return;
        }
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        while (nanos > 0L) {
            TimeUnit.NANOSECONDS.timedWait((Object)this, nanos);
            if (this.completed) {
                return;
            }
            nanos = deadline - Utils.nanoTime();
        }
        throw new TimeoutException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean finalizeRef(FinalizableRef ref, boolean explicit) {
        FinalizationStatus status;
        Finalizer finalizer;
        Registration reg;
        FinalizationGroup finalizationGroup = this;
        synchronized (finalizationGroup) {
            reg = (Registration)this.finalizers.get(ref);
            if (reg == null) {
                return false;
            }
            ref.clear();
            switch (reg.state) {
                case 0: {
                    reg.setRunning();
                    finalizer = reg.finalizer;
                    break;
                }
                case 2: 
                case 3: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        try {
            status = finalizer.finalizeObject(explicit);
        }
        catch (Exception e) {
            this.setFinalized(reg, null, e);
            return true;
        }
        if (status == null) {
            this.setFinalized(reg, null, null);
        } else {
            boolean async = status.addCompletionCallback(new Callback(){

                public void completed(Object result) {
                    FinalizationGroup.this.setFinalized(reg, result, null);
                }

                public void failed(Throwable cause) {
                    FinalizationGroup.this.setFinalized(reg, null, cause);
                }
            });
            if (async) {
                this.setAsync(reg, status);
            } else {
                this.setFinalized(reg, status.result, status.exception);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finalizeAll() {
        FinalizableRef[] refs;
        boolean result = false;
        FinalizationGroup finalizationGroup = this;
        synchronized (finalizationGroup) {
            if (this.enabled) {
                throw new IllegalStateException("Group is not disabled");
            }
            refs = this.finalizers.keySet().toArray(new FinalizableRef[this.finalizers.size()]);
        }
        for (int i = 0; i < refs.length; ++i) {
            result |= this.finalizeRef(refs[i], true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelAll(boolean mayInterruptIfRunning) {
        FinalizableRef[] refs;
        boolean result = false;
        FinalizationGroup finalizationGroup = this;
        synchronized (finalizationGroup) {
            refs = this.finalizers.keySet().toArray(new FinalizableRef[this.finalizers.size()]);
        }
        for (int i = 0; i < refs.length; ++i) {
            result |= this.cancelRef(refs[i], mayInterruptIfRunning);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsync(Registration reg, FinalizationStatus status) {
        boolean cancelled = false;
        FinalizationGroup finalizationGroup = this;
        synchronized (finalizationGroup) {
            switch (reg.state) {
                case 0: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
                case 2: {
                    reg.setAsync(status);
                    break;
                }
                case 3: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
                case 4: {
                    cancelled = true;
                    break;
                }
            }
        }
        if (cancelled) {
            status.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFinalized(Registration reg, Object result, Throwable exception) {
        boolean finalized = false;
        FinalizationGroup finalizationGroup = this;
        synchronized (finalizationGroup) {
            switch (reg.state) {
                case 0: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    Registration curr = (Registration)this.finalizers.remove(reg.ref);
                    if (!$assertionsDisabled && curr != reg) {
                        throw new AssertionError();
                    }
                    reg.setFinalized(result, exception);
                    finalized = true;
                    break;
                }
                case 4: 
                case 5: {
                    return;
                }
            }
        }
        if (finalized) {
            reg.fireCallbacks(exception);
            if (this.checkCompleted()) {
                this.runCompletionCallbacks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelRef(FinalizableRef ref, boolean mayInterruptIfRunning) {
        Registration reg;
        boolean cancelled = false;
        FinalizationStatus asyncStatus = null;
        FinalizationGroup finalizationGroup = this;
        synchronized (finalizationGroup) {
            reg = (Registration)this.finalizers.get(ref);
            if (reg == null) {
                return false;
            }
            ref.clear();
            switch (reg.state) {
                case 0: {
                    this.finalizers.remove(ref);
                    reg.setCancelled();
                    cancelled = true;
                    if (--this.pendingCount != 0) break;
                    this.engine.groupDeactivated(this);
                    break;
                }
                case 2: {
                    this.finalizers.remove(ref);
                    reg.setCancelled();
                    cancelled = true;
                    break;
                }
                case 3: {
                    this.finalizers.remove(ref);
                    reg.setCancelled();
                    asyncStatus = reg.asyncStatus;
                    cancelled = true;
                    break;
                }
                case 4: 
                case 5: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
        if (asyncStatus != null) {
            asyncStatus.cancel(mayInterruptIfRunning);
        }
        if (cancelled) {
            reg.fireCallbacks((Throwable)new CancellationException());
            if (this.checkCompleted()) {
                this.runCompletionCallbacks();
            }
        }
        return cancelled;
    }

    static {
        $assertionsDisabled = !FinalizationGroup.class.desiredAssertionStatus();
        logger = Logger.getLogger("edu.emory.mathcs.util.gc.FinalizationGroup");
    }

    static class Registration
    implements FinalizationFuture {
        static final int STATE_PENDING = 0;
        static final int STATE_DEQUEUED = 1;
        static final int STATE_RUNNING = 2;
        static final int STATE_ASYNC = 3;
        static final int STATE_CANCELLED = 4;
        static final int STATE_FINALIZED = 5;
        int state;
        final Finalizer finalizer;
        volatile FinalizableRef ref;
        final List callbacks = new ArrayList();
        FinalizationStatus asyncStatus;
        Object result;
        Throwable exception;

        Registration(FinalizableRef ref, Finalizer finalizer) {
            this.ref = ref;
            this.finalizer = finalizer;
            this.state = 0;
        }

        public synchronized boolean isPending() {
            return this.state == 0;
        }

        public synchronized boolean isRunning() {
            return this.state == 2;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            FinalizableRef ref = this.ref;
            return ref != null ? ref.cancel(mayInterruptIfRunning) : false;
        }

        public boolean finalizeNow() {
            FinalizableRef ref = this.ref;
            return ref != null ? ref.finalizeNow() : false;
        }

        public synchronized boolean isDone() {
            return this.state == 4 || this.state == 5;
        }

        public synchronized boolean isCancelled() {
            return this.state == 4;
        }

        public boolean isEnqueued() {
            FinalizableRef ref = this.ref;
            return ref != null ? ref.isEnqueued() : false;
        }

        public boolean enqueue() {
            FinalizableRef ref = this.ref;
            return ref != null ? ref.enqueue() : false;
        }

        synchronized void setFinalized(Object result, Throwable exception) {
            FinalizableRef ref = this.ref;
            this.state = 5;
            this.result = result;
            this.exception = exception;
            this.ref = null;
            this.asyncStatus = null;
            this.notifyAll();
            if (logger.isLoggable(Level.FINE)) {
                ref.getGroup().logFinalizer(Level.FINE, this.finalizer, "finalized");
            }
        }

        synchronized void setCancelled() {
            FinalizableRef ref = this.ref;
            this.state = 4;
            this.ref = null;
            this.asyncStatus = null;
            this.notifyAll();
            if (logger.isLoggable(Level.FINE)) {
                ref.getGroup().logFinalizer(Level.FINE, this.finalizer, "cancelled");
            }
        }

        synchronized void setRunning() {
            this.state = 2;
            if (logger.isLoggable(Level.FINER)) {
                this.ref.getGroup().logFinalizer(Level.FINER, this.finalizer, "running");
            }
        }

        synchronized void setAsync(FinalizationStatus asyncStatus) {
            this.state = 3;
            this.asyncStatus = asyncStatus;
            if (logger.isLoggable(Level.FINER)) {
                this.ref.getGroup().logFinalizer(Level.FINER, this.finalizer, "asynchronous");
            }
        }

        private Object doGet() throws ExecutionException {
            if (this.state == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        public synchronized Object get() throws InterruptedException, ExecutionException {
            while (!this.isDone()) {
                this.wait();
            }
            return this.doGet();
        }

        public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
            if (this.isDone()) {
                return this.doGet();
            }
            long nanos = unit.toNanos(timeout);
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (nanos <= 0L) {
                    throw new TimeoutException();
                }
                TimeUnit.NANOSECONDS.timedWait((Object)this, nanos);
                if (this.isDone()) {
                    return this.doGet();
                }
                nanos = deadline - Utils.nanoTime();
            }
        }

        public synchronized boolean addCompletionCallback(Callback cb) {
            if (this.isDone()) {
                return false;
            }
            this.callbacks.add(cb);
            return true;
        }

        private void fireCallbacks(Throwable exception) {
            if (exception == null) {
                Iterator itr = this.callbacks.iterator();
                while (itr.hasNext()) {
                    Callback cb = (Callback)itr.next();
                    cb.completed(null);
                }
            } else {
                Iterator itr = this.callbacks.iterator();
                while (itr.hasNext()) {
                    Callback cb = (Callback)itr.next();
                    cb.failed(exception);
                }
            }
        }
    }

    static class PhantomFinalizableRef
    extends WeakReference
    implements FinalizableRef {
        final FinalizationGroup group;

        PhantomFinalizableRef(Object referrent, FinalizationGroup group) {
            super(referrent, group.engine.getQueue());
            this.group = group;
        }

        public void cleanReference() {
            this.group.finalizeRef(this, false);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.group.cancelRef(this, mayInterruptIfRunning);
        }

        public boolean finalizeNow() {
            return this.group.finalizeRef(this, true);
        }

        public FinalizationGroup getGroup() {
            return this.group;
        }
    }

    static class WeakFinalizableRef
    extends WeakReference
    implements FinalizableRef {
        final FinalizationGroup group;

        WeakFinalizableRef(Object referrent, FinalizationGroup group) {
            super(referrent, group.engine.getQueue());
            this.group = group;
        }

        public void cleanReference() {
            this.group.finalizeRef(this, false);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.group.cancelRef(this, mayInterruptIfRunning);
        }

        public boolean finalizeNow() {
            return this.group.finalizeRef(this, true);
        }

        public FinalizationGroup getGroup() {
            return this.group;
        }
    }

    static interface FinalizableRef
    extends ReferenceCleaner.CleanableReference {
        public boolean cancel(boolean var1);

        public boolean finalizeNow();

        public void clear();

        public boolean enqueue();

        public boolean isEnqueued();

        public FinalizationGroup getGroup();
    }
}

