/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import edu.emory.mathcs.util.io.XDR;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class BufferedDataOutputStream
extends OutputStream
implements DataOutput {
    private final OutputStream out;
    private final int BUFFER_SIZE;
    private int pos = 0;
    private final byte[] buffer;

    public BufferedDataOutputStream(OutputStream out) {
        this(out, 1024);
    }

    public BufferedDataOutputStream(OutputStream out, int buffer_size) {
        this.out = out;
        this.BUFFER_SIZE = buffer_size;
        this.buffer = new byte[this.BUFFER_SIZE];
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int lng) throws IOException {
        if (lng == 0 || b.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > b.length) {
            throw new IndexOutOfBoundsException("Array size " + b.length + " trying to read from " + (off + lng));
        }
        if (lng > this.BUFFER_SIZE || this.pos + lng > this.BUFFER_SIZE) {
            this.drain(0, this.pos);
            this.out.write(b, off, lng);
        } else {
            System.arraycopy(b, off, this.buffer, this.pos, lng);
            this.pos += lng;
        }
    }

    public void write(int b) throws IOException {
        if (this.pos == this.BUFFER_SIZE) {
            this.drain(0, this.pos);
        }
        this.buffer[this.pos++] = (byte)b;
    }

    public void close() throws IOException {
        this.drain(0, this.pos);
        this.out.close();
    }

    public void flush() throws IOException {
        this.drain(0, this.pos);
        this.out.flush();
    }

    protected void flushBuffer() throws IOException {
        this.drain(0, this.pos);
    }

    private void drain() throws IOException {
        this.drain(0, this.buffer.length);
    }

    private void drain(int lng) throws IOException {
        this.drain(0, lng);
    }

    private void drain(int off, int lng) throws IOException {
        this.out.write(this.buffer, off, lng);
        this.pos = 0;
    }

    public void writeByte(int b) throws IOException {
        if (this.pos == this.BUFFER_SIZE) {
            this.drain(0, this.pos);
        }
        this.buffer[this.pos++] = (byte)b;
    }

    public void writeBoolean(boolean b) throws IOException {
        if (this.pos > this.BUFFER_SIZE - 4) {
            this.drain(0, this.pos);
        }
        XDR.putBoolean(this.buffer, this.pos, b);
        this.pos += 4;
    }

    public void writeShort(int s) throws IOException {
        if (this.pos > this.BUFFER_SIZE - 2) {
            this.drain(0, this.pos);
        }
        XDR.putShort(this.buffer, this.pos, (short)s);
        this.pos += 2;
    }

    public void writeChar(int c) throws IOException {
        if (this.pos > this.BUFFER_SIZE - 2) {
            this.drain(0, this.pos);
        }
        XDR.putChar(this.buffer, this.pos, (char)c);
        this.pos += 2;
    }

    public void writeInt(int i) throws IOException {
        if (this.pos > this.BUFFER_SIZE - 4) {
            this.drain(0, this.pos);
        }
        XDR.putInt(this.buffer, this.pos, i);
        this.pos += 4;
    }

    public void writeLong(long l) throws IOException {
        if (this.pos > this.BUFFER_SIZE - 8) {
            this.drain(0, this.pos);
        }
        XDR.putLong(this.buffer, this.pos, l);
        this.pos += 8;
    }

    public void writeFloat(float f) throws IOException {
        if (this.pos > this.BUFFER_SIZE - 4) {
            this.drain(0, this.pos);
        }
        XDR.putFloat(this.buffer, this.pos, f);
        this.pos += 4;
    }

    public void writeDouble(double d) throws IOException {
        if (this.pos > this.BUFFER_SIZE - 8) {
            this.drain(0, this.pos);
        }
        XDR.putDouble(this.buffer, this.pos, d);
        this.pos += 8;
    }

    public void writeBytes(byte[] bytes, int off, int lng) throws IOException {
        this.write(bytes, off, lng);
    }

    public void writeBooleans(boolean[] booleans, int off, int lng) throws IOException {
        if (lng == 0 || booleans.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > booleans.length) {
            throw new IndexOutOfBoundsException("Array size " + booleans.length + " trying to read from " + (off + lng));
        }
        int pos = this.pos;
        int endPos = off + lng;
        while (off < endPos) {
            int begPos = off;
            int toWrite = Math.min(this.BUFFER_SIZE - pos >> 2, endPos - off);
            while (off - begPos < toWrite) {
                XDR.putBoolean(this.buffer, pos, booleans[off++]);
                pos += 4;
            }
            if (pos <= this.BUFFER_SIZE - 4) continue;
            this.drain(0, pos);
            pos = this.pos;
        }
        this.pos = pos;
    }

    public void writeChars(char[] chars, int off, int lng) throws IOException {
        if (lng == 0 || chars.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > chars.length) {
            throw new IndexOutOfBoundsException("Array size " + chars.length + " trying to read from " + (off + lng));
        }
        int pos = this.pos;
        int endPos = off + lng;
        while (off < endPos) {
            int begPos = off;
            int toWrite = Math.min(this.BUFFER_SIZE - pos >> 1, endPos - off);
            while (off - begPos < toWrite) {
                XDR.putChar(this.buffer, pos, chars[off++]);
                pos += 2;
            }
            if (pos <= this.BUFFER_SIZE - 2) continue;
            this.drain(0, pos);
            pos = this.pos;
        }
        this.pos = pos;
    }

    public void writeShorts(short[] shorts, int off, int lng) throws IOException {
        if (lng == 0 || shorts.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > shorts.length) {
            throw new IndexOutOfBoundsException("Array size " + shorts.length + " trying to read from " + (off + lng));
        }
        int pos = this.pos;
        int endPos = off + lng;
        while (off < endPos) {
            int begPos = off;
            int toWrite = Math.min(this.BUFFER_SIZE - pos >> 1, endPos - off);
            while (off - begPos < toWrite) {
                XDR.putShort(this.buffer, pos, shorts[off++]);
                pos += 2;
            }
            if (pos <= this.BUFFER_SIZE - 2) continue;
            this.drain(0, pos);
            pos = this.pos;
        }
        this.pos = pos;
    }

    public void writeInts(int[] ints, int off, int lng) throws IOException {
        if (lng == 0 || ints.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > ints.length) {
            throw new IndexOutOfBoundsException("Array size " + ints.length + " trying to read from " + (off + lng));
        }
        int pos = this.pos;
        int endPos = off + lng;
        while (off < endPos) {
            int begPos = off;
            int toWrite = Math.min(this.BUFFER_SIZE - pos >> 2, endPos - off);
            while (off - begPos < toWrite) {
                XDR.putInt(this.buffer, pos, ints[off++]);
                pos += 4;
            }
            if (pos <= this.BUFFER_SIZE - 4) continue;
            this.drain(0, pos);
            pos = this.pos;
        }
        this.pos = pos;
    }

    public void writeFloats(float[] floats, int off, int lng) throws IOException {
        if (lng == 0 || floats.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > floats.length) {
            throw new IndexOutOfBoundsException("Array size " + floats.length + " trying to read from " + (off + lng));
        }
        int pos = this.pos;
        int endPos = off + lng;
        while (off < endPos) {
            int begPos = off;
            int toWrite = Math.min(this.BUFFER_SIZE - pos >> 2, endPos - off);
            while (off - begPos < toWrite) {
                XDR.putFloat(this.buffer, pos, floats[off++]);
                pos += 4;
            }
            if (pos <= this.BUFFER_SIZE - 4) continue;
            this.drain(0, pos);
            pos = this.pos;
        }
        this.pos = pos;
    }

    public void writeLongs(long[] longs, int off, int lng) throws IOException {
        if (lng == 0 || longs.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > longs.length) {
            throw new IndexOutOfBoundsException("Array size " + longs.length + " trying to read from " + (off + lng));
        }
        int pos = this.pos;
        int endPos = off + lng;
        while (off < endPos) {
            int begPos = off;
            int toWrite = Math.min(this.BUFFER_SIZE - pos >> 3, endPos - off);
            while (off - begPos < toWrite) {
                XDR.putLong(this.buffer, pos, longs[off++]);
                pos += 8;
            }
            if (pos <= this.BUFFER_SIZE - 8) continue;
            this.drain(0, pos);
            pos = this.pos;
        }
        this.pos = pos;
    }

    public void writeDoubles(double[] doubles, int off, int lng) throws IOException {
        if (lng == 0 || doubles.length == 0) {
            return;
        }
        if (off < 0 || lng < 0 || off + lng > doubles.length) {
            throw new IndexOutOfBoundsException("Array size " + doubles.length + " trying to read from " + (off + lng));
        }
        int pos = this.pos;
        int endPos = off + lng;
        while (off < endPos) {
            int begPos = off;
            int toWrite = Math.min(this.BUFFER_SIZE - pos >> 3, endPos - off);
            while (off - begPos < toWrite) {
                XDR.putDouble(this.buffer, pos, doubles[off++]);
                pos += 8;
            }
            if (pos <= this.BUFFER_SIZE - 8) continue;
            this.drain(0, pos);
            pos = this.pos;
        }
        this.pos = pos;
    }

    public void writeChars(String str) throws IOException {
        int lng = str.length();
        char[] chars = new char[lng];
        str.getChars(0, lng, chars, 0);
        this.writeChars(chars, 0, lng);
    }

    public void writeBytes(String str) throws IOException {
        byte[] bytes = str.getBytes();
        this.write(bytes, 0, bytes.length);
    }

    public void writeUTF(String str) throws IOException {
        int utfLng = this.getUTFStringLength(str);
        if (utfLng == 0) {
            return;
        }
        if (utfLng > 65535) {
            throw new UTFDataFormatException("String too long. Length: " + utfLng);
        }
        if (utfLng == str.length()) {
            byte[] bytes = str.getBytes();
            this.writeShort((short)utfLng);
            this.write(bytes, 0, bytes.length);
            return;
        }
        byte[] bytes = new byte[utfLng];
        char[] chars = new char[str.length()];
        str.getChars(0, str.length(), chars, 0);
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c > '\u0000' && c < '\u0080') {
                bytes[pos++] = (byte)c;
                continue;
            }
            if (c > '\u0800') {
                bytes[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                bytes[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                bytes[pos++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            bytes[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
            bytes[pos++] = (byte)(0x80 | 0x3F & c);
        }
        this.writeShort((short)utfLng);
        this.write(bytes, 0, bytes.length);
    }

    protected int getUTFStringLength(String str) throws IOException {
        char[] chars = new char[str.length()];
        str.getChars(0, str.length(), chars, 0);
        int lng = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u0000' && chars[i] < '\u0080') {
                ++lng;
                continue;
            }
            if (chars[i] > '\u0800') {
                lng += 3;
                continue;
            }
            lng += 2;
        }
        return lng;
    }
}

