/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.util.allocator.Allocator;
import edu.emory.mathcs.util.allocator.PoolingAllocator;
import edu.emory.mathcs.util.io.TimedRedirectibleInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class BufferedPipe {
    static Allocator defaultAllocator = new PoolingAllocator(0x3200000L, 0x6400000L, 0x200000);
    final Allocator allocator;
    volatile Chunk begChunk;
    volatile Chunk endChunk;
    volatile boolean sourceClosed = false;
    volatile boolean sinkClosed = false;
    volatile int chunksize;
    final Object emptyLock = new Object();
    final Object fullLock = new Object();
    protected final OutputStream source = new OutputStream(){

        public synchronized void write(int v) throws IOException {
            BufferedPipe.this.write(v);
        }

        public synchronized void write(byte[] buf, int off, int len) throws IOException {
            BufferedPipe.this.write(buf, off, len);
        }

        public void close() {
            BufferedPipe.this.closeSource();
        }
    };
    protected final InputStream sink = new PipeRedirectibleInputStream();
    volatile Thread writerThread;
    private static final int DATA = 1;
    private static final int EOF = 2;
    private static final int TIMEOUT = 3;

    public BufferedPipe() {
        this(8192);
    }

    public BufferedPipe(int chunksize) {
        this(defaultAllocator, chunksize);
    }

    public BufferedPipe(Allocator allocator) {
        this(allocator, 8192);
    }

    public BufferedPipe(Allocator allocator, int chunksize) {
        this.allocator = allocator;
        this.chunksize = chunksize;
    }

    public OutputStream source() {
        return this.source;
    }

    public InputStream sink() {
        return this.sink;
    }

    public long length() {
        long length = 0L;
        Chunk current = this.begChunk;
        while (current != null) {
            length += (long)(current.end - current.beg);
            current = current.next;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(long timeout) throws IOException, TimeoutException {
        switch (this.ensureData(timeout)) {
            case 2: {
                return -1;
            }
            case 3: {
                throw new TimeoutException("read timeout");
            }
        }
        Chunk current = this.begChunk;
        byte[] data = current.data;
        int beg = current.beg;
        Chunk chunk = current;
        synchronized (chunk) {
            int end = current.end;
        }
        int v = current.data[beg++] & 0xFF;
        if (beg < data.length) {
            current.beg = beg;
        } else {
            Chunk next = current.next;
            if (next != null) {
                this.begChunk = next;
            } else {
                Object object = this.emptyLock;
                synchronized (object) {
                    this.begChunk = next = current.next;
                }
            }
            current.reclaim();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] buf, int off, int len, long timeout) throws IOException, TimeoutException {
        switch (this.ensureData(timeout)) {
            case 2: {
                return -1;
            }
            case 3: {
                throw new TimeoutException("read timeout");
            }
        }
        Chunk current = this.begChunk;
        int read_total = 0;
        while (true) {
            int end;
            byte[] data = current.data;
            int beg = current.beg;
            Chunk chunk = current;
            synchronized (chunk) {
                end = current.end;
            }
            int read_now = len < end - beg ? len : end - beg;
            System.arraycopy(data, beg, buf, off, read_now);
            off += read_now;
            len -= read_now;
            read_total += read_now;
            if ((beg += read_now) < data.length) {
                current.beg = beg;
                return read_total;
            }
            Chunk next = current.next;
            if (next != null) {
                this.begChunk = next;
            } else {
                Object object = this.emptyLock;
                synchronized (object) {
                    this.begChunk = next = current.next;
                }
            }
            current.reclaim();
            if (next == null) {
                return read_total;
            }
            current = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(OutputStream os, int len, long timeout) throws IOException, TimeoutException {
        switch (this.ensureData(timeout)) {
            case 2: {
                return -1;
            }
            case 3: {
                throw new TimeoutException("read timeout");
            }
        }
        Chunk current = this.begChunk;
        int read_total = 0;
        while (true) {
            int end;
            byte[] data = current.data;
            int beg = current.beg;
            Chunk chunk = current;
            synchronized (chunk) {
                end = current.end;
            }
            int read_now = len < end - beg ? len : end - beg;
            os.write(data, beg, read_now);
            len -= read_now;
            read_total += read_now;
            if ((beg += read_now) < data.length) {
                current.beg = beg;
                return read_total;
            }
            Chunk next = current.next;
            if (next != null) {
                this.begChunk = next;
            } else {
                Object object = this.emptyLock;
                synchronized (object) {
                    this.begChunk = next = current.next;
                }
            }
            current.reclaim();
            if (next == null) {
                return read_total;
            }
            current = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int v) throws IOException {
        this.ensureSpace();
        Chunk current = this.endChunk;
        int end = current.end;
        current.data[end++] = (byte)v;
        Object object = current;
        synchronized (object) {
            current.end = end;
        }
        object = this.emptyLock;
        synchronized (object) {
            if (this.begChunk == null) {
                this.begChunk = current;
            }
            this.emptyLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            this.ensureSpace();
            Chunk current = this.endChunk;
            int end = current.end;
            byte[] data = current.data;
            int write = len < data.length - end ? len : data.length - end;
            System.arraycopy(buf, off, data, end, write);
            off += write;
            len -= write;
            end += write;
            Object object = current;
            synchronized (object) {
                current.end = end;
            }
            object = this.emptyLock;
            synchronized (object) {
                if (this.begChunk == null) {
                    this.begChunk = current;
                }
                this.emptyLock.notify();
            }
        }
    }

    void closeSource() {
        this.sourceClosed = true;
        this.fireIOStateChanged();
    }

    void closeSink() {
        this.sinkClosed = true;
        this.fireIOStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIOStateChanged() {
        Object object = this.emptyLock;
        synchronized (object) {
            this.emptyLock.notify();
        }
        object = this.fullLock;
        synchronized (object) {
            Thread writerThread = this.writerThread;
            if (writerThread != null) {
                writerThread.interrupt();
            }
        }
    }

    private boolean isEmpty() {
        Chunk begChunk = this.begChunk;
        return begChunk == null || begChunk.beg == begChunk.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int ensureData(long timeout) throws IOException {
        if (this.sinkClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.isEmpty()) {
            return 1;
        }
        tgt = timeout <= 0L ? 0L : timeout + System.currentTimeMillis();
        var5_3 = this.emptyLock;
        synchronized (var5_3) {
            while (this.isEmpty() != false) {
                if (this.sinkClosed) {
                    throw new IOException("Stream closed");
                }
                if (this.sourceClosed) {
                    return 2;
                }
                if (tgt == 0L) {
                    this.emptyLock.wait();
                    continue;
                }
                this.emptyLock.wait(timeout);
                timeout = tgt - System.currentTimeMillis();
                if (timeout > 0L) {
                    continue;
                }
                ** break block11
            }
            return 1;
lbl-1000:
            // 1 sources

            {
                return 3;
            }
            catch (InterruptedException e) {
                throw BufferedPipe.newInterruptedIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSpace() throws IOException {
        Allocator.Buffer newbuf;
        Chunk chunk;
        block15: {
            this.checkWriteConsistency();
            chunk = this.endChunk;
            if (chunk != null && chunk.end < chunk.data.length) {
                return;
            }
            try {
                Object object;
                newbuf = this.allocator.allocate(this.chunksize, false, 0L);
                if (newbuf != null) break block15;
                Object object2 = this.fullLock;
                synchronized (object2) {
                    this.checkWriteConsistency();
                    this.writerThread = Thread.currentThread();
                }
                try {
                    newbuf = this.allocator.allocate(this.chunksize / 2, false, -1L);
                    Object var6_6 = null;
                    object = this.fullLock;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    Object object3 = this.fullLock;
                    synchronized (object3) {
                        this.writerThread = null;
                    }
                    throw throwable;
                }
                synchronized (object) {
                    this.writerThread = null;
                }
            }
            catch (InterruptedException e) {
                this.checkWriteConsistency();
                throw BufferedPipe.newInterruptedIOException(e);
            }
        }
        this.chunksize = newbuf.getSize() * 2;
        Chunk next = new Chunk(newbuf);
        if (chunk != null) {
            chunk.next = next;
            this.endChunk = next;
        } else {
            this.begChunk = next;
            this.endChunk = next;
        }
    }

    private void checkWriteConsistency() throws IOException {
        if (this.sourceClosed) {
            throw new IOException("Stream closed");
        }
        if (this.sinkClosed) {
            throw new IOException("Broken pipe");
        }
    }

    private static InterruptedIOException newInterruptedIOException(InterruptedException e) {
        InterruptedIOException io = new InterruptedIOException(e.toString());
        return io;
    }

    private class PipeRedirectibleInputStream
    extends InputStream
    implements TimedRedirectibleInput {
        private PipeRedirectibleInputStream() {
        }

        public synchronized int read() throws IOException {
            try {
                return BufferedPipe.this.read(0L);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized int timedRead(long timeout) throws IOException, TimeoutException {
            return BufferedPipe.this.read(timeout);
        }

        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            try {
                return BufferedPipe.this.read(buf, off, len, 0L);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized int timedRead(byte[] buf, int off, int len, long timeout) throws IOException, TimeoutException {
            return BufferedPipe.this.read(buf, off, len, timeout);
        }

        public synchronized int timedRead(byte[] buf, long timeout) throws IOException, TimeoutException {
            return BufferedPipe.this.read(buf, 0, buf.length, timeout);
        }

        public synchronized int redirect(OutputStream dest, int len) throws IOException {
            try {
                return BufferedPipe.this.read(dest, len, 0L);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized int timedRedirect(OutputStream dest, int len, long timeout) throws IOException, TimeoutException {
            return BufferedPipe.this.read(dest, len, timeout);
        }

        public synchronized int redirectAll(OutputStream dest) throws IOException {
            int total = 0;
            try {
                while (true) {
                    int read;
                    if ((read = BufferedPipe.this.read(dest, Integer.MAX_VALUE, 0L)) < 0) {
                        return total;
                    }
                    total += read;
                }
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            BufferedPipe.this.closeSink();
        }
    }

    static class Chunk {
        final Allocator.Buffer buf;
        final byte[] data;
        volatile int beg;
        volatile int end;
        volatile Chunk next;

        Chunk(Allocator.Buffer buf) {
            this.buf = buf;
            this.data = buf.getData();
            this.beg = 0;
            this.end = 0;
        }

        void reclaim() {
            this.buf.releaseRef();
        }
    }
}

